/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.aspect.administrative.BrowseParams;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.app.xmlui.utils.DSpaceValidity;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.RequestUtils;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.ReferenceSet;
import org.dspace.app.xmlui.wing.element.Select;
import org.dspace.authorize.AuthorizeException;
import org.dspace.browse.BrowseEngine;
import org.dspace.browse.BrowseException;
import org.dspace.browse.BrowseIndex;
import org.dspace.browse.BrowseInfo;
import org.dspace.browse.BrowserScope;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DCDate;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.sort.SortException;
import org.dspace.sort.SortOption;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class PrivateItems
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    private static final Logger log = Logger.getLogger(PrivateItems.class);
    private static final Message T_dspace_home = PrivateItems.message((String)"xmlui.general.dspace_home");
    private static final Message T_go = PrivateItems.message((String)"xmlui.general.go");
    private static final Message T_update = PrivateItems.message((String)"xmlui.general.update");
    private static final Message T_choose_month = PrivateItems.message((String)"xmlui.ArtifactBrowser.ConfigurableBrowse.general.choose_month");
    private static final Message T_choose_year = PrivateItems.message((String)"xmlui.ArtifactBrowser.ConfigurableBrowse.general.choose_year");
    private static final Message T_jump_year = PrivateItems.message((String)"xmlui.ArtifactBrowser.ConfigurableBrowse.general.jump_year");
    private static final Message T_jump_year_help = PrivateItems.message((String)"xmlui.ArtifactBrowser.ConfigurableBrowse.general.jump_year_help");
    private static final Message T_jump_select = PrivateItems.message((String)"xmlui.ArtifactBrowser.ConfigurableBrowse.general.jump_select");
    private static final Message T_starts_with = PrivateItems.message((String)"xmlui.ArtifactBrowser.ConfigurableBrowse.general.starts_with");
    private static final Message T_starts_with_help = PrivateItems.message((String)"xmlui.ArtifactBrowser.ConfigurableBrowse.general.starts_with_help");
    private static final Message T_sort_by = PrivateItems.message((String)"xmlui.ArtifactBrowser.ConfigurableBrowse.general.sort_by");
    private static final Message T_order = PrivateItems.message((String)"xmlui.ArtifactBrowser.ConfigurableBrowse.general.order");
    private static final Message T_no_results = PrivateItems.message((String)"xmlui.ArtifactBrowser.ConfigurableBrowse.general.no_results");
    private static final Message T_rpp = PrivateItems.message((String)"xmlui.ArtifactBrowser.ConfigurableBrowse.general.rpp");
    private static final Message T_order_asc = PrivateItems.message((String)"xmlui.ArtifactBrowser.ConfigurableBrowse.order.asc");
    private static final Message T_order_desc = PrivateItems.message((String)"xmlui.ArtifactBrowser.ConfigurableBrowse.order.desc");
    private static final String PRIVATE_URL_BASE = "private";
    private static final int ONE_YEAR_LIMIT = 10;
    private static final int FIVE_YEAR_LIMIT = 30;
    private static final int TEN_YEAR_LIMIT = 100;
    private static final int[] RESULTS_PER_PAGE_PROGRESSION = new int[]{5, 10, 20, 40, 60, 80, 100};
    private SourceValidity validity;
    private BrowseParams userParams;
    private BrowseInfo browseInfo;
    private Message titleMessage = null;
    private Message trailMessage = null;

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, parameters);
        try {
            this.getUserParams();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        catch (UIException e) {
            throw new RuntimeException(e);
        }
    }

    public Serializable getKey() {
        try {
            BrowseParams params = this.getUserParams();
            String key = params.getKey();
            if (key != null) {
                DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
                if (dso != null) {
                    key = key + "-" + dso.getHandle();
                }
                return Long.valueOf(HashUtil.hash((String)key));
            }
        }
        catch (SQLException e) {
            log.error((Object)"Database error", (Throwable)e);
        }
        catch (UIException e) {
            log.error((Object)"UI error", (Throwable)e);
        }
        return "0";
    }

    public SourceValidity getValidity() {
        if (this.validity == null) {
            try {
                DSpaceValidity newValidity = new DSpaceValidity();
                DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
                if (dso != null) {
                    newValidity.add(this.context, dso);
                }
                BrowseInfo info = this.getBrowseInfo();
                newValidity.add("total:" + info.getTotal());
                newValidity.add("start:" + info.getStart());
                for (Item item : info.getResults()) {
                    newValidity.add(this.context, (DSpaceObject)item);
                }
                this.validity = newValidity.complete();
            }
            catch (SQLException e) {
                log.error((Object)"Database error", (Throwable)e);
            }
            catch (UIException e) {
                log.error((Object)"UI error", (Throwable)e);
            }
        }
        return this.validity;
    }

    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        BrowseInfo info = this.getBrowseInfo();
        pageMeta.addMetadata("title").addContent(this.getTitleMessage(info));
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrail().addContent(this.getTrailMessage(info));
    }

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        BrowseParams params = null;
        params = this.getUserParams();
        BrowseInfo info = this.getBrowseInfo();
        String type = "private";
        Division div = body.addDivision("browse-by-" + type, "primary");
        div.setHead(this.getTitleMessage(info));
        this.addBrowseJumpNavigation(div, info, params);
        this.addBrowseControls(div, info, params);
        Division results = div.addDivision("browse-by-" + type + "-results", "primary");
        int itemsTotal = info.getTotal();
        if (itemsTotal > 0) {
            results.setSimplePagination(itemsTotal, this.browseInfo.getOverallPosition() + 1, this.browseInfo.getOverallPosition() + this.browseInfo.getResultCount(), this.getPreviousPageURL(params, info), this.getNextPageURL(params, info));
            ReferenceSet referenceSet = results.addReferenceSet("browse-by-" + type, "summaryList", type, null);
            for (Item item : info.getResults()) {
                referenceSet.addReference((Object)item);
            }
        } else {
            results.addPara(T_no_results);
        }
    }

    public void recycle() {
        this.validity = null;
        this.userParams = null;
        this.browseInfo = null;
        this.titleMessage = null;
        this.trailMessage = null;
        super.recycle();
    }

    private void addBrowseJumpNavigation(Division div, BrowseInfo info, BrowseParams params) throws WingException {
        HashMap queryParamsGET = new HashMap();
        queryParamsGET.putAll(params.getCommonParametersEncoded());
        queryParamsGET.putAll(params.getControlParameters());
        HashMap queryParamsPOST = new HashMap();
        queryParamsPOST.putAll(params.getCommonParameters());
        queryParamsPOST.putAll(params.getControlParameters());
        Division jump = div.addInteractiveDivision("browse-navigation", "private", "post", "secondary navigation");
        for (Map.Entry param : queryParamsPOST.entrySet()) {
            jump.addHidden((String)param.getKey()).setValue((String)param.getValue());
        }
        if (this.isSortedByDate(info)) {
            int currentYear;
            Para jumpForm = jump.addPara();
            jumpForm.addContent(T_jump_select);
            Select month = jumpForm.addSelect("month");
            month.addOption(false, "-1", T_choose_month);
            for (int i = 1; i <= 12; ++i) {
                month.addOption(false, String.valueOf(i), DCDate.getMonthName((int)i, (Locale)Locale.getDefault()));
            }
            Select year = jumpForm.addSelect("year");
            year.addOption(false, "-1", T_choose_year);
            int i = currentYear = DCDate.getCurrent().getYear();
            int oneYearBreak = (currentYear - 10) / 5 * 5;
            int fiveYearBreak = (currentYear - 30) / 10 * 10;
            int tenYearBreak = currentYear - 100;
            do {
                year.addOption(false, String.valueOf(i), String.valueOf(i));
                if (i <= fiveYearBreak) {
                    i -= 10;
                    continue;
                }
                if (i <= oneYearBreak) {
                    i -= 5;
                    continue;
                }
                --i;
            } while (i > tenYearBreak);
            jumpForm = jump.addPara();
            jumpForm.addContent(T_jump_year);
            jumpForm.addText("starts_with").setHelp(T_jump_year_help);
            jumpForm.addButton("submit").setValue(T_go);
        } else {
            List jumpList = jump.addList("jump-list", "simple", "alphabet");
            HashMap<String, String> letterQuery = new HashMap<String, String>(queryParamsGET);
            for (String valueKey : BrowseParams.FILTER_VALUE) {
                letterQuery.remove(valueKey);
            }
            letterQuery.put("starts_with", "0");
            jumpList.addItemXref(AbstractDSpaceTransformer.generateURL((String)"private", letterQuery), "0-9");
            for (char c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
                letterQuery.put("starts_with", Character.toString(c));
                jumpList.addItemXref(AbstractDSpaceTransformer.generateURL((String)"private", letterQuery), Character.toString(c));
            }
            Para jumpForm = jump.addPara();
            jumpForm.addContent(T_starts_with);
            jumpForm.addText("starts_with").setHelp(T_starts_with_help);
            jumpForm.addButton("submit").setValue(T_go);
        }
    }

    private void addBrowseControls(Division div, BrowseInfo info, BrowseParams params) throws WingException {
        HashMap queryParams = new HashMap();
        queryParams.putAll(params.getCommonParameters());
        Division controls = div.addInteractiveDivision("browse-controls", "private", "post", "browse controls");
        for (Map.Entry param : queryParams.entrySet()) {
            controls.addHidden((String)param.getKey()).setValue((String)param.getValue());
        }
        Para controlsForm = controls.addPara();
        try {
            Set sortOptions = SortOption.getSortOptions();
            if (sortOptions.size() > 1) {
                controlsForm.addContent(T_sort_by);
                Select sortSelect = controlsForm.addSelect("sort_by");
                for (SortOption so : sortOptions) {
                    sortSelect.addOption(so.equals(info.getSortOption()), so.getNumber(), PrivateItems.message((String)("xmlui.ArtifactBrowser.ConfigurableBrowse.sort_by." + so.getName())));
                }
            }
        }
        catch (SortException se) {
            throw new WingException("Unable to get sort options", (Throwable)se);
        }
        controlsForm.addContent(T_order);
        Select orderSelect = controlsForm.addSelect("order");
        orderSelect.addOption("ASC".equals(params.scope.getOrder()), "ASC", T_order_asc);
        orderSelect.addOption("DESC".equals(params.scope.getOrder()), "DESC", T_order_desc);
        controlsForm.addContent(T_rpp);
        Select rppSelect = controlsForm.addSelect("rpp");
        for (int i : RESULTS_PER_PAGE_PROGRESSION) {
            rppSelect.addOption(i == info.getResultsPerPage(), i, Integer.toString(i));
        }
        controlsForm.addButton("update").setValue(T_update);
    }

    private String getPreviousPageURL(BrowseParams params, BrowseInfo info) throws SQLException, UIException {
        if (info.isFirst()) {
            return null;
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.putAll(params.getCommonParametersEncoded());
        parameters.putAll(params.getControlParameters());
        if (info.hasPrevPage()) {
            parameters.put("offset", PrivateItems.encodeForURL((String)String.valueOf(info.getPrevOffset())));
        }
        return AbstractDSpaceTransformer.generateURL((String)"private", parameters);
    }

    private String getNextPageURL(BrowseParams params, BrowseInfo info) throws SQLException, UIException {
        if (info.isLast()) {
            return null;
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.putAll(params.getCommonParametersEncoded());
        parameters.putAll(params.getControlParameters());
        if (info.hasNextPage()) {
            parameters.put("offset", PrivateItems.encodeForURL((String)String.valueOf(info.getNextOffset())));
        }
        return AbstractDSpaceTransformer.generateURL((String)"private", parameters);
    }

    private BrowseParams getUserParams() throws SQLException, UIException {
        if (this.userParams != null) {
            return this.userParams;
        }
        Context context = ContextUtil.obtainContext((Map)this.objectModel);
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        BrowseParams params = new BrowseParams();
        params.month = request.getParameter("month");
        params.year = request.getParameter("year");
        params.etAl = RequestUtils.getIntParameter((Request)request, (String)"etal");
        params.scope = new BrowserScope(context);
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        if (dso instanceof Community) {
            params.scope.setCommunity((Community)dso);
        }
        if (dso instanceof Collection) {
            params.scope.setCollection((Collection)dso);
        }
        try {
            SortOption so;
            int sortBy = RequestUtils.getIntParameter((Request)request, (String)"sort_by");
            BrowseIndex bi = BrowseIndex.getPrivateBrowseIndex();
            if (sortBy == -1 && (so = bi.getSortOption()) != null) {
                sortBy = so.getNumber();
            }
            params.scope.setBrowseIndex(bi);
            params.scope.setSortBy(sortBy);
            params.scope.setJumpToItem(RequestUtils.getIntParameter((Request)request, (String)"focus"));
            params.scope.setOrder(request.getParameter("order"));
            int offset = RequestUtils.getIntParameter((Request)request, (String)"offset");
            params.scope.setOffset(offset > 0 ? offset : 0);
            params.scope.setResultsPerPage(RequestUtils.getIntParameter((Request)request, (String)"rpp"));
            params.scope.setStartsWith(PrivateItems.decodeFromURL((String)request.getParameter("starts_with")));
            String filterValue = request.getParameter(BrowseParams.FILTER_VALUE[0]);
            if (filterValue == null) {
                filterValue = request.getParameter(BrowseParams.FILTER_VALUE[1]);
            } else {
                params.scope.setAuthorityValue(filterValue);
            }
            params.scope.setFilterValue(filterValue);
            params.scope.setJumpToValue(PrivateItems.decodeFromURL((String)request.getParameter("vfocus")));
            params.scope.setJumpToValueLang(PrivateItems.decodeFromURL((String)request.getParameter("vfocus_lang")));
            params.scope.setFilterValueLang(PrivateItems.decodeFromURL((String)request.getParameter("value_lang")));
            if (params.scope.getFilterValue() != null) {
                params.scope.setBrowseLevel(1);
            }
            if (params.year != null && !"".equals(params.year) && !"-1".equals(params.year)) {
                String startsWith = params.year;
                if (params.month != null && !"-1".equals(params.month) && !"".equals(params.month)) {
                    if ("ASC".equals(params.scope.getOrder())) {
                        params.month = Integer.toString(Integer.parseInt(params.month) - 1);
                    }
                    if (params.month.length() == 1) {
                        params.month = "0" + params.month;
                    }
                    startsWith = params.year + "-" + params.month;
                    if ("ASC".equals(params.scope.getOrder())) {
                        startsWith = startsWith + "-32";
                    }
                }
                params.scope.setStartsWith(startsWith);
            }
        }
        catch (BrowseException bex) {
            throw new UIException("Unable to create browse parameters", (Throwable)bex);
        }
        this.userParams = params;
        return params;
    }

    private BrowseInfo getBrowseInfo() throws SQLException, UIException {
        if (this.browseInfo != null) {
            return this.browseInfo;
        }
        Context context = ContextUtil.obtainContext((Map)this.objectModel);
        BrowseParams params = this.getUserParams();
        try {
            BrowseEngine be = new BrowseEngine(context);
            this.browseInfo = be.browse(params.scope);
            if (params.etAl < 0) {
                int etAl = DSpaceServicesFactory.getInstance().getConfigurationService().getIntProperty("webui.browse.author-limit");
                if (etAl != 0) {
                    this.browseInfo.setEtAl(etAl);
                }
            } else if (params.etAl == 0) {
                this.browseInfo.setEtAl(-1);
            } else {
                this.browseInfo.setEtAl(params.etAl);
            }
        }
        catch (BrowseException bex) {
            throw new UIException("Unable to process browse", (Throwable)bex);
        }
        return this.browseInfo;
    }

    private boolean isSortedByDate(BrowseInfo info) {
        return info.getSortOption().isDate() || info.getBrowseIndex().isDate() && info.getSortOption().isDefault();
    }

    private Message getTitleMessage(BrowseInfo info) {
        if (this.titleMessage == null) {
            BrowseIndex bix = info.getBrowseIndex();
            this.titleMessage = bix.isMetadataIndex() ? PrivateItems.message((String)("xmlui.Administrative.PrivateItems.title.metadata." + bix.getName())) : (info.getSortOption() != null ? PrivateItems.message((String)("xmlui.Administrative.PrivateItems.title.item." + info.getSortOption().getName())) : PrivateItems.message((String)("xmlui.Administrative.PrivateItems.title.item." + bix.getSortOption().getName())));
        }
        return this.titleMessage;
    }

    private Message getTrailMessage(BrowseInfo info) {
        if (this.trailMessage == null) {
            BrowseIndex bix = info.getBrowseIndex();
            this.trailMessage = bix.isMetadataIndex() ? PrivateItems.message((String)("xmlui.Administrative.PrivateItems.trail.metadata." + bix.getName())) : (info.getSortOption() != null ? PrivateItems.message((String)("xmlui.Administrative.PrivateItems.trail.item." + info.getSortOption().getName())) : PrivateItems.message((String)("xmlui.Administrative.PrivateItems.trail.item." + bix.getSortOption().getName())));
        }
        return this.trailMessage;
    }
}

