/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.discovery;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.util.HashUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.excalibur.source.SourceValidity;
import org.apache.log4j.Logger;
import org.dspace.app.util.Util;
import org.dspace.app.xmlui.aspect.discovery.BrowseFacet;
import org.dspace.app.xmlui.aspect.discovery.DiscoveryUIUtils;
import org.dspace.app.xmlui.aspect.discovery.SearchFacetFilter;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.BadRequestException;
import org.dspace.app.xmlui.utils.DSpaceValidity;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.RequestUtils;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Cell;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.Select;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.discovery.DiscoverFacetField;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.SearchUtils;
import org.dspace.discovery.configuration.DiscoveryConfiguration;
import org.dspace.discovery.configuration.DiscoveryConfigurationParameters;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class SearchFacetFilter
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    private static final Logger log = Logger.getLogger(BrowseFacet.class);
    private static final Message T_dspace_home = SearchFacetFilter.message((String)"xmlui.general.dspace_home");
    private static final Message T_starts_with = SearchFacetFilter.message((String)"xmlui.Discovery.AbstractSearch.startswith");
    private static final Message T_starts_with_help = SearchFacetFilter.message((String)"xmlui.Discovery.AbstractSearch.startswith.help");
    private static DiscoveryConfigurationParameters.SORT sortOrder;
    protected DiscoverResult queryResults;
    protected SourceValidity validity;
    protected DiscoverQuery queryArgs;
    private int DEFAULT_PAGE_SIZE = 10;
    private int currentOffset = 0;
    private SearchService searchService = null;
    private static final Message T_go;
    private static final Message T_rpp;
    private static final int[] RESULTS_PER_PAGE_PROGRESSION;
    protected HandleService handleService = HandleServiceFactory.getInstance().getHandleService();

    public SearchFacetFilter() {
        this.searchService = (SearchService)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName(SearchService.class.getName(), SearchService.class);
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, parameters);
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String facetField = request.getParameter("field");
        if (StringUtils.isBlank((String)facetField)) {
            throw new BadRequestException("Invalid field parameter");
        }
    }

    public Serializable getKey() {
        try {
            DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
            if (dso == null) {
                return "0";
            }
            return Long.valueOf(HashUtil.hash((String)dso.getHandle()));
        }
        catch (SQLException sqle) {
            return "0";
        }
    }

    public SourceValidity getValidity() {
        if (this.validity == null) {
            try {
                DSpaceValidity newValidity = new DSpaceValidity();
                DSpaceObject dso = this.getScope();
                if (dso != null) {
                    newValidity.add(this.context, dso);
                }
                DiscoverResult response = this.getQueryResponse(dso);
                newValidity.add("numFound:" + response.getDspaceObjects().size());
                for (DSpaceObject resultDso : this.queryResults.getDspaceObjects()) {
                    newValidity.add(this.context, resultDso);
                }
                for (String facetField : this.queryResults.getFacetResults().keySet()) {
                    newValidity.add(facetField);
                    List facetValues = (List)this.queryResults.getFacetResults().get(facetField);
                    for (DiscoverResult.FacetResult facetValue : facetValues) {
                        newValidity.add(facetField + facetValue.getAsFilterQuery() + facetValue.getCount());
                    }
                }
                this.validity = newValidity.complete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.validity;
    }

    protected DiscoverResult getQueryResponse(DSpaceObject scope) {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        if (this.queryResults != null) {
            return this.queryResults;
        }
        this.queryArgs = new DiscoverQuery();
        DiscoveryConfiguration discoveryConfiguration = SearchUtils.getDiscoveryConfiguration((DSpaceObject)scope);
        List defaultFilterQueries = discoveryConfiguration.getDefaultFilterQueries();
        this.queryArgs.addFilterQueries(defaultFilterQueries.toArray(new String[defaultFilterQueries.size()]));
        this.queryArgs.setQuery(request.getParameter("query") != null && !"".equals(request.getParameter("query").trim()) ? request.getParameter("query") : null);
        this.queryArgs.setDSpaceObjectFilter(2);
        this.queryArgs.setMaxResults(0);
        this.queryArgs.addFilterQueries(DiscoveryUIUtils.getFilterQueries((Request)request, (Context)this.context));
        this.queryArgs.setFacetMinCount(1);
        int offset = RequestUtils.getIntParameter((Request)request, (String)"offset");
        if (offset == -1) {
            offset = 0;
        }
        this.queryArgs.setFacetOffset(offset);
        String facetField = request.getParameter("field");
        DiscoveryConfigurationParameters.SORT requestSortOrder = this.getSortOrder(request);
        DiscoverFacetField discoverFacetField = request.getParameter("starts_with") != null ? new DiscoverFacetField(facetField, "text", this.getPageSize() + 1, requestSortOrder, request.getParameter("starts_with").toLowerCase()) : new DiscoverFacetField(facetField, "text", this.getPageSize() + 1, requestSortOrder);
        this.queryArgs.addFacetField(discoverFacetField);
        try {
            this.queryResults = this.searchService.search(this.context, scope, this.queryArgs);
        }
        catch (SearchServiceException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return this.queryResults;
    }

    private DiscoveryConfigurationParameters.SORT getSortOrder(Request request) {
        String sortOrderString = request.getParameter("order");
        if (sortOrder != null && StringUtils.isBlank((String)sortOrderString)) {
            return sortOrder;
        }
        sortOrder = StringUtils.isBlank((String)sortOrderString) || DiscoveryConfigurationParameters.SORT.valueOf((String)sortOrderString.toUpperCase()) == null ? DiscoveryConfigurationParameters.SORT.VALUE : DiscoveryConfigurationParameters.SORT.valueOf((String)request.getParameter("order").toUpperCase());
        return sortOrder;
    }

    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, SQLException, IOException, AuthorizeException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String facetField = request.getParameter("field");
        pageMeta.addMetadata("title").addContent(SearchFacetFilter.message((String)("xmlui.Discovery.AbstractSearch.type_" + facetField)));
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        if (dso instanceof Collection || dso instanceof Community) {
            HandleUtil.buildHandleTrail((Context)this.context, (DSpaceObject)dso, (PageMeta)pageMeta, (String)this.contextPath, (boolean)true);
        }
        pageMeta.addTrail().addContent(SearchFacetFilter.message((String)("xmlui.Discovery.AbstractSearch.type_" + facetField)));
    }

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        this.updateQueryResultsAndOffset(request, dso);
        SearchFilterParam browseParams = new SearchFilterParam(request, null);
        Division div = body.addDivision("browse-by-" + request.getParameter("field"), "primary");
        div.setHead(SearchFacetFilter.message((String)("xmlui.Discovery.AbstractSearch.type_" + browseParams.getFacetField())));
        if (this.getSortOrder(request).equals((Object)DiscoveryConfigurationParameters.SORT.VALUE)) {
            this.addBrowseJumpNavigation(div, browseParams, request);
        }
        this.addBrowseControls(div, browseParams);
        if (this.queryResults != null) {
            LinkedHashMap facetFields = this.queryResults.getFacetResults();
            if (facetFields == null) {
                facetFields = new LinkedHashMap();
            }
            if (facetFields.size() > 0) {
                String facetField = facetFields.keySet().toArray(new String[facetFields.size()])[0];
                List values = (List)facetFields.get(facetField);
                Division results = body.addDivision("browse-by-" + facetField + "-results", "primary");
                if (values != null && 0 < values.size()) {
                    int offSet = this.queryArgs.getFacetOffset();
                    if (offSet == -1) {
                        offSet = 0;
                    }
                    this.currentOffset = offSet;
                    String nextPageUrl = null;
                    if (values.size() == this.getPageSize() + 1) {
                        nextPageUrl = this.getNextPageURL(browseParams, request);
                    }
                    int shownItemsMax = offSet + (this.getPageSize() < values.size() ? values.size() - 1 : values.size());
                    results.setSimplePagination((int)this.queryResults.getTotalSearchResults(), offSet + 1, shownItemsMax, this.getPreviousPageURL(browseParams, request), nextPageUrl);
                    Table singleTable = results.addTable("browse-by-" + facetField + "-results", this.queryResults.getDspaceObjects().size() + 1, 1);
                    List<String> filterQueries = Arrays.asList(DiscoveryUIUtils.getFilterQueries((Request)request, (Context)this.context));
                    int end = values.size();
                    if (this.getPageSize() < end) {
                        end = this.getPageSize();
                    }
                    for (int i = 0; i < end; ++i) {
                        DiscoverResult.FacetResult value = (DiscoverResult.FacetResult)values.get(i);
                        this.renderFacetField(browseParams, dso, facetField, singleTable, filterQueries, value);
                    }
                } else {
                    results.addPara(SearchFacetFilter.message((String)"xmlui.discovery.SearchFacetFilter.no-results"));
                }
            }
        }
    }

    private void updateQueryResultsAndOffset(Request request, DSpaceObject dso) {
        int configuredOffset = -1;
        boolean retainOffset = false;
        if (request.getParameters().containsKey("update")) {
            configuredOffset = this.currentOffset;
            retainOffset = true;
        }
        this.queryResults = this.getQueryResponse(dso);
        if (retainOffset) {
            this.queryArgs.setFacetOffset(configuredOffset);
        }
    }

    private void addBrowseJumpNavigation(Division div, SearchFilterParam browseParams, Request request) throws WingException, SQLException, UnsupportedEncodingException {
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        String action = dso != null ? this.contextPath + "/handle/" + dso.getHandle() + "/search-filter" : this.contextPath + "/search-filter";
        Division jump = div.addInteractiveDivision("filter-navigation", action, "post", "secondary navigation");
        HashMap params = new HashMap();
        params.putAll(browseParams.getCommonBrowseParams());
        for (Map.Entry param : params.entrySet()) {
            jump.addHidden((String)param.getKey()).setValue((String)param.getValue());
        }
        Map filterQueries = DiscoveryUIUtils.getParameterFilterQueries((Request)request);
        for (String parameter : filterQueries.keySet()) {
            for (int i = 0; i < ((String[])filterQueries.get(parameter)).length; ++i) {
                String value = ((String[])filterQueries.get(parameter))[i];
                jump.addHidden(parameter).setValue(value);
            }
        }
        if (!browseParams.getFacetField().endsWith(".year")) {
            org.dspace.app.xmlui.wing.element.List jumpList = jump.addList("jump-list", "simple", "alphabet");
            String basicUrl = SearchFacetFilter.generateURL((String)"search-filter", params);
            basicUrl = this.addFilterQueriesToUrl(basicUrl);
            for (char c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
                String linkUrl = basicUrl + "&" + "starts_with" + "=" + Character.toString(c).toLowerCase();
                jumpList.addItemXref(linkUrl, Character.toString(c));
            }
            Para jumpForm = jump.addPara();
            jumpForm.addContent(T_starts_with);
            jumpForm.addText("starts_with").setHelp(T_starts_with_help);
            jumpForm.addButton("submit").setValue(T_go);
        }
    }

    private void renderFacetField(SearchFilterParam browseParams, DSpaceObject dso, String facetField, Table singleTable, List<String> filterQueries, DiscoverResult.FacetResult value) throws SQLException, WingException, UnsupportedEncodingException {
        String displayedValue = value.getDisplayedValue();
        Cell cell = singleTable.addRow().addCell();
        if (filterQueries.contains(this.searchService.toFilterQuery(this.context, facetField, value.getFilterType(), value.getAsFilterQuery()).getFilterQuery())) {
            cell.addContent(displayedValue + " (" + value.getCount() + ")");
        } else {
            HashMap urlParams = new HashMap();
            urlParams.putAll(browseParams.getCommonBrowseParams());
            String xrefURL = SearchFacetFilter.generateURL((String)(this.contextPath + (dso == null ? "" : "/handle/" + dso.getHandle()) + "/discover"), urlParams);
            xrefURL = this.addFilterQueriesToUrl(xrefURL);
            xrefURL = xrefURL + "&filtertype=" + facetField;
            xrefURL = xrefURL + "&filter_relational_operator=" + value.getFilterType();
            xrefURL = xrefURL + "&filter=" + URLEncoder.encode(value.getAsFilterQuery(), "UTF-8");
            cell.addXref(xrefURL, displayedValue + " (" + value.getCount() + ")");
        }
    }

    private String getNextPageURL(SearchFilterParam browseParams, Request request) throws UnsupportedEncodingException, UIException {
        int offSet = Util.getIntParameter((HttpServletRequest)request, (String)"offset");
        if (offSet == -1) {
            offSet = this.currentOffset;
        }
        HashMap<String, String> urlParameters = new HashMap<String, String>();
        urlParameters.putAll(browseParams.getCommonBrowseParams());
        urlParameters.putAll(browseParams.getControlParameters());
        urlParameters.put("offset", String.valueOf(offSet + this.getPageSize()));
        urlParameters.put("order", this.getSortOrder(request).name());
        String newURL = SearchFacetFilter.generateURL((String)"search-filter", urlParameters);
        newURL = this.addFilterQueriesToUrl(newURL);
        return newURL;
    }

    private String getPreviousPageURL(SearchFilterParam browseParams, Request request) throws UnsupportedEncodingException, UIException {
        boolean currentOffsetSmallerOrEqualTO0;
        boolean bl = currentOffsetSmallerOrEqualTO0 = this.currentOffset <= 0;
        if (0 == this.queryArgs.getFacetOffset() && Util.getIntParameter((HttpServletRequest)request, (String)"offset") == -1 && currentOffsetSmallerOrEqualTO0) {
            return null;
        }
        int offset = Util.getIntParameter((HttpServletRequest)request, (String)"offset");
        if (currentOffsetSmallerOrEqualTO0 && (offset == -1 || offset == 0)) {
            return null;
        }
        HashMap<String, String> urlParameters = new HashMap<String, String>();
        urlParameters.putAll(browseParams.getCommonBrowseParams());
        urlParameters.putAll(browseParams.getControlParameters());
        urlParameters.put("order", this.getSortOrder(request).name());
        String offSet = String.valueOf(this.currentOffset - this.getPageSize() < 0 ? 0 : this.currentOffset - this.getPageSize());
        urlParameters.put("offset", offSet);
        String newURL = SearchFacetFilter.generateURL((String)"search-filter", urlParameters);
        newURL = this.addFilterQueriesToUrl(newURL);
        return newURL;
    }

    public void recycle() {
        this.queryResults = null;
        this.validity = null;
        super.recycle();
    }

    public String addFilterQueriesToUrl(String url) throws UIException {
        Map fqs = DiscoveryUIUtils.getParameterFilterQueries((Request)ObjectModelHelper.getRequest((Map)this.objectModel));
        if (fqs != null) {
            StringBuilder urlBuilder = new StringBuilder(url);
            for (String parameter : fqs.keySet()) {
                for (int i = 0; i < ((String[])fqs.get(parameter)).length; ++i) {
                    String value = ((String[])fqs.get(parameter))[i];
                    urlBuilder.append("&").append(parameter).append("=").append(SearchFacetFilter.encodeForURL((String)value));
                }
            }
            return urlBuilder.toString();
        }
        return url;
    }

    private DSpaceObject getScope() throws SQLException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String scopeString = request.getParameter("scope");
        DSpaceObject dso = scopeString == null || "".equals(scopeString) ? HandleUtil.obtainHandle((Map)this.objectModel) : this.handleService.resolveToObject(this.context, scopeString);
        return dso;
    }

    protected int getPageSize() {
        try {
            int rpp;
            this.DEFAULT_PAGE_SIZE = rpp = Integer.parseInt(ObjectModelHelper.getRequest((Map)this.objectModel).getParameter("rpp"));
            return rpp;
        }
        catch (Exception e) {
            return this.DEFAULT_PAGE_SIZE;
        }
    }

    private void addBrowseControls(Division div, SearchFilterParam params) throws WingException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.putAll(params.getCommonBrowseParams());
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        queryParams.put("order", request.getParameter("order"));
        String facetField = request.getParameter("field");
        Division controls = div.addInteractiveDivision("browse-controls", "search-filter?field=" + facetField, "post", "browse controls");
        for (Map.Entry param : queryParams.entrySet()) {
            controls.addHidden((String)param.getKey()).setValue((String)param.getValue());
        }
        Para controlsForm = controls.addPara();
        controlsForm.addContent(T_rpp);
        Select rppSelect = controlsForm.addSelect("rpp");
        for (int i : RESULTS_PER_PAGE_PROGRESSION) {
            rppSelect.addOption(i == this.getPageSize(), i, Integer.toString(i));
        }
        controlsForm.addButton("update").setValue("update");
    }

    static {
        T_go = SearchFacetFilter.message((String)"xmlui.general.go");
        T_rpp = SearchFacetFilter.message((String)"xmlui.Discovery.AbstractSearch.rpp");
        RESULTS_PER_PAGE_PROGRESSION = new int[]{5, 10, 20, 40, 60, 80, 100};
    }
}

