/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.submission.submit;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.AbstractGenerator;
import org.apache.cocoon.xml.dom.DOMStreamer;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.app.xmlui.wing.WingConstants;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.importer.external.datamodel.ImportRecord;
import org.dspace.importer.external.metadatamapping.MetadataFieldConfig;
import org.dspace.importer.external.metadatamapping.MetadatumDTO;
import org.dspace.importer.external.service.ImportService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.utils.DSpace;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class JSONLookupSearcher
extends AbstractGenerator {
    private ImportService importService;
    private String lookupURI = null;
    private static Logger log = Logger.getLogger(JSONLookupSearcher.class);
    private ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    private Request request;
    private Context context;

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        this.request = ObjectModelHelper.getRequest((Map)objectModel);
        try {
            this.context = ContextUtil.obtainContext((Map)objectModel);
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        this.importService = (ImportService)new DSpace().getServiceManager().getServiceByName(null, ImportService.class);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        int parsedStart;
        String query = this.request.getParameter("search");
        int start = 0;
        String startString = this.request.getParameter("start");
        if (StringUtils.isNotBlank((String)startString) && (parsedStart = Integer.parseInt(startString)) >= 0) {
            start = parsedStart;
        }
        try {
            int total = this.importService.getNbRecords(this.getLookupURI(), query);
            Collection records = this.importService.getRecords(this.getLookupURI(), query, start, 20);
            DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
            Document document = docBuilder.newDocument();
            Element rootnode = document.createElement("root");
            document.appendChild(rootnode);
            rootnode.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:i18n", WingConstants.I18N.URI);
            Element totalNode = document.createElement("total");
            totalNode.setTextContent(String.valueOf(total));
            rootnode.appendChild(totalNode);
            Element startNode = document.createElement("start");
            startNode.setTextContent(String.valueOf(start));
            rootnode.appendChild(startNode);
            Element recordsNode = document.createElement("records");
            recordsNode.setAttribute("array", "true");
            rootnode.appendChild(recordsNode);
            recordsNode.setAttribute("array", "true");
            MetadataFieldConfig importIdField = (MetadataFieldConfig)new DSpace().getServiceManager().getServiceByName("lookupID", MetadataFieldConfig.class);
            for (ImportRecord record : records) {
                Element recordWrapperNode = document.createElement("recordWrapper");
                recordWrapperNode.setAttribute("object", "true");
                recordsNode.appendChild(recordWrapperNode);
                Element recordNode = document.createElement("record");
                recordNode.setAttribute("namedObject", "true");
                HashMap<String, Element> metadatumValueNodes = new HashMap<String, Element>();
                for (MetadatumDTO metadatum : record.getValueList()) {
                    if (!metadatumValueNodes.containsKey(this.getField(metadatum))) {
                        Iterator iterator;
                        Element metadatumNode = document.createElement(this.getField(metadatum));
                        metadatumNode.setAttribute("array", "true");
                        metadatumValueNodes.put(this.getField(metadatum), metadatumNode);
                        if (this.getField(metadatum).equals(importIdField.getField()) && (iterator = this.itemService.findByMetadataField(this.context, importIdField.getSchema(), importIdField.getElement(), importIdField.getQualifier(), metadatum.getValue())).hasNext()) {
                            Element existsInDSpaceNode = document.createElement("imported");
                            existsInDSpaceNode.setTextContent("true");
                            recordNode.appendChild(existsInDSpaceNode);
                        }
                    }
                    Element metadatumValueNode = document.createElement("metadatumValue");
                    metadatumValueNode.setTextContent(metadatum.getValue());
                    ((Element)metadatumValueNodes.get(this.getField(metadatum))).appendChild(metadatumValueNode);
                }
                for (Element element : metadatumValueNodes.values()) {
                    recordNode.appendChild(element);
                }
                recordWrapperNode.appendChild(recordNode);
            }
            DOMStreamer streamer = new DOMStreamer(this.contentHandler, this.lexicalHandler);
            streamer.stream((Node)document);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private String getField(MetadatumDTO metadatum) {
        return metadatum.getSchema() + "." + metadatum.getElement() + (metadatum.getQualifier() != null ? "." + metadatum.getQualifier() : "");
    }

    public String getLookupURI() {
        if (this.lookupURI == null) {
            this.lookupURI = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("publication-lookup.publication.url");
        }
        return this.lookupURI;
    }

    public void setLookupURI(String lookupURI) {
        this.lookupURI = lookupURI;
    }
}

