/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.cocoon;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.reading.AbstractReader;
import org.apache.log4j.Logger;
import org.dspace.core.Utils;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.xml.sax.SAXException;

public class SitemapReader
extends AbstractReader
implements Recyclable {
    private static Logger log = Logger.getLogger(SitemapReader.class);
    protected Response response;
    protected Request request;
    protected String sitemapMimeType;
    private boolean forSitemapsOrg = false;

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        this.request = ObjectModelHelper.getRequest((Map)objectModel);
        this.response = ObjectModelHelper.getResponse((Map)objectModel);
        this.forSitemapsOrg = false;
        String type = par.getParameter("type", "html");
        if (type != null && type.equalsIgnoreCase("sitemaps.org")) {
            this.forSitemapsOrg = true;
        } else if (type == null || !type.equalsIgnoreCase("html")) {
            log.warn((Object)"Invalid initialization parameter for sitemapReader: assuming basic HTML");
        }
    }

    public void generate() throws IOException, ProcessingException {
        String param = this.request.getParameter("map");
        String ext = this.forSitemapsOrg ? ".xml.gz" : ".html";
        this.sitemapMimeType = this.forSitemapsOrg ? "text/xml" : "text/html";
        String fileStem = param == null ? "sitemap_index" : "sitemap" + param;
        this.sendFile(fileStem + ext, this.forSitemapsOrg);
    }

    private void sendFile(String file, boolean compressed) throws IOException, ResourceNotFoundException {
        File f = new File(DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("sitemap.dir"), file);
        HttpServletResponse httpResponse = (HttpServletResponse)this.objectModel.get("httpresponse");
        if (!f.exists()) {
            httpResponse.setStatus(404);
            throw new ResourceNotFoundException("Unable to locate sitemap");
        }
        long lastMod = f.lastModified();
        this.response.setDateHeader("Last-Modified", lastMod);
        long modSince = this.request.getDateHeader("If-Modified-Since");
        if (modSince != -1L && lastMod < modSince) {
            httpResponse.setStatus(304);
            return;
        }
        if (compressed) {
            this.response.setHeader("Content-Encoding", "gzip");
        }
        FileInputStream is = new FileInputStream(f);
        this.response.setHeader("Content-Type", this.sitemapMimeType);
        this.response.setHeader("Content-Length", String.valueOf(f.length()));
        Utils.bufferedCopy((InputStream)is, (OutputStream)this.out);
        ((InputStream)is).close();
        this.out.flush();
    }

    public String getMimeType() {
        return this.sitemapMimeType;
    }

    public void recycle() {
        this.response = null;
        this.request = null;
        this.sitemapMimeType = null;
        this.forSitemapsOrg = false;
    }
}

