/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.objectmanager;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dspace.app.util.Util;
import org.dspace.app.util.factory.UtilServiceFactory;
import org.dspace.app.util.service.MetadataExposureService;
import org.dspace.app.xmlui.objectmanager.AbstractAdapter;
import org.dspace.app.xmlui.objectmanager.SAXFilter;
import org.dspace.app.xmlui.wing.AttributeMap;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataValue;
import org.dspace.content.authority.Choices;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.DisseminationCrosswalk;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.BundleService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.output.SAXOutputter;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ItemAdapter
extends AbstractAdapter {
    private final Item item;
    private final List<Bitstream> contentBitstreams = new ArrayList();
    private Bitstream primaryBitstream;
    private StringBuffer dmdSecIDS;
    private StringBuffer amdSecIDS;
    private final Map<String, StringBuffer> fileAmdSecIDs = new HashMap();
    private final Context context;
    protected AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected BundleService bundleService = ContentServiceFactory.getInstance().getBundleService();
    protected BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    protected MetadataExposureService metadataExposureService = UtilServiceFactory.getInstance().getMetadataExposureService();

    public ItemAdapter(Context context, Item item, String contextPath) {
        super(contextPath);
        this.item = item;
        this.context = context;
    }

    public Item getItem() {
        return this.item;
    }

    protected String getMETSOBJID() {
        if (this.item.getHandle() != null) {
            return this.contextPath + "/handle/" + this.item.getHandle();
        }
        return null;
    }

    protected String getMETSOBJEDIT() {
        return this.contextPath + "/admin/item?itemID=" + this.item.getID();
    }

    protected String getMETSID() {
        if (this.item.getHandle() == null) {
            return "item:" + this.item.getID();
        }
        return "hdl:" + this.item.getHandle();
    }

    protected String getMETSProfile() throws WingException {
        return "DSPACE METS SIP Profile 1.0";
    }

    protected String getMETSLabel() {
        return "DSpace Item";
    }

    protected String getFileID(Bitstream bitstream) {
        return "file_" + bitstream.getID();
    }

    protected String getGroupFileID(Bitstream bitstream) {
        return "group_file_" + bitstream.getID();
    }

    protected String getAmdSecID(String admSecName, String mdType, DSpaceObject dso) {
        if (dso.getType() == 0) {
            return admSecName + "_" + this.getFileID((Bitstream)dso) + "_" + mdType;
        }
        return admSecName + "_" + dso.getID() + "_" + mdType;
    }

    protected void renderDescriptiveSection() throws WingException, SAXException, CrosswalkException, IOException, SQLException {
        AttributeMap attributes;
        String groupID = this.getGenericID("group_dmd_");
        this.dmdSecIDS = new StringBuffer();
        if (this.dmdTypes.isEmpty() || this.dmdTypes.contains("DIM")) {
            String dmdID = this.getGenericID("dmd_");
            this.dmdSecIDS.append(dmdID);
            attributes = new AttributeMap();
            attributes.put((Object)"ID", (Object)dmdID);
            attributes.put((Object)"GROUPID", (Object)groupID);
            this.startElement(METS, "dmdSec", new AttributeMap[]{attributes});
            attributes = new AttributeMap();
            attributes.put((Object)"MDTYPE", (Object)"OTHER");
            attributes.put((Object)"OTHERMDTYPE", (Object)"DIM");
            this.startElement(METS, "mdWrap", new AttributeMap[]{attributes});
            this.startElement(METS, "xmlData", new AttributeMap[0]);
            attributes = new AttributeMap();
            attributes.put((Object)"dspaceType", (Object)Constants.typeText[this.item.getType()]);
            if (this.item.isWithdrawn()) {
                attributes.put((Object)"withdrawn", (Object)"y");
            }
            this.startElement(DIM, "dim", new AttributeMap[]{attributes});
            List dcvs = this.itemService.getMetadata((DSpaceObject)this.item, "*", "*", "*", "*");
            for (MetadataValue dcv : dcvs) {
                MetadataField metadataField = dcv.getMetadataField();
                if (this.metadataExposureService.isHidden(this.context, dcv.getMetadataField().getMetadataSchema().getName(), metadataField.getElement(), metadataField.getQualifier())) continue;
                attributes = new AttributeMap();
                attributes.put((Object)"mdschema", (Object)metadataField.getMetadataSchema().getName());
                attributes.put((Object)"element", (Object)metadataField.getElement());
                if (metadataField.getQualifier() != null) {
                    attributes.put((Object)"qualifier", (Object)metadataField.getQualifier());
                }
                if (dcv.getLanguage() != null) {
                    attributes.put((Object)"language", (Object)dcv.getLanguage());
                }
                if (dcv.getAuthority() != null || dcv.getConfidence() != -1) {
                    attributes.put((Object)"authority", (Object)dcv.getAuthority());
                    attributes.put((Object)"confidence", (Object)Choices.getConfidenceText((int)dcv.getConfidence()));
                }
                this.startElement(DIM, "field", new AttributeMap[]{attributes});
                this.sendCharacters(dcv.getValue());
                this.endElement(DIM, "field");
            }
            this.endElement(DIM, "dim");
            this.endElement(METS, "xmlData");
            this.endElement(METS, "mdWrap");
            this.endElement(METS, "dmdSec");
        }
        for (String dmdType : this.dmdTypes) {
            DisseminationCrosswalk crosswalk;
            if ("DIM".equals(dmdType) || (crosswalk = this.getDisseminationCrosswalk(dmdType)) == null) continue;
            String dmdID = this.getGenericID("dmd_");
            this.dmdSecIDS.append(" ").append(dmdID);
            attributes = new AttributeMap();
            attributes.put((Object)"ID", (Object)dmdID);
            attributes.put((Object)"GROUPID", (Object)groupID);
            this.startElement(METS, "dmdSec", new AttributeMap[]{attributes});
            attributes = new AttributeMap();
            if (this.isDefinedMETStype(dmdType)) {
                attributes.put((Object)"MDTYPE", (Object)dmdType);
            } else {
                attributes.put((Object)"MDTYPE", (Object)"OTHER");
                attributes.put((Object)"OTHERMDTYPE", (Object)dmdType);
            }
            this.startElement(METS, "mdWrap", new AttributeMap[]{attributes});
            this.startElement(METS, "xmlData", new AttributeMap[0]);
            try {
                Element dissemination = crosswalk.disseminateElement(this.context, (DSpaceObject)this.item);
                SAXFilter filter = new SAXFilter(this.contentHandler, this.lexicalHandler, this.namespaces);
                filter.allowElements().allowIgnorableWhitespace().allowCharacters().allowCDATA().allowPrefixMappings();
                SAXOutputter outputter = new SAXOutputter();
                outputter.setContentHandler((ContentHandler)filter);
                outputter.setLexicalHandler((LexicalHandler)filter);
                outputter.output(dissemination);
            }
            catch (JDOMException jdome) {
                throw new WingException((Throwable)jdome);
            }
            catch (AuthorizeException jdome) {
                // empty catch block
            }
            this.endElement(METS, "xmlData");
            this.endElement(METS, "mdWrap");
            this.endElement(METS, "dmdSec");
        }
        Boolean include = DSpaceServicesFactory.getInstance().getConfigurationService().getBooleanProperty("xmlui.bitstream.mods");
        if (include.booleanValue() && this.dmdTypes.contains("MODS")) {
            String groupID2 = this.getGenericID("group_dmd_");
            List bundles = this.itemService.getBundles(this.item, "METADATA");
            for (Bundle bundle : bundles) {
                Bitstream bitstream = this.bundleService.getBitstreamByName(bundle, "MODS.xml");
                if (bitstream == null) continue;
                String dmdID = this.getGenericID("dmd_");
                attributes = new AttributeMap();
                attributes.put((Object)"ID", (Object)dmdID);
                attributes.put((Object)"GROUPID", (Object)groupID2);
                this.startElement(METS, "dmdSec", new AttributeMap[]{attributes});
                attributes = new AttributeMap();
                attributes.put((Object)"MDTYPE", (Object)"MODS");
                this.startElement(METS, "mdWrap", new AttributeMap[]{attributes});
                this.startElement(METS, "xmlData", new AttributeMap[0]);
                SAXFilter filter = new SAXFilter(this.contentHandler, this.lexicalHandler, this.namespaces);
                filter.allowElements().allowIgnorableWhitespace().allowCharacters().allowCDATA().allowPrefixMappings();
                XMLReader reader = XMLReaderFactory.createXMLReader();
                reader.setContentHandler((ContentHandler)filter);
                reader.setProperty("http://xml.org/sax/properties/lexical-handler", filter);
                try {
                    InputStream is = this.bitstreamService.retrieve(this.context, bitstream);
                    reader.parse(new InputSource(is));
                }
                catch (AuthorizeException authorizeException) {
                    // empty catch block
                }
                this.endElement(METS, "xmlData");
                this.endElement(METS, "mdWrap");
                this.endElement(METS, "dmdSec");
            }
        }
    }

    protected void renderAdministrativeSection() throws WingException, SAXException, CrosswalkException, IOException, SQLException {
        if (this.amdTypes.size() > 0) {
            String amdID = this.getGenericID("amd_");
            AttributeMap attributes = new AttributeMap();
            attributes.put((Object)"ID", (Object)amdID);
            this.startElement(METS, "amdSec", new AttributeMap[]{attributes});
            String groupID = this.getGenericID("group_amd_");
            attributes.put((Object)"GROUPID", (Object)groupID);
        }
        for (String amdSecName : this.amdTypes.keySet()) {
            List mdTypes = (List)this.amdTypes.get(amdSecName);
            for (String mdType : mdTypes) {
                DisseminationCrosswalk crosswalk = this.getDisseminationCrosswalk(mdType);
                if (crosswalk == null) continue;
                if (crosswalk.canDisseminate((DSpaceObject)this.item)) {
                    this.renderAmdSubSection(amdSecName, mdType, crosswalk, (DSpaceObject)this.item);
                }
                List bundles = this.findEnabledBundles();
                for (Bundle bundle : bundles) {
                    List bitstreams = bundle.getBitstreams();
                    for (Bitstream bitstream : bitstreams) {
                        if (!crosswalk.canDisseminate((DSpaceObject)bitstream)) continue;
                        this.renderAmdSubSection(amdSecName, mdType, crosswalk, (DSpaceObject)bitstream);
                    }
                }
            }
        }
        if (this.amdTypes.size() > 0) {
            this.endElement(METS, "amdSec");
        }
    }

    protected void renderAmdSubSection(String amdSecName, String mdType, DisseminationCrosswalk crosswalk, DSpaceObject dso) throws WingException, SAXException, CrosswalkException, IOException, SQLException {
        String amdSecID = this.getAmdSecID(amdSecName, mdType, dso);
        AttributeMap attributes = new AttributeMap();
        attributes.put((Object)"ID", (Object)amdSecID);
        this.startElement(METS, amdSecName, new AttributeMap[]{attributes});
        if (dso.getType() == 0) {
            String fileID = this.getFileID((Bitstream)dso);
            if (this.fileAmdSecIDs.containsKey(fileID)) {
                ((StringBuffer)this.fileAmdSecIDs.get(fileID)).append(" ").append(amdSecID);
            } else {
                this.fileAmdSecIDs.put(fileID, new StringBuffer(amdSecID));
            }
        } else if (dso.getType() == 2) {
            if (this.amdSecIDS == null) {
                this.amdSecIDS = new StringBuffer(amdSecID);
            } else {
                this.amdSecIDS.append(" ").append(amdSecID);
            }
        }
        attributes = new AttributeMap();
        if (this.isDefinedMETStype(mdType)) {
            attributes.put((Object)"MDTYPE", (Object)mdType);
        } else {
            attributes.put((Object)"MDTYPE", (Object)"OTHER");
            attributes.put((Object)"OTHERMDTYPE", (Object)mdType);
        }
        this.startElement(METS, "mdWrap", new AttributeMap[]{attributes});
        this.startElement(METS, "xmlData", new AttributeMap[0]);
        try {
            Element dissemination = crosswalk.disseminateElement(this.context, dso);
            SAXFilter filter = new SAXFilter(this.contentHandler, this.lexicalHandler, this.namespaces);
            filter.allowElements().allowIgnorableWhitespace().allowCharacters().allowCDATA().allowPrefixMappings();
            SAXOutputter outputter = new SAXOutputter();
            outputter.setContentHandler((ContentHandler)filter);
            outputter.setLexicalHandler((LexicalHandler)filter);
            outputter.output(dissemination);
        }
        catch (JDOMException jdome) {
            throw new WingException((Throwable)jdome);
        }
        catch (AuthorizeException authorizeException) {
            // empty catch block
        }
        this.endElement(METS, "xmlData");
        this.endElement(METS, "mdWrap");
        this.endElement(METS, amdSecName);
    }

    protected void renderFileSection(Context context) throws SQLException, SAXException {
        this.startElement(METS, "fileSec", new AttributeMap[0]);
        List bundles = this.findEnabledBundles();
        Boolean showLicense = DSpaceServicesFactory.getInstance().getConfigurationService().getBooleanProperty("webui.licence_bundle.show");
        for (Bundle bundle : bundles) {
            String use = bundle.getName();
            boolean isContentBundle = false;
            boolean isDerivedBundle = false;
            if ("ORIGINAL".equals(use)) {
                use = "CONTENT";
                isContentBundle = true;
            }
            if ("TEXT".equals(bundle.getName()) || "THUMBNAIL".equals(bundle.getName())) {
                isDerivedBundle = true;
            }
            if ("LICENSE".equals(bundle.getName()) && !showLicense.booleanValue()) continue;
            AttributeMap attributes = new AttributeMap();
            attributes.put((Object)"USE", (Object)use);
            this.startElement(METS, "fileGrp", new AttributeMap[]{attributes});
            for (Bitstream bitstream : bundle.getBitstreams()) {
                String fileID = this.getFileID(bitstream);
                Bitstream originalBitstream = null;
                if (isDerivedBundle) {
                    originalBitstream = ItemAdapter.findOriginalBitstream((Item)this.item, (Bitstream)bitstream);
                }
                String groupID = this.getGroupFileID(originalBitstream == null ? bitstream : originalBitstream);
                String admIDs = null;
                if (this.fileAmdSecIDs.containsKey(fileID)) {
                    admIDs = ((StringBuffer)this.fileAmdSecIDs.get(fileID)).toString();
                }
                this.renderFileWithAllowed(this.item, bitstream, fileID, groupID, admIDs);
                if (!isContentBundle) continue;
                this.contentBitstreams.add(bitstream);
                if (bundle.getPrimaryBitstream() == null || !bundle.getPrimaryBitstream().equals((Object)bitstream)) continue;
                this.primaryBitstream = bitstream;
            }
            this.endElement(METS, "fileGrp");
        }
        this.endElement(METS, "fileSec");
    }

    protected void renderStructureMap() throws SQLException, SAXException {
        AttributeMap attributes = new AttributeMap();
        attributes.put((Object)"TYPE", (Object)"LOGICAL");
        attributes.put((Object)"LABEL", (Object)"DSpace");
        this.startElement(METS, "structMap", new AttributeMap[]{attributes});
        attributes = new AttributeMap();
        attributes.put((Object)"TYPE", (Object)"DSpace Item");
        if (this.dmdSecIDS != null) {
            attributes.put((Object)"DMDID", (Object)this.dmdSecIDS.toString());
        }
        if (this.amdSecIDS != null) {
            attributes.put((Object)"AMDID", (Object)this.amdSecIDS.toString());
        }
        this.startElement(METS, "div", new AttributeMap[]{attributes});
        if (this.primaryBitstream != null) {
            attributes = new AttributeMap();
            String fileID = this.getFileID(this.primaryBitstream);
            attributes.put((Object)"FILEID", (Object)fileID);
            this.startElement(METS, "fptr", new AttributeMap[]{attributes});
            this.endElement(METS, "fptr");
        }
        for (Bitstream bitstream : this.contentBitstreams) {
            attributes = new AttributeMap();
            attributes.put((Object)"ID", (Object)this.getGenericID("div_"));
            attributes.put((Object)"TYPE", (Object)"DSpace Content Bitstream");
            this.startElement(METS, "div", new AttributeMap[]{attributes});
            attributes = new AttributeMap();
            String fileID = this.getFileID(bitstream);
            attributes.put((Object)"FILEID", (Object)fileID);
            this.startElement(METS, "fptr", new AttributeMap[]{attributes});
            this.endElement(METS, "fptr");
            this.endElement(METS, "div");
        }
        this.endElement(METS, "div");
        this.endElement(METS, "structMap");
    }

    protected void renderExtraSections() throws SAXException, SQLException, IOException {
        Boolean include = DSpaceServicesFactory.getInstance().getConfigurationService().getBooleanProperty("xmlui.bitstream.mets");
        if (!include.booleanValue()) {
            return;
        }
        List bundles = this.itemService.getBundles(this.item, "METADATA");
        for (Bundle bundle : bundles) {
            Bitstream bitstream = this.bundleService.getBitstreamByName(bundle, "METS.xml");
            if (bitstream == null) continue;
            try {
                SAXFilter filter = new SAXFilter(this.contentHandler, this.lexicalHandler, this.namespaces);
                filter.allowIgnorableWhitespace().allowCharacters().allowCDATA().allowPrefixMappings();
                filter.allowElements(1);
                XMLReader reader = XMLReaderFactory.createXMLReader();
                reader.setContentHandler((ContentHandler)filter);
                reader.setProperty("http://xml.org/sax/properties/lexical-handler", filter);
                reader.parse(new InputSource(this.bitstreamService.retrieve(this.context, bitstream)));
            }
            catch (AuthorizeException authorizeException) {}
        }
    }

    protected List<Bundle> findEnabledBundles() throws SQLException {
        ArrayList<Bundle> bundles;
        if (this.fileGrpTypes.isEmpty()) {
            bundles = this.item.getBundles();
        } else {
            bundles = new ArrayList<Bundle>();
            for (String fileGrpType : this.fileGrpTypes) {
                for (Bundle newBundle : this.itemService.getBundles(this.item, fileGrpType)) {
                    bundles.add(newBundle);
                }
            }
        }
        return bundles;
    }

    protected static Bitstream findOriginalBitstream(Item item, Bitstream derived) throws SQLException {
        List bundles = item.getBundles();
        String originalFilename = derived.getName().substring(0, derived.getName().lastIndexOf("."));
        for (Bundle bundle : bundles) {
            if (bundle.getName() == null || !bundle.getName().equals("ORIGINAL")) continue;
            List bitstreams = bundle.getBitstreams();
            for (Bitstream bitstream : bitstreams) {
                if (!bitstream.getName().equals(originalFilename)) continue;
                return bitstream;
            }
        }
        return null;
    }

    protected void renderFileWithAllowed(Item item, Bitstream bitstream, String fileID, String groupID, String admID) throws SAXException, SQLException {
        BitstreamFormat format = bitstream.getFormat(this.context);
        String mimeType = null;
        if (format != null) {
            mimeType = format.getMIMEType();
        }
        String checksumType = bitstream.getChecksumAlgorithm();
        String checksum = bitstream.getChecksum();
        long size = bitstream.getSize();
        AttributeMap attributes = new AttributeMap();
        attributes.put((Object)"ID", (Object)fileID);
        attributes.put((Object)"GROUPID", (Object)groupID);
        if (admID != null && admID.length() > 0) {
            attributes.put((Object)"ADMID", (Object)admID);
        }
        if (mimeType != null && mimeType.length() > 0) {
            attributes.put((Object)"MIMETYPE", (Object)mimeType);
        }
        if (checksumType != null && checksum != null) {
            attributes.put((Object)"CHECKSUM", (Object)checksum);
            attributes.put((Object)"CHECKSUMTYPE", (Object)checksumType);
        }
        attributes.put((Object)"SIZE", (Object)String.valueOf(size));
        this.startElement(METS, "file", new AttributeMap[]{attributes});
        String name = bitstream.getName();
        String description = bitstream.getDescription();
        String identifier = null;
        identifier = item != null && item.getHandle() != null ? "handle/" + item.getHandle() : (item != null ? "item/" + item.getID() : "id/" + bitstream.getID());
        String url = this.contextPath + "/bitstream/" + identifier + "/";
        try {
            if (bitstream.getName() != null) {
                url = url + Util.encodeBitstreamName((String)bitstream.getName(), (String)"UTF-8");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        url = url + "?sequence=" + bitstream.getSequenceID();
        String isAllowed = "n";
        try {
            if (this.authorizeService.authorizeActionBoolean(this.context, (DSpaceObject)bitstream, 0)) {
                isAllowed = "y";
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        url = url + "&isAllowed=" + isAllowed;
        attributes = new AttributeMap();
        AttributeMap attributesXLINK = new AttributeMap();
        attributesXLINK.setNamespace(XLINK);
        attributes.put((Object)"LOCTYPE", (Object)"URL");
        attributesXLINK.put((Object)"type", (Object)"locator");
        attributesXLINK.put((Object)"title", (Object)name);
        if (description != null) {
            attributesXLINK.put((Object)"label", (Object)description);
        }
        attributesXLINK.put((Object)"href", (Object)url);
        this.startElement(METS, "FLocat", new AttributeMap[]{attributes, attributesXLINK});
        this.endElement(METS, "FLocate");
        this.endElement(METS, "file");
    }
}

