/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.utils;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.SQLException;
import java.util.List;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;

public class DSpaceValidity
implements SourceValidity {
    private static final long serialVersionUID = 1L;
    protected StringBuffer validityKey;
    protected boolean completed = false;
    protected long hash;
    protected long assumedValidityTime = 0L;
    protected long assumedValidityDelay = 0L;
    protected transient CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected transient CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected transient ItemService itemService = ContentServiceFactory.getInstance().getItemService();

    public DSpaceValidity(String initialValidityKey) {
        this.validityKey = new StringBuffer();
        if (initialValidityKey != null) {
            this.validityKey.append(initialValidityKey);
        }
    }

    public DSpaceValidity() {
        this(null);
    }

    public DSpaceValidity complete() {
        this.completed = true;
        this.hash = HashUtil.hash((StringBuffer)this.validityKey);
        this.validityKey = null;
        if (this.assumedValidityDelay > 0L) {
            this.resetAssumedValidityTime();
        }
        return this;
    }

    public void setAssumedValidityDelay(long milliseconds) {
        this.assumedValidityDelay = milliseconds;
        this.validityKey.append("AssumedValidityDelay:").append(milliseconds);
    }

    public void setAssumedValidityDelay(String delay) {
        if (delay == null || delay.length() == 0) {
            return;
        }
        String[] parts = delay.split(" ");
        if (parts == null || parts.length != 2) {
            throw new IllegalArgumentException("Error unable to parse the assumed validity delay time: \"" + delay + "\". All delays must be of the form \"<integer> <scale>\" where scale is either seconds, minutes, hours, or days.");
        }
        long milliseconds = 0L;
        long value = 0L;
        try {
            value = Long.valueOf(parts[0]);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Error unable to parse the assumed validity delay time: \"" + delay + "\". All delays must be of the form \"<integer> <scale>\" where scale is either seconds, minutes, hours, or days.", nfe);
        }
        String scale = parts[1].toLowerCase();
        if (scale.equals("weeks") || scale.equals("week")) {
            milliseconds = value * 604800000L;
        } else if (scale.equals("days") || scale.equals("day")) {
            milliseconds = value * 86400000L;
        } else if (scale.equals("hours") || scale.equals("hour")) {
            milliseconds = value * 3600000L;
        } else if (scale.equals("minutes") || scale.equals("minute")) {
            milliseconds = value * 60000L;
        } else if (scale.equals("seconds") || scale.equals("second")) {
            milliseconds = value * 1000L;
        } else {
            throw new IllegalArgumentException("Error unable to parse the assumed validity delay time: \"" + delay + "\". All delays must be of the form \"<integer> <scale>\" where scale is either seconds, minutes, hours, or days.");
        }
        this.setAssumedValidityDelay(milliseconds);
    }

    public void add(Context context, DSpaceObject dso) throws SQLException {
        if (this.completed) {
            throw new IllegalStateException("Cannot add DSpaceObject to a completed validity object");
        }
        if (dso == null) {
            this.validityKey.append("null");
        } else if (dso instanceof Community) {
            Community community = (Community)dso;
            this.validityKey.append("Community:");
            this.validityKey.append(community.getHandle());
            this.validityKey.append(this.communityService.getMetadata(community, "introductory_text"));
            this.validityKey.append(this.communityService.getMetadata(community, "short_description"));
            this.validityKey.append(this.communityService.getMetadata(community, "side_bar_text"));
            this.validityKey.append(this.communityService.getMetadata(community, "copyright_text"));
            this.validityKey.append(this.communityService.getMetadata(community, "name"));
            this.add(context, (DSpaceObject)community.getLogo());
        } else if (dso instanceof Collection) {
            Collection collection = (Collection)dso;
            this.validityKey.append("Collection:");
            this.validityKey.append(collection.getHandle());
            this.validityKey.append(this.collectionService.getMetadata((DSpaceObject)collection, "introductory_text"));
            this.validityKey.append(this.collectionService.getMetadata((DSpaceObject)collection, "short_description"));
            this.validityKey.append(this.collectionService.getMetadata((DSpaceObject)collection, "side_bar_text"));
            this.validityKey.append(this.collectionService.getMetadata((DSpaceObject)collection, "provenance_description"));
            this.validityKey.append(this.collectionService.getMetadata((DSpaceObject)collection, "copyright_text"));
            this.validityKey.append(this.collectionService.getMetadata((DSpaceObject)collection, "license"));
            this.validityKey.append(this.collectionService.getMetadata((DSpaceObject)collection, "name"));
            this.add(context, (DSpaceObject)collection.getLogo());
        } else if (dso instanceof Item) {
            Item item = (Item)dso;
            this.validityKey.append("Item:");
            this.validityKey.append(item.getHandle());
            this.validityKey.append(item.getOwningCollection());
            this.validityKey.append(item.getLastModified());
            List dcvs = this.itemService.getMetadata((DSpaceObject)item, "*", "*", "*", "*");
            for (MetadataValue dcv : dcvs) {
                this.validityKey.append(dcv.getMetadataField().toString('.'));
                this.validityKey.append(dcv.getLanguage()).append("=");
                this.validityKey.append(dcv.getValue());
            }
            for (Bundle bundle : item.getBundles()) {
                this.add(context, (DSpaceObject)bundle);
            }
        } else if (dso instanceof Bundle) {
            Bundle bundle = (Bundle)dso;
            this.validityKey.append("Bundle:");
            this.validityKey.append(bundle.getID());
            this.validityKey.append(bundle.getName());
            this.validityKey.append(bundle.getPrimaryBitstream() != null ? bundle.getPrimaryBitstream().getID() : "");
            for (Bitstream bitstream : bundle.getBitstreams()) {
                this.add(context, (DSpaceObject)bitstream);
            }
        } else if (dso instanceof Bitstream) {
            Bitstream bitstream = (Bitstream)dso;
            this.validityKey.append("Bundle:");
            this.validityKey.append(bitstream.getID());
            this.validityKey.append(bitstream.getSequenceID());
            this.validityKey.append(bitstream.getName());
            this.validityKey.append(bitstream.getSource());
            this.validityKey.append(bitstream.getDescription());
            this.validityKey.append(bitstream.getChecksum());
            this.validityKey.append(bitstream.getChecksumAlgorithm());
            this.validityKey.append(bitstream.getSize());
            this.validityKey.append(bitstream.getUserFormatDescription());
            this.validityKey.append(bitstream.getFormat(context).getDescription());
        } else if (dso instanceof EPerson) {
            EPerson eperson = (EPerson)dso;
            this.validityKey.append("Bundle:");
            this.validityKey.append(eperson.getID());
            this.validityKey.append(eperson.getEmail());
            this.validityKey.append(eperson.getNetid());
            this.validityKey.append(eperson.getFirstName());
            this.validityKey.append(eperson.getLastName());
            this.validityKey.append(eperson.canLogIn());
            this.validityKey.append(eperson.getRequireCertificate());
        } else if (dso instanceof Group) {
            Group group = (Group)dso;
            this.validityKey.append("Group:");
            this.validityKey.append(group.getID());
            this.validityKey.append(group.getName());
        } else {
            throw new IllegalArgumentException("DSpaceObject of type '" + dso.getClass().getName() + "' is not supported by the DSpaceValidity object.");
        }
    }

    public void add(String nonDSpaceObject) throws SQLException {
        this.validityKey.append("String:");
        this.validityKey.append(nonDSpaceObject);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.assumedValidityTime = 0L;
    }

    private void resetAssumedValidityTime() {
        this.assumedValidityTime = System.currentTimeMillis() + this.assumedValidityDelay;
    }

    public int isValid() {
        if (this.completed) {
            if (this.assumedValidityDelay > 0L && System.currentTimeMillis() < this.assumedValidityTime) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    public int isValid(SourceValidity otherObject) {
        if (this.completed && otherObject instanceof DSpaceValidity) {
            DSpaceValidity otherSSV = (DSpaceValidity)otherObject;
            if (this.hash == otherSSV.hash) {
                if (this.assumedValidityDelay > 0L) {
                    this.resetAssumedValidityTime();
                }
                if (otherSSV.assumedValidityDelay > 0L) {
                    otherSSV.resetAssumedValidityTime();
                }
                return 1;
            }
        }
        return -1;
    }
}

