/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.springmvc;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.View;

public class RisView
implements View {
    private static final Logger LOGGER = LoggerFactory.getLogger(RisView.class);
    private static final String EOL = "\r\n";
    private String resourceIdentifier = null;
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();

    public RisView(String resourceIdentifier) {
        this.resourceIdentifier = resourceIdentifier;
    }

    public String getContentType() {
        return "text/plain;charset=utf-8";
    }

    public void render(Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DSpaceObject item = (DSpaceObject)request.getAttribute("dspace.object");
        Context context = new Context();
        context.turnOffAuthorisationSystem();
        String fileName = this.getFileName(item);
        this.write(response, this.getRIS((Item)item, this.resourceIdentifier), fileName);
        ServletOutputStream aOutputStream = response.getOutputStream();
        aOutputStream.close();
    }

    private String getFileName(DSpaceObject item) {
        String fileName = this.resourceIdentifier;
        if (this.resourceIdentifier.indexOf("/") != -1) {
            fileName = this.resourceIdentifier.replaceAll("/", "_") + ".ris";
        }
        return fileName;
    }

    private void write(HttpServletResponse aResponse, String aContent, String aFileName) throws IOException {
        aResponse.setContentType("text/plain;charset=utf-8");
        aResponse.setContentLength(aContent.length());
        aResponse.setHeader("Content-Disposition", "attachment; filename=\"" + aFileName + "\"");
        PrintWriter writer = aResponse.getWriter();
        writer.print(aContent);
        writer.close();
    }

    private String getRIS(Item item, String resourceIdentifier) {
        StringBuilder builder = new StringBuilder("TY  - DATA").append(EOL);
        String[] dateParts = this.getDate(item);
        String title = this.getMetadataValue(item, "dc.title");
        String description = this.getMetadataValue(item, "dc.description");
        String[] keywords = this.getKeywords(item);
        if (resourceIdentifier != null) {
            builder.append("ID  - ").append(resourceIdentifier).append(EOL);
        }
        if (title != null) {
            builder.append("T1  - ").append(title).append(EOL);
        }
        for (String author : this.getAuthors(item)) {
            builder.append("AU  - ").append(author).append(EOL);
        }
        if (dateParts.length > 0) {
            int count = 3;
            builder.append("Y1  - ");
            if (dateParts.length < 3) {
                count = dateParts.length;
            }
            for (int index = 0; index < count; ++index) {
                builder.append(dateParts[index]).append("/");
            }
            while (count < 3) {
                builder.append('/');
                ++count;
            }
            builder.append(EOL);
        }
        if (description != null) {
            builder.append("N2  - ").append(description).append(EOL);
        }
        for (String keyword : keywords) {
            builder.append("KW  - ").append(keyword).append(EOL);
        }
        return builder.append("ER  - ").append(EOL).toString();
    }

    private String[] getAuthors(Item aItem) {
        ArrayList authors = new ArrayList();
        authors.addAll(this.getAuthors(this.itemService.getMetadataByMetadataString((DSpaceObject)aItem, "dc.contributor.author")));
        authors.addAll(this.getAuthors(this.itemService.getMetadataByMetadataString((DSpaceObject)aItem, "dc.creator")));
        authors.addAll(this.getAuthors(this.itemService.getMetadataByMetadataString((DSpaceObject)aItem, "dc.contributor")));
        return authors.toArray(new String[authors.size()]);
    }

    private String[] getKeywords(Item aItem) {
        ArrayList<String> keywordList = new ArrayList<String>();
        for (MetadataValue keyword : this.itemService.getMetadataByMetadataString((DSpaceObject)aItem, "dc.subject")) {
            if (keyword.getValue().length() >= 255) continue;
            keywordList.add(keyword.getValue());
        }
        for (MetadataValue keyword : this.itemService.getMetadataByMetadataString((DSpaceObject)aItem, "dwc.ScientificName")) {
            if (keyword.getValue().length() >= 255) continue;
            keywordList.add(keyword.getValue());
        }
        return keywordList.toArray(new String[keywordList.size()]);
    }

    private String[] getDate(Item item) {
        Iterator i$ = this.itemService.getMetadataByMetadataString((DSpaceObject)item, "dc.date.issued").iterator();
        if (i$.hasNext()) {
            MetadataValue date = (MetadataValue)i$.next();
            StringTokenizer tokenizer = new StringTokenizer(date.getValue(), "-/ T");
            String[] dateParts = new String[tokenizer.countTokens()];
            for (int index = 0; index < dateParts.length; ++index) {
                dateParts[index] = tokenizer.nextToken();
            }
            return dateParts;
        }
        return new String[0];
    }

    private String getMetadataValue(Item item, String metadatafield) {
        Iterator i$ = this.itemService.getMetadataByMetadataString((DSpaceObject)item, metadatafield).iterator();
        if (i$.hasNext()) {
            MetadataValue value = (MetadataValue)i$.next();
            return value.getValue();
        }
        return null;
    }

    private List<String> getAuthors(List<MetadataValue> aMetadata) {
        ArrayList<String> authors = new ArrayList<String>();
        for (MetadataValue metadata : aMetadata) {
            String[] parts;
            StringBuilder builder = new StringBuilder();
            if (metadata.getValue().indexOf(",") != -1) {
                parts = metadata.getValue().split(",");
                if (parts.length > 1) {
                    StringTokenizer tokenizer = new StringTokenizer(parts[1], ". ");
                    builder.append(parts[0]).append(" ");
                    while (tokenizer.hasMoreTokens()) {
                        builder.append(tokenizer.nextToken().charAt(0));
                    }
                } else {
                    builder.append(metadata.getValue());
                }
                authors.add(builder.toString());
                continue;
            }
            parts = metadata.getValue().split("\\s+|\\.");
            String name = parts[parts.length - 1].replace("\\s+|\\.", "");
            builder.append(name).append(" ");
            for (int index = 0; index < parts.length - 1; ++index) {
                if (parts[index].length() <= 0) continue;
                name = parts[index].replace("\\s+|\\.", "");
                builder.append(name.charAt(0));
            }
        }
        return authors;
    }
}

