/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative;

import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.dspace.app.util.AuthorizeUtil;
import org.dspace.app.xmlui.aspect.administrative.FlowResult;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.PolicySet;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.BundleService;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.GroupService;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;

public class FlowAuthorizationUtils {
    protected static final CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected static final CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected static final ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected static final BundleService bundleService = ContentServiceFactory.getInstance().getBundleService();
    protected static final BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    protected static final HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
    protected static final AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    protected static final ResourcePolicyService resourcePolicyService = AuthorizeServiceFactory.getInstance().getResourcePolicyService();
    protected static final GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();

    public static FlowResult resolveItemIdentifier(Context context, String identifier) throws SQLException {
        FlowResult result = new FlowResult();
        result.setContinue(false);
        if (identifier.contains("/")) {
            DSpaceObject dso = handleService.resolveToObject(context, identifier);
            if (dso != null && dso.getType() == 2) {
                result.setParameter("itemID", (Object)dso.getID());
                result.setParameter("type", (Object)2);
                result.setContinue(true);
                return result;
            }
            if (dso != null && dso.getType() == 3) {
                result.setParameter("collectionID", (Object)dso.getID());
                result.setParameter("type", (Object)3);
                result.setContinue(true);
                return result;
            }
            if (dso != null && dso.getType() == 4) {
                result.setParameter("communityID", (Object)dso.getID());
                result.setParameter("type", (Object)4);
                result.setContinue(true);
                return result;
            }
        } else {
            Item item = null;
            try {
                item = (Item)itemService.find(context, UUID.fromString(identifier));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (item != null) {
                result.setParameter("itemID", (Object)item.getID());
                result.setParameter("type", (Object)2);
                result.setContinue(true);
                return result;
            }
        }
        result.addError("identifier");
        return result;
    }

    public static FlowResult processEditPolicy(Context context, int objectType, UUID objectID, int policyID, UUID groupID, int actionID, String name, String description, String startDateParam, String endDateParam) throws SQLException, AuthorizeException {
        FlowResult result = new FlowResult();
        boolean added = false;
        ResourcePolicy policy = (ResourcePolicy)resourcePolicyService.find(context, policyID);
        if (policy != null) {
            AuthorizeUtil.authorizeManagePolicy((Context)context, (ResourcePolicy)policy);
        }
        if (actionID == -1) {
            result.setContinue(false);
            result.addError("action_id");
            return result;
        }
        if (groupID == null) {
            result.setContinue(false);
            result.addError("group_id");
            return result;
        }
        Date startDate = null;
        Date endDate = null;
        if (StringUtils.isNotBlank((String)startDateParam)) {
            try {
                startDate = DateUtils.parseDate((String)startDateParam, (String[])new String[]{"yyyy-MM-dd", "yyyy-MM", "yyyy"});
            }
            catch (ParseException e) {
                startDate = null;
            }
            if (startDate == null) {
                result.setContinue(false);
                result.addError("startDate");
                return result;
            }
        }
        if (StringUtils.isNotBlank((String)endDateParam)) {
            try {
                endDate = DateUtils.parseDate((String)endDateParam, (String[])new String[]{"yyyy-MM-dd", "yyyy-MM", "yyyy"});
            }
            catch (ParseException e) {
                endDate = null;
            }
            if (endDate == null) {
                result.setContinue(false);
                result.addError("endDate");
                return result;
            }
        }
        if (endDate != null && startDate != null && startDate.after(endDate)) {
            result.setContinue(false);
            result.addError("startDateGreaterThenEndDate");
            return result;
        }
        DSpaceObject dso = ContentServiceFactory.getInstance().getDSpaceObjectService(objectType).find(context, objectID);
        if (policy == null) {
            if (authorizeService.isAnIdenticalPolicyAlreadyInPlace(context, dso, (Group)groupService.find(context, groupID), actionID, -1)) {
                result.setContinue(false);
                result.addError("duplicatedPolicy");
                return result;
            }
        } else if (authorizeService.isAnIdenticalPolicyAlreadyInPlace(context, dso, (Group)groupService.find(context, groupID), actionID, policy.getID().intValue())) {
            result.setContinue(false);
            result.addError("duplicatedPolicy");
            return result;
        }
        DSpaceObject policyParent = null;
        if (policy == null) {
            switch (objectType) {
                case 4: {
                    policyParent = communityService.find(context, objectID);
                    AuthorizeUtil.authorizeManageCommunityPolicy((Context)context, (Community)((Community)policyParent));
                    break;
                }
                case 3: {
                    policyParent = collectionService.find(context, objectID);
                    AuthorizeUtil.authorizeManageCollectionPolicy((Context)context, (Collection)((Collection)policyParent));
                    break;
                }
                case 2: {
                    policyParent = itemService.find(context, objectID);
                    AuthorizeUtil.authorizeManageItemPolicy((Context)context, (Item)((Item)policyParent));
                    break;
                }
                case 1: {
                    policyParent = bundleService.find(context, objectID);
                    AuthorizeUtil.authorizeManageItemPolicy((Context)context, (Item)((Item)bundleService.getParentObject(context, (DSpaceObject)((Bundle)policyParent))));
                    break;
                }
                case 0: {
                    policyParent = bitstreamService.find(context, objectID);
                    AuthorizeUtil.authorizeManageItemPolicy((Context)context, (Item)((Item)bitstreamService.getParentObject(context, (DSpaceObject)((Bitstream)policyParent))));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid DSpaceObject type provided");
                }
            }
            policy = (ResourcePolicy)resourcePolicyService.create(context);
            policy.setdSpaceObject(policyParent);
            policy.setRpType(ResourcePolicy.TYPE_CUSTOM);
            added = true;
        }
        Group group = (Group)groupService.find(context, groupID);
        policy.setAction(actionID);
        policy.setGroup(group);
        policy.setRpName(name);
        policy.setRpDescription(description);
        if (endDate != null) {
            policy.setEndDate(endDate);
        } else {
            policy.setEndDate(null);
        }
        if (startDate != null) {
            policy.setStartDate(startDate);
        } else {
            policy.setStartDate(null);
        }
        Bitstream logo = null;
        DSpaceObject logoContainer = null;
        if (objectType == 3) {
            logoContainer = collectionService.find(context, objectID);
            logo = ((Collection)logoContainer).getLogo();
        } else if (objectType == 4) {
            logoContainer = communityService.find(context, objectID);
            logo = ((Community)logoContainer).getLogo();
        }
        if (logo != null) {
            List policySet = authorizeService.getPolicies(context, logoContainer);
            authorizeService.removeAllPolicies(context, (DSpaceObject)logo);
            authorizeService.addPolicies(context, policySet, (DSpaceObject)logo);
        }
        resourcePolicyService.update(context, (Object)policy);
        result.setContinue(true);
        result.setOutcome(true);
        if (added) {
            result.setMessage(new Message("default", "A new policy was created successfully"));
        } else {
            result.setMessage(new Message("default", "The policy was edited successfully"));
        }
        result.setParameter("policyID", (Object)policy.getID());
        return result;
    }

    public static FlowResult processDeletePolicies(Context context, String[] policyIDs) throws NumberFormatException, SQLException, AuthorizeException {
        FlowResult result = new FlowResult();
        for (String id : policyIDs) {
            ResourcePolicy policyDeleted = (ResourcePolicy)resourcePolicyService.find(context, Integer.valueOf(id).intValue());
            AuthorizeUtil.authorizeManagePolicy((Context)context, (ResourcePolicy)policyDeleted);
            resourcePolicyService.delete(context, (Object)policyDeleted);
        }
        result.setContinue(true);
        result.setOutcome(true);
        result.setMessage(new Message("default", "The policies were deleted successfully"));
        return result;
    }

    public static FlowResult processAdvancedPolicyAdd(Context context, String[] groupIDs, int actionID, int resourceID, String[] collectionIDs, String name, String description, String startDateParam, String endDateParam) throws NumberFormatException, SQLException, AuthorizeException {
        AuthorizeUtil.requireAdminRole((Context)context);
        FlowResult result = new FlowResult();
        if (groupIDs == null) {
            result.setContinue(false);
            result.addError("groupIDs");
            return result;
        }
        if (collectionIDs == null) {
            result.setContinue(false);
            result.addError("collectionIDs");
            return result;
        }
        Date startDate = null;
        Date endDate = null;
        if (StringUtils.isNotBlank((String)startDateParam)) {
            try {
                startDate = DateUtils.parseDate((String)startDateParam, (String[])new String[]{"yyyy-MM-dd", "yyyy-MM", "yyyy"});
            }
            catch (ParseException e) {
                startDate = null;
            }
            if (startDate == null) {
                result.setContinue(false);
                result.addError("startDate");
                return result;
            }
        }
        if (StringUtils.isNotBlank((String)endDateParam)) {
            try {
                endDate = DateUtils.parseDate((String)endDateParam, (String[])new String[]{"yyyy-MM-dd", "yyyy-MM", "yyyy"});
            }
            catch (ParseException e) {
                endDate = null;
            }
            if (endDate == null) {
                result.setContinue(false);
                result.addError("endDate");
                return result;
            }
        }
        if (endDate != null && startDate != null && startDate.after(endDate)) {
            result.setContinue(false);
            result.addError("startDateGreaterThenEndDate");
            return result;
        }
        for (String groupID : groupIDs) {
            for (String collectionID : collectionIDs) {
                PolicySet.setPolicies((Context)context, (int)3, (UUID)UUID.fromString(collectionID), (int)resourceID, (int)actionID, (UUID)UUID.fromString(groupID), (boolean)false, (boolean)false, (String)name, (String)description, (Date)startDate, (Date)endDate);
                if (resourceID != 0) continue;
                PolicySet.setPolicies((Context)context, (int)3, (UUID)UUID.fromString(collectionID), (int)1, (int)actionID, (UUID)UUID.fromString(groupID), (boolean)false, (boolean)false, (String)name, (String)description, (Date)startDate, (Date)endDate);
            }
        }
        result.setContinue(true);
        result.setOutcome(true);
        result.setMessage(new Message("default", "The policies were added successfully!"));
        return result;
    }

    public static FlowResult processAdvancedPolicyDelete(Context context, int resourceID, String[] collectionIDs) throws NumberFormatException, SQLException, AuthorizeException {
        AuthorizeUtil.requireAdminRole((Context)context);
        FlowResult result = new FlowResult();
        for (String collectionID : collectionIDs) {
            PolicySet.setPolicies((Context)context, (int)3, (UUID)UUID.fromString(collectionID), (int)resourceID, (int)0, null, (boolean)false, (boolean)true);
            if (resourceID != 0) continue;
            PolicySet.setPolicies((Context)context, (int)3, (UUID)UUID.fromString(collectionID), (int)1, (int)0, null, (boolean)false, (boolean)true);
        }
        result.setContinue(true);
        result.setOutcome(true);
        result.setMessage(new Message("default", "The policies for the selected collections were cleared."));
        return result;
    }
}

