/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.dspace.app.xmlui.aspect.administrative.FlowGroupUtils;
import org.dspace.app.xmlui.aspect.administrative.FlowResult;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.GroupService;

/*
 * Exception performing whole class analysis ignored.
 */
public class FlowGroupUtils {
    private static final Message T_edit_group_success_notice = new Message("default", "xmlui.administrative.FlowGroupUtils.edit_group_success_notice");
    private static final Message T_delete_group_success_notice = new Message("default", "xmlui.administrative.FlowGroupUtils.delete_group_success_notice");
    protected static final EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
    protected static final GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
    protected static final CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected static final CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    private static final String COLLECTION_PREFIX = "COLLECTION_";
    private static final String[] COLLECTION_SUFFIXES = new String[]{"_SUBMIT", "_ADMIN", "_WFSTEP_1", "_WORKFLOW_STEP_1", "_WFSTEP_2", "_WORKFLOW_STEP_2", "_WFSTEP_3", "_WORKFLOW_STEP_3", "_DEFAULT_ITEM_READ"};
    private static final String COMMUNITY_PREFIX = "COMMUNITY_";
    private static final String[] COMMUNITY_SUFFIXES = new String[]{"_ADMIN"};

    public static String getName(Context context, UUID groupID) throws SQLException {
        if (groupID == null) {
            return "New Group";
        }
        Group group = (Group)groupService.find(context, groupID);
        if (group == null) {
            return "New Group";
        }
        return group.getName();
    }

    public static String[] getEPeopleMembers(Context context, UUID groupID) throws SQLException {
        if (groupID == null) {
            return new String[0];
        }
        Group group = (Group)groupService.find(context, groupID);
        if (group == null) {
            return new String[0];
        }
        List epeople = group.getMembers();
        String[] epeopleIDs = new String[epeople.size()];
        for (int i = 0; i < epeople.size(); ++i) {
            epeopleIDs[i] = String.valueOf(((EPerson)epeople.get(i)).getID());
        }
        return epeopleIDs;
    }

    public static String[] getGroupMembers(Context context, UUID groupID) throws SQLException {
        if (groupID == null) {
            return new String[0];
        }
        Group group = (Group)groupService.find(context, groupID);
        if (group == null) {
            return new String[0];
        }
        List groups = group.getMemberGroups();
        String[] groupIDs = new String[groups.size()];
        for (int i = 0; i < groups.size(); ++i) {
            groupIDs[i] = String.valueOf(((Group)groups.get(i)).getID());
        }
        return groupIDs;
    }

    public static String[] addMember(String[] list, String id) {
        ArrayList<String> newList = new ArrayList<String>(Arrays.asList(list));
        newList.add(id);
        return newList.toArray(new String[newList.size()]);
    }

    public static String[] removeMember(String[] list, String id) {
        ArrayList<String> newList = new ArrayList<String>(Arrays.asList(list));
        newList.remove(id);
        return newList.toArray(new String[newList.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FlowResult processSaveGroup(Context context, UUID groupID, String newName, String[] newEPeopleIDsArray, String[] newGroupIDsArray) throws SQLException, AuthorizeException, UIException {
        FlowResult result = new FlowResult();
        try {
            newName = URLDecoder.decode(newName, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new UIException((Throwable)uee);
        }
        Group group = null;
        if (groupID == null) {
            if (newName == null || newName.length() == 0) {
                result.setContinue(false);
                result.addError("group_name");
                result.setOutcome(false);
                result.setMessage(new Message("default", "The group name may not be blank."));
                return result;
            }
            Group potentialDuplicate = groupService.findByName(context, newName);
            if (potentialDuplicate != null) {
                result.setContinue(false);
                result.addError("group_name");
                result.addError("group_name_duplicate");
                result.setOutcome(false);
                result.setMessage(new Message("default", "The group name is already in use"));
                return result;
            }
            group = groupService.create(context);
            groupService.setName(group, newName);
        } else {
            group = (Group)groupService.find(context, groupID);
            String name = group.getName();
            if (newName != null && newName.length() > 0 && !name.equals(newName)) {
                Group potentialDuplicate = groupService.findByName(context, newName);
                if (potentialDuplicate != null) {
                    result.setContinue(false);
                    result.addError("group_name");
                    result.addError("group_name_duplicate");
                    result.setOutcome(false);
                    result.setMessage(new Message("default", "The group name is already in use"));
                    return result;
                }
                groupService.setName(group, newName);
            }
        }
        ArrayList<UUID> newEPeopleIDs = new ArrayList<UUID>();
        for (Group epeopleID : newEPeopleIDsArray) {
            newEPeopleIDs.add(UUID.fromString((String)epeopleID));
        }
        ArrayList<UUID> newGroupIDs = new ArrayList<UUID>();
        for (String _groupID : newGroupIDsArray) {
            newGroupIDs.add(UUID.fromString(_groupID));
        }
        Iterator it = group.getMembers().iterator();
        while (it.hasNext()) {
            EPerson epersonMember = (EPerson)it.next();
            if (!newEPeopleIDs.contains(epersonMember.getID())) {
                it.remove();
                groupService.removeMember(context, group, epersonMember);
                continue;
            }
            newEPeopleIDs.remove(epersonMember.getID());
        }
        it = group.getMemberGroups().iterator();
        while (it.hasNext()) {
            Group groupMember = (Group)it.next();
            if (!newGroupIDs.contains(groupMember.getID())) {
                it.remove();
                groupService.removeMember(context, group, groupMember);
                continue;
            }
            newGroupIDs.remove(group.getID());
        }
        for (UUID epersonID : newEPeopleIDs) {
            EPerson eperson = (EPerson)ePersonService.find(context, epersonID);
            groupService.addMember(context, group, eperson);
        }
        Iterator iterator = newGroupIDs.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                groupService.update(context, (DSpaceObject)group);
                result.setParameter("groupID", (Object)group.getID());
                result.setContinue(true);
                result.setOutcome(true);
                result.setMessage(T_edit_group_success_notice);
                return result;
            }
            UUID _groupID = (UUID)iterator.next();
            Group _group = (Group)groupService.find(context, _groupID);
            groupService.addMember(context, group, _group);
        }
    }

    public static FlowResult processDeleteGroups(Context context, String[] groupIDs) throws SQLException, AuthorizeException, IOException {
        FlowResult result = new FlowResult();
        result.setContinue(true);
        for (String id : groupIDs) {
            Collection collection;
            Group groupDeleted = (Group)groupService.find(context, UUID.fromString(id));
            UUID collectionId = FlowGroupUtils.getCollectionId((Context)context, (String)groupDeleted.getName());
            Role role = FlowGroupUtils.getCollectionRole((String)groupDeleted.getName());
            if (collectionId != null && role != Role.none && (collection = (Collection)collectionService.find(context, collectionId)) != null) {
                if (role == Role.Administrators) {
                    collectionService.removeAdministrators(context, collection);
                    collectionService.update(context, (DSpaceObject)collection);
                } else if (role == Role.Submitters) {
                    collectionService.removeSubmitters(context, collection);
                    collectionService.update(context, (DSpaceObject)collection);
                } else if (role == Role.WorkflowStep1) {
                    collection.setWorkflowGroup(1, null);
                    collectionService.update(context, (DSpaceObject)collection);
                } else if (role == Role.WorkflowStep2) {
                    collection.setWorkflowGroup(2, null);
                    collectionService.update(context, (DSpaceObject)collection);
                } else if (role == Role.WorkflowStep3) {
                    collection.setWorkflowGroup(3, null);
                    collectionService.update(context, (DSpaceObject)collection);
                } else if (role == Role.DefaultRead) {
                    // empty if block
                }
            }
            groupService.delete(context, (DSpaceObject)groupDeleted);
        }
        result.setOutcome(true);
        result.setMessage(T_delete_group_success_notice);
        return result;
    }

    public static UUID getCollectionId(Context context, String groupName) {
        if (groupName != null && groupName.startsWith("COLLECTION_")) {
            for (String suffix : COLLECTION_SUFFIXES) {
                if (!groupName.endsWith(suffix)) continue;
                String idString = groupName.substring("COLLECTION_".length());
                idString = idString.substring(0, idString.length() - suffix.length());
                try {
                    Collection collection = (Collection)collectionService.findByIdOrLegacyId(context, idString);
                    if (collection != null) {
                        return collection.getID();
                    }
                    return null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static Role getCollectionRole(String groupName) {
        if (groupName != null && groupName.startsWith("COLLECTION_")) {
            for (String suffix : COLLECTION_SUFFIXES) {
                if (!groupName.endsWith(suffix)) continue;
                if (COLLECTION_SUFFIXES[0].equals(suffix)) {
                    return Role.Submitters;
                }
                if (COLLECTION_SUFFIXES[1].equals(suffix)) {
                    return Role.Administrators;
                }
                if (COLLECTION_SUFFIXES[2].equals(suffix)) {
                    return Role.WorkflowStep1;
                }
                if (COLLECTION_SUFFIXES[3].equals(suffix)) {
                    return Role.WorkflowStep1;
                }
                if (COLLECTION_SUFFIXES[4].equals(suffix)) {
                    return Role.WorkflowStep2;
                }
                if (COLLECTION_SUFFIXES[5].equals(suffix)) {
                    return Role.WorkflowStep2;
                }
                if (COLLECTION_SUFFIXES[6].equals(suffix)) {
                    return Role.WorkflowStep3;
                }
                if (COLLECTION_SUFFIXES[7].equals(suffix)) {
                    return Role.WorkflowStep3;
                }
                if (!COLLECTION_SUFFIXES[8].equals(suffix)) continue;
                return Role.DefaultRead;
            }
        }
        return Role.none;
    }

    public static UUID getCommunityId(Context context, String groupName) {
        if (groupName != null && groupName.startsWith("COMMUNITY_")) {
            for (String suffix : COMMUNITY_SUFFIXES) {
                if (!groupName.endsWith(suffix)) continue;
                String idString = groupName.substring("COMMUNITY_".length());
                idString = idString.substring(0, idString.length() - suffix.length());
                try {
                    Community community = (Community)communityService.findByIdOrLegacyId(context, idString);
                    if (community != null) {
                        return community.getID();
                    }
                    return null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static Role getCommunityRole(String groupName) {
        if (groupName != null && groupName.startsWith("COMMUNITY_")) {
            for (String suffix : COMMUNITY_SUFFIXES) {
                if (!groupName.endsWith(suffix)) continue;
                if (COLLECTION_SUFFIXES[0].equals(suffix)) {
                    return Role.Submitters;
                }
                if (COLLECTION_SUFFIXES[1].equals(suffix)) {
                    return Role.Administrators;
                }
                if (COLLECTION_SUFFIXES[2].equals(suffix)) {
                    return Role.WorkflowStep1;
                }
                if (COLLECTION_SUFFIXES[3].equals(suffix)) {
                    return Role.WorkflowStep1;
                }
                if (COLLECTION_SUFFIXES[4].equals(suffix)) {
                    return Role.WorkflowStep2;
                }
                if (COLLECTION_SUFFIXES[5].equals(suffix)) {
                    return Role.WorkflowStep2;
                }
                if (COLLECTION_SUFFIXES[6].equals(suffix)) {
                    return Role.WorkflowStep3;
                }
                if (COLLECTION_SUFFIXES[7].equals(suffix)) {
                    return Role.WorkflowStep3;
                }
                if (!COLLECTION_SUFFIXES[8].equals(suffix)) continue;
                return Role.DefaultRead;
            }
        }
        return Role.none;
    }
}

