/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.cocoon;

import java.io.IOException;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.reading.AbstractReader;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.SearchUtils;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.xml.sax.SAXException;

public class OpenURLReader
extends AbstractReader
implements Recyclable {
    private static final String Z39882004 = "Z39.88-2004";
    private static final String Z39882004DC = "info:ofi/fmt:kev:mtx:dc";
    private static final String Z39882004CTX = "info:ofi/fmt:kev:mtx:ctx";
    protected Response response;
    protected Request request;
    protected HttpServletResponse httpResponse;
    protected Context context;
    private static Logger log = Logger.getLogger(OpenURLReader.class);
    protected HandleService handleService = HandleServiceFactory.getInstance().getHandleService();

    public void generate() throws IOException, SAXException, ProcessingException {
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        try {
            this.httpResponse = (HttpServletResponse)objectModel.get("httpresponse");
            this.request = ObjectModelHelper.getRequest((Map)objectModel);
            this.response = ObjectModelHelper.getResponse((Map)objectModel);
            this.context = ContextUtil.obtainContext((Map)objectModel);
            if (Z39882004.equals(this.request.getParameter("url_ver"))) {
                this.handleZ39882004();
            } else {
                this.handleLegacy();
            }
        }
        catch (SQLException sqle) {
            throw new ProcessingException("Unable to resolve OpenURL.", (Throwable)sqle);
        }
    }

    public void recycle() {
        super.recycle();
        this.response = null;
        this.request = null;
        this.httpResponse = null;
        this.context = null;
    }

    public void handleLegacy() throws IOException {
        String query = "";
        String title = this.request.getParameter("title");
        String authorFirst = this.request.getParameter("aufirst");
        String authorLast = this.request.getParameter("aulast");
        String logInfo = "";
        if (title != null) {
            query = query + " " + title;
            logInfo = logInfo + "title=\"" + title + "\",";
        }
        if (authorFirst != null) {
            query = query + " " + authorFirst;
            logInfo = logInfo + "aufirst=\"" + authorFirst + "\",";
        }
        if (authorLast != null) {
            query = query + " " + authorLast;
            logInfo = logInfo + "aulast=\"" + authorLast + "\",";
        }
        log.info((Object)LogManager.getHeader((Context)this.context, (String)"openURL", (String)(logInfo + "dspacequery=" + query)));
        this.httpResponse.sendRedirect(this.httpResponse.encodeRedirectURL(this.request.getContextPath() + "/simple-search?query=" + query));
    }

    private String getFirstHandle(String query) throws IOException {
        DiscoverQuery queryArgs = new DiscoverQuery();
        queryArgs.setQuery(query);
        queryArgs.setDSpaceObjectFilter(2);
        try {
            DiscoverResult queryResults = SearchUtils.getSearchService().search(this.context, queryArgs);
            List objResults = queryResults.getDspaceObjects();
            if (objResults != null && !objResults.isEmpty()) {
                return ((DSpaceObject)objResults.get(0)).getHandle();
            }
            return null;
        }
        catch (SearchServiceException e) {
            throw new IOException(e);
        }
    }

    public void handleZ39882004() throws IOException, ProcessingException, SQLException {
        String[] identifiers;
        String rft_val_fmt = this.request.getParameter("rft_val_fmt");
        if (rft_val_fmt != null && !rft_val_fmt.equals(Z39882004DC)) {
            throw new ProcessingException("DSpace 1.0 OpenURL Service only supports rft_val_fmt=info:ofi/fmt:kev:mtx:dc");
        }
        String url_ctx_fmt = this.request.getParameter("url_ctx_fmt");
        if (url_ctx_fmt != null && !url_ctx_fmt.equals(Z39882004CTX)) {
            throw new ProcessingException("DSpace 1.0 OpenURL Service only supports url_ctx_fmt=info:ofi/fmt:kev:mtx:ctx");
        }
        String[] rft_ids = this.request.getParameterValues("rft_id");
        if (rft_ids != null) {
            for (String rft_id : rft_ids) {
                DSpaceObject obj = this.handleService.resolveToObject(this.context, rft_id);
                if (obj == null) continue;
                this.httpResponse.sendRedirect(this.httpResponse.encodeRedirectURL(this.request.getContextPath() + "/handle/" + obj.getHandle()));
                return;
            }
        }
        if ((identifiers = this.request.getParameterValues("rtf.identifier")) != null) {
            for (String identifier : identifiers) {
                String handle = this.getFirstHandle("identifier: " + identifier);
                if (handle == null) continue;
                this.httpResponse.sendRedirect(this.httpResponse.encodeRedirectURL(this.request.getContextPath() + "/handle/" + handle));
                return;
            }
        }
        StringBuilder queryBuilder = new StringBuilder();
        Enumeration e = this.request.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.startsWith("rft.")) continue;
            for (String value : this.request.getParameterValues(name)) {
                queryBuilder.append(value).append(" ");
            }
        }
        String query = queryBuilder.toString().trim();
        if (query.length() == 0) {
            this.httpResponse.sendError(400, "OpenURL Request requires a valid rtf_id, rtf.identifier or other rtf.<dublincore> search fields");
        }
        this.httpResponse.sendRedirect(this.httpResponse.encodeRedirectURL(this.request.getContextPath() + "/simple-search?query=" + URLEncoder.encode(query, this.request.getCharacterEncoding())));
    }
}

