/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative;

import java.io.IOException;
import java.sql.SQLException;
import java.util.UUID;
import org.dspace.app.xmlui.aspect.administrative.FlowResult;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;

public class FlowMapperUtils {
    private static final Message T_map_items = new Message("default", "xmlui.administrative.FlowMapperUtils.map_items");
    private static final Message T_unmaped_items = new Message("default", "xmlui.administrative.FlowMapperUtils.unmaped_items");
    protected static final AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    protected static final CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected static final ItemService itemService = ContentServiceFactory.getInstance().getItemService();

    public static FlowResult processMapItems(Context context, UUID collectionID, String[] itemIDs) throws SQLException, AuthorizeException, UIException, IOException {
        FlowResult result = new FlowResult();
        result.setContinue(false);
        Collection toCollection = (Collection)collectionService.find(context, collectionID);
        for (String itemID : itemIDs) {
            Item item = (Item)itemService.find(context, UUID.fromString(itemID));
            if (!authorizeService.authorizeActionBoolean(context, (DSpaceObject)item, 0) || itemService.isOwningCollection(item, toCollection)) continue;
            collectionService.addItem(context, toCollection, item);
        }
        result.setContinue(true);
        result.setOutcome(true);
        result.setMessage(T_map_items);
        return result;
    }

    public static FlowResult processUnmapItems(Context context, UUID collectionID, String[] itemIDs) throws SQLException, AuthorizeException, UIException, IOException {
        FlowResult result = new FlowResult();
        result.setContinue(false);
        Collection toCollection = (Collection)collectionService.find(context, collectionID);
        for (String itemID : itemIDs) {
            Item item = (Item)itemService.find(context, UUID.fromString(itemID));
            if (!authorizeService.authorizeActionBoolean(context, (DSpaceObject)item, 0) || itemService.isOwningCollection(item, toCollection)) continue;
            collectionService.removeItem(context, toCollection, item);
        }
        result.setContinue(true);
        result.setOutcome(true);
        result.setMessage(T_unmaped_items);
        return result;
    }
}

