/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative.item;

import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import org.dspace.app.util.CollectionDropDown;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.CheckBox;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Select;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;

public class MoveItemForm
extends AbstractDSpaceTransformer {
    private static final Message T_dspace_home = MoveItemForm.message((String)"xmlui.general.dspace_home");
    private static final Message T_item_trail = MoveItemForm.message((String)"xmlui.administrative.item.general.item_trail");
    private static final Message T_submit_cancel = MoveItemForm.message((String)"xmlui.general.cancel");
    private static final Message T_title = MoveItemForm.message((String)"xmlui.administrative.item.MoveItemForm.title");
    private static final Message T_trail = MoveItemForm.message((String)"xmlui.administrative.item.MoveItemForm.trail");
    private static final Message T_head1 = MoveItemForm.message((String)"xmlui.administrative.item.MoveItemForm.head1");
    private static final Message T_collection = MoveItemForm.message((String)"xmlui.administrative.item.MoveItemForm.collection");
    private static final Message T_collection_help = MoveItemForm.message((String)"xmlui.administrative.item.MoveItemForm.collection_help");
    private static final Message T_collection_default = MoveItemForm.message((String)"xmlui.administrative.item.MoveItemForm.collection_default");
    private static final Message T_submit_move = MoveItemForm.message((String)"xmlui.administrative.item.MoveItemForm.submit_move");
    private static final Message T_submit_inherit = MoveItemForm.message((String)"xmlui.administrative.item.MoveItemForm.inherit_policies");
    private static final Message T_submit_inherit_help = MoveItemForm.message((String)"xmlui.administrative.item.MoveItemForm.inherit_policies_help");
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();

    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrailLink(this.contextPath + "/admin/item", T_item_trail);
        pageMeta.addTrail().addContent(T_trail);
    }

    public void addBody(Body body) throws WingException, SQLException {
        UUID itemID = UUID.fromString(this.parameters.getParameter("itemID", null));
        Item item = (Item)this.itemService.find(this.context, itemID);
        Division main = body.addInteractiveDivision("move-item", this.contextPath + "/admin/item", "post", "primary administrative item");
        main.setHead(T_head1.parameterize(new Object[]{item.getHandle()}));
        List collections = this.collectionService.findAuthorizedOptimized(this.context, 3);
        org.dspace.app.xmlui.wing.element.List list = main.addList("select-collection", "form");
        Select select = list.addItem().addSelect("collectionID");
        select.setLabel(T_collection);
        select.setHelp(T_collection_help);
        Collection owningCollection = item.getOwningCollection();
        if (owningCollection == null) {
            select.addOption("", T_collection_default);
        }
        for (Collection collection : collections) {
            String name = collection.getName();
            if (name.length() > 50) {
                name = name.substring(0, 47) + "...";
            }
            if (this.itemService.isOwningCollection(item, collection)) continue;
            select.addOption(collection.equals((Object)owningCollection), collection.getID().toString(), CollectionDropDown.collectionPath((Context)this.context, (Collection)collection));
        }
        org.dspace.app.xmlui.wing.element.Item actions = list.addItem();
        CheckBox inheritPolicies = actions.addCheckBox("inheritPolicies");
        inheritPolicies.setLabel(T_submit_inherit);
        inheritPolicies.setHelp(T_submit_inherit_help);
        inheritPolicies.addOption("inheritPolicies");
        actions.addButton("submit_move").setValue(T_submit_move);
        actions.addButton("submit_cancel").setValue(T_submit_cancel);
        main.addHidden("administrative-continue").setValue(this.knot.getId());
    }
}

