/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative.mapper;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Button;
import org.dspace.app.xmlui.wing.element.CheckBox;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.ItemService;
import org.xml.sax.SAXException;

public class BrowseItemForm
extends AbstractDSpaceTransformer {
    private static final Message T_dspace_home = BrowseItemForm.message((String)"xmlui.general.dspace_home");
    private static final Message T_submit_return = BrowseItemForm.message((String)"xmlui.general.return");
    private static final Message T_mapper_trail = BrowseItemForm.message((String)"xmlui.administrative.mapper.general.mapper_trail");
    private static final Message T_title = BrowseItemForm.message((String)"xmlui.administrative.mapper.BrowseItemForm.title");
    private static final Message T_trail = BrowseItemForm.message((String)"xmlui.administrative.mapper.BrowseItemForm.trail");
    private static final Message T_head1 = BrowseItemForm.message((String)"xmlui.administrative.mapper.BrowseItemForm.head1");
    private static final Message T_submit_unmap = BrowseItemForm.message((String)"xmlui.administrative.mapper.BrowseItemForm.submit_unmap");
    private static final Message T_column1 = BrowseItemForm.message((String)"xmlui.administrative.mapper.BrowseItemForm.column1");
    private static final Message T_column2 = BrowseItemForm.message((String)"xmlui.administrative.mapper.BrowseItemForm.column2");
    private static final Message T_column3 = BrowseItemForm.message((String)"xmlui.administrative.mapper.BrowseItemForm.column3");
    private static final Message T_column4 = BrowseItemForm.message((String)"xmlui.administrative.mapper.BrowseItemForm.column4");
    private static final Message T_no_remove = BrowseItemForm.message((String)"xmlui.administrative.mapper.BrowseItemForm.no_remove");
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();

    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrail().addContent(T_mapper_trail);
        pageMeta.addTrail().addContent(T_trail);
    }

    public void addBody(Body body) throws SAXException, WingException, SQLException {
        Para actions;
        Para actions2;
        UUID collectionID = UUID.fromString(this.parameters.getParameter("collectionID", null));
        Collection collection = (Collection)this.collectionService.find(this.context, collectionID);
        List items = this.getMappedItems(collection);
        Division div = body.addInteractiveDivision("browse-items", this.contextPath + "/admin/mapper", "get", "primary administrative mapper");
        div.setHead(T_head1);
        if (this.authorizeService.authorizeActionBoolean(this.context, (DSpaceObject)collection, 4)) {
            actions2 = div.addPara();
            actions2.addButton("submit_unmap").setValue(T_submit_unmap);
            actions2.addButton("submit_return").setValue(T_submit_return);
        } else {
            actions2 = div.addPara();
            Button button = actions2.addButton("submit_unmap");
            button.setValue(T_submit_unmap);
            button.setDisabled();
            actions2.addButton("submit_return").setValue(T_submit_return);
            div.addPara().addHighlight("fade").addContent(T_no_remove);
        }
        Table table = div.addTable("browse-items-table", 1, 1);
        Row header = table.addRow("header");
        header.addCellContent(T_column1);
        header.addCellContent(T_column2);
        header.addCellContent(T_column3);
        header.addCellContent(T_column4);
        for (Item item : items) {
            String itemID = String.valueOf(item.getID());
            Collection owningCollection = item.getOwningCollection();
            String owning = owningCollection.getName();
            String author = "unknown";
            List dcAuthors = this.itemService.getMetadata((DSpaceObject)item, "dc", "contributor", "*", "*");
            if (dcAuthors != null && dcAuthors.size() >= 1) {
                author = ((MetadataValue)dcAuthors.get(0)).getValue();
            }
            String title = "untitled";
            List dcTitles = this.itemService.getMetadata((DSpaceObject)item, "dc", "title", null, "*");
            if (dcTitles != null && dcTitles.size() >= 1) {
                title = ((MetadataValue)dcTitles.get(0)).getValue();
            }
            String url = this.contextPath + "/handle/" + item.getHandle();
            Row row = table.addRow();
            CheckBox select = row.addCell().addCheckBox("itemID");
            select.setLabel("Select");
            select.addOption(itemID);
            row.addCellContent(owning);
            row.addCell().addXref(url, author);
            row.addCell().addXref(url, title);
        }
        if (this.authorizeService.authorizeActionBoolean(this.context, (DSpaceObject)collection, 4)) {
            actions = div.addPara();
            actions.addButton("submit_unmap").setValue(T_submit_unmap);
            actions.addButton("submit_return").setValue(T_submit_return);
        } else {
            actions = div.addPara();
            Button button = actions.addButton("submit_unmap");
            button.setValue(T_submit_unmap);
            button.setDisabled();
            actions.addButton("submit_return").setValue(T_submit_return);
            div.addPara().addHighlight("fade").addContent(T_no_remove);
        }
        div.addHidden("administrative-continue").setValue(this.knot.getId());
    }

    private List<Item> getMappedItems(Collection collection) throws SQLException {
        ArrayList<Item> items = new ArrayList<Item>();
        Iterator iterator = this.itemService.findByCollection(this.context, collection);
        while (iterator.hasNext()) {
            Item item = (Item)iterator.next();
            if (this.itemService.isOwningCollection(item, collection)) continue;
            items.add(item);
        }
        return items;
    }
}

