/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.artifactbrowser;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Map;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.dspace.app.requestitem.RequestItem;
import org.dspace.app.requestitem.RequestItemAuthor;
import org.dspace.app.requestitem.RequestItemAuthorExtractor;
import org.dspace.app.requestitem.factory.RequestItemServiceFactory;
import org.dspace.app.requestitem.service.RequestItemService;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Text;
import org.dspace.app.xmlui.wing.element.TextArea;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.xml.sax.SAXException;

public class ItemRequestContactRequester
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    private static final Message T_title = ItemRequestContactRequester.message((String)"xmlui.ArtifactBrowser.ItemRequestContactRequester.title");
    private static final Message T_dspace_home = ItemRequestContactRequester.message((String)"xmlui.general.dspace_home");
    private static final Message T_trail = ItemRequestContactRequester.message((String)"xmlui.ArtifactBrowser.ItemRequestContactRequester.trail");
    private static final Message T_head = ItemRequestContactRequester.message((String)"xmlui.ArtifactBrowser.ItemRequestContactRequester.head");
    private static final Message T_para1 = ItemRequestContactRequester.message((String)"xmlui.ArtifactBrowser.ItemRequestContactRequester.para1");
    private static final Message T_mail = ItemRequestContactRequester.message((String)"xmlui.ArtifactBrowser.ItemRequestContactRequester.mail");
    private static final Message T_back = ItemRequestContactRequester.message((String)"xmlui.ArtifactBrowser.ItemRequestContactRequester.back");
    private static final Message T_toEmail = ItemRequestContactRequester.message((String)"xmlui.ArtifactBrowser.ItemRequestContactRequester.toEmail");
    private static final Message T_message = ItemRequestContactRequester.message((String)"xmlui.ArtifactBrowser.ItemRequestContactRequester.message");
    private static final Message T_subject = ItemRequestContactRequester.message((String)"xmlui.ArtifactBrowser.ItemRequestContactRequester.subject");
    protected RequestItemService requestItemService = RequestItemServiceFactory.getInstance().getRequestItemService();

    public Serializable getKey() {
        String token = this.parameters.getParameter("token", "");
        String contactPerson = this.parameters.getParameter("contactPerson", "requester");
        return Long.valueOf(HashUtil.hash((String)(token + contactPerson)));
    }

    public SourceValidity getValidity() {
        return NOPValidity.SHARED_INSTANCE;
    }

    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrail().addContent(T_trail);
    }

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        Context context = ContextUtil.obtainContext((Map)this.objectModel);
        String token = (String)request.getAttribute("token");
        RequestItem requestItem = this.requestItemService.findByToken(context, token);
        Item item = requestItem.getItem();
        RequestItemAuthor requestItemAuthor = ((RequestItemAuthorExtractor)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName(RequestItemAuthorExtractor.class.getName(), RequestItemAuthorExtractor.class)).getRequestItemAuthor(context, item);
        Object[] args = new String[]{requestItem.getReqName(), requestItemAuthor.getFullName(), requestItemAuthor.getEmail()};
        String subject = I18nUtil.getMessage((String)"itemRequest.response.subject.contactRequester");
        String messageTemplate = MessageFormat.format(I18nUtil.getMessage((String)"itemRequest.response.body.contactRequester", (Context)context), args);
        Division itemRequest = body.addInteractiveDivision("itemRequest-form", request.getRequestURI(), "post", "primary");
        itemRequest.setHead(T_head);
        itemRequest.addPara(T_para1);
        List form = itemRequest.addList("form", "form");
        Text toEmail = form.addItem().addText("to");
        toEmail.setLabel(T_toEmail);
        toEmail.setValue(requestItem.getReqEmail());
        toEmail.setDisabled(true);
        Text subj = form.addItem().addText("subject");
        subj.setLabel(T_subject);
        subj.setValue(subject);
        subj.setSize(60);
        TextArea message = form.addItem().addTextArea("message");
        message.setSize(20, 0);
        message.setLabel(T_message);
        message.setValue(this.parameters.getParameter("message", messageTemplate));
        form.addItem().addHidden("contactPerson").setValue("requester");
        form.addItem().addButton("back").setValue(T_back);
        form.addItem().addButton("mail").setValue(T_mail);
    }
}

