/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.artifactbrowser;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletResponse;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.dspace.app.sfx.factory.SfxServiceFactory;
import org.dspace.app.sfx.service.SFXFileReaderService;
import org.dspace.app.util.GoogleMetadata;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.DSpaceValidity;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Metadata;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.ReferenceSet;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.DisseminationCrosswalk;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.core.Context;
import org.dspace.core.factory.CoreServiceFactory;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.jdom.Element;
import org.jdom.Text;
import org.jdom.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class ItemViewer
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    private static final Message T_dspace_home = ItemViewer.message((String)"xmlui.general.dspace_home");
    private static final Message T_trail = ItemViewer.message((String)"xmlui.ArtifactBrowser.ItemViewer.trail");
    private static final Message T_show_simple = ItemViewer.message((String)"xmlui.ArtifactBrowser.ItemViewer.show_simple");
    private static final Message T_show_full = ItemViewer.message((String)"xmlui.ArtifactBrowser.ItemViewer.show_full");
    private static final Message T_head_parent_collections = ItemViewer.message((String)"xmlui.ArtifactBrowser.ItemViewer.head_parent_collections");
    private static final Message T_withdrawn = ItemViewer.message((String)"xmlui.ArtifactBrowser.ItemViewer.withdrawn");
    private SourceValidity validity = null;
    private DisseminationCrosswalk xHTMLHeadCrosswalk = null;
    private final String sfxFile = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("dspace.dir") + File.separator + "config" + File.separator + "sfx.xml";
    private static final Logger log = LoggerFactory.getLogger(ItemViewer.class);
    protected SFXFileReaderService sfxFileReaderService = SfxServiceFactory.getInstance().getSfxFileReaderService();
    private static final Pattern handlePattern = Pattern.compile("hdl:|https?://hdl\\.handle\\.net/", 2);
    private static final Pattern doiPattern = Pattern.compile("doi:|https?://(dx\\.)?doi\\.org/", 2);

    public Serializable getKey() {
        try {
            DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
            if (dso == null) {
                return "0";
            }
            return Long.valueOf(HashUtil.hash((String)(dso.getHandle() + "full:" + ItemViewer.showFullItem((Map)this.objectModel))));
        }
        catch (SQLException sqle) {
            return "0";
        }
    }

    public SourceValidity getValidity() {
        DSpaceObject dso = null;
        if (this.validity == null) {
            try {
                dso = HandleUtil.obtainHandle((Map)this.objectModel);
                DSpaceValidity newValidity = new DSpaceValidity();
                newValidity.add(this.context, dso);
                this.validity = newValidity.complete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.validity;
    }

    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        boolean googleEnabled;
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        if (!(dso instanceof Item)) {
            return;
        }
        Item item = (Item)dso;
        String title = item.getName();
        if (title != null) {
            pageMeta.addMetadata("title").addContent(title);
        } else {
            pageMeta.addMetadata("title").addContent(item.getHandle());
        }
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        HandleUtil.buildHandleTrail((Context)this.context, (DSpaceObject)item, (PageMeta)pageMeta, (String)this.contextPath);
        pageMeta.addTrail().addContent(T_trail);
        String sfxserverUrl = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("sfx.server.url");
        if (sfxserverUrl != null && sfxserverUrl.length() > 0) {
            String sfxQuery = "";
            sfxQuery = this.sfxFileReaderService.loadSFXFile(this.sfxFile, item);
            if (sfxQuery.startsWith("&")) {
                sfxQuery = sfxQuery.substring(1);
            }
            sfxserverUrl = sfxserverUrl.trim() + "&" + sfxQuery.trim();
            pageMeta.addMetadata("sfx", "server").addContent(sfxserverUrl);
        }
        String identifierField = (String)DSpaceServicesFactory.getInstance().getConfigurationService().getPropertyAsType("altmetrics.field", (Object)"dc.identifier.uri");
        for (MetadataValue uri : ContentServiceFactory.getInstance().getDSpaceObjectService(dso).getMetadataByMetadataString(dso, identifierField)) {
            String idValue;
            String idType;
            Matcher handleMatcher = handlePattern.matcher(uri.getValue());
            Matcher doiMatcher = doiPattern.matcher(uri.getValue());
            if (handleMatcher.lookingAt()) {
                idType = "handle";
                idValue = uri.getValue().substring(handleMatcher.end());
            } else if (doiMatcher.lookingAt()) {
                idType = "doi";
                idValue = uri.getValue().substring(doiMatcher.end());
            } else {
                log.info("Unhandled identifier URI {}", (Object)uri.getValue());
                continue;
            }
            log.debug("Adding identifier of type {}", (Object)idType);
            Metadata md = pageMeta.addMetadata("identifier", idType);
            md.addContent(idValue);
        }
        String sfxserverImg = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("sfx.server.image_url");
        if (sfxserverImg != null && sfxserverImg.length() > 0) {
            pageMeta.addMetadata("sfx", "image_url").addContent(sfxserverImg);
        }
        if (googleEnabled = DSpaceServicesFactory.getInstance().getConfigurationService().getBooleanProperty("google-metadata.enable", false)) {
            GoogleMetadata gmd = new GoogleMetadata(this.context, item);
            for (Map.Entry m : gmd.getMappings()) {
                pageMeta.addMetadata((String)m.getKey()).addContent((String)m.getValue());
            }
        }
        if (this.xHTMLHeadCrosswalk == null) {
            this.xHTMLHeadCrosswalk = (DisseminationCrosswalk)CoreServiceFactory.getInstance().getPluginService().getNamedPlugin(DisseminationCrosswalk.class, "XHTML_HEAD_ITEM");
        }
        try {
            List l = this.xHTMLHeadCrosswalk.disseminateList(this.context, (DSpaceObject)item);
            StringWriter sw = new StringWriter();
            XMLOutputter xmlo = new XMLOutputter();
            xmlo.output(new Text("\n"), (Writer)sw);
            for (int i = 0; i < l.size(); ++i) {
                Element e = (Element)l.get(i);
                e.setNamespace(null);
                xmlo.output(e, (Writer)sw);
                xmlo.output(new Text("\n"), (Writer)sw);
            }
            pageMeta.addMetadata("xhtml_head_item").addContent(sw.toString());
        }
        catch (CrosswalkException ce) {
            throw new WingException((Throwable)ce);
        }
    }

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        String link;
        String link2;
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        if (!(dso instanceof Item)) {
            return;
        }
        Item item = (Item)dso;
        Division division = body.addDivision("item-view", "primary");
        String title = item.getName();
        if (title != null) {
            division.setHead(title);
        } else {
            division.setHead(item.getHandle());
        }
        if (item.isWithdrawn()) {
            Division div = division.addDivision("notice", "notice");
            Para p = div.addPara();
            p.addContent(T_withdrawn);
            HttpServletResponse response = (HttpServletResponse)this.objectModel.get("httpresponse");
            response.setStatus(404);
            return;
        }
        Para showfullPara = division.addPara(null, "item-view-toggle item-view-toggle-top");
        if (ItemViewer.showFullItem((Map)this.objectModel)) {
            link2 = this.contextPath + "/handle/" + item.getHandle();
            showfullPara.addXref(link2).addContent(T_show_simple);
        } else {
            link2 = this.contextPath + "/handle/" + item.getHandle() + "?show=full";
            showfullPara.addXref(link2).addContent(T_show_full);
        }
        ReferenceSet referenceSet = ItemViewer.showFullItem((Map)this.objectModel) ? division.addReferenceSet("collection-viewer", "detailView") : division.addReferenceSet("collection-viewer", "summaryView");
        ReferenceSet appearsInclude = referenceSet.addReference((Object)item).addReferenceSet("detailList", null, "hierarchy");
        appearsInclude.setHead(T_head_parent_collections);
        for (Collection collection : item.getCollections()) {
            appearsInclude.addReference((Object)collection);
        }
        showfullPara = division.addPara(null, "item-view-toggle item-view-toggle-bottom");
        if (ItemViewer.showFullItem((Map)this.objectModel)) {
            link = this.contextPath + "/handle/" + item.getHandle();
            showfullPara.addXref(link).addContent(T_show_simple);
        } else {
            link = this.contextPath + "/handle/" + item.getHandle() + "?show=full";
            showfullPara.addXref(link).addContent(T_show_full);
        }
    }

    public static boolean showFullItem(Map objectModel) {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String show = request.getParameter("show");
        return show != null && show.length() > 0;
    }

    public void recycle() {
        this.validity = null;
        super.recycle();
    }
}

