/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.discovery;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.util.HashUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.excalibur.source.SourceValidity;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.aspect.discovery.DiscoveryUIUtils;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.DSpaceValidity;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Options;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.discovery.DiscoverFacetField;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.SearchUtils;
import org.dspace.discovery.configuration.DiscoveryConfiguration;
import org.dspace.discovery.configuration.DiscoverySearchFilterFacet;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class SidebarFacetsTransformer
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    private static final Logger log = Logger.getLogger(SidebarFacetsTransformer.class);
    protected DiscoverResult queryResults;
    protected DiscoverQuery queryArgs;
    protected SourceValidity validity;
    private static final Message T_FILTER_HEAD = SidebarFacetsTransformer.message((String)"xmlui.discovery.AbstractFiltersTransformer.filters.head");
    private static final Message T_VIEW_MORE = SidebarFacetsTransformer.message((String)"xmlui.discovery.AbstractFiltersTransformer.filters.view-more");
    protected HandleService handleService = HandleServiceFactory.getInstance().getHandleService();

    protected SearchService getSearchService() {
        return (SearchService)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName(SearchService.class.getName(), SearchService.class);
    }

    public Serializable getKey() {
        try {
            DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
            if (dso != null) {
                return Long.valueOf(HashUtil.hash((String)dso.getHandle()));
            }
            return "0";
        }
        catch (SQLException sqle) {
            return "0";
        }
    }

    public SourceValidity getValidity() {
        if (this.validity == null) {
            try {
                DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
                DSpaceValidity val = new DSpaceValidity();
                this.performSearch();
                if (dso != null) {
                    val.add(this.context, dso);
                }
                val.add("numFound:" + this.queryResults.getDspaceObjects().size());
                for (DSpaceObject resultDso : this.queryResults.getDspaceObjects()) {
                    val.add(this.context, resultDso);
                }
                for (String facetField : this.queryResults.getFacetResults().keySet()) {
                    val.add(facetField);
                    List facetValues = (List)this.queryResults.getFacetResults().get(facetField);
                    for (DiscoverResult.FacetResult facetValue : facetValues) {
                        val.add(facetField + facetValue.getAsFilterQuery() + facetValue.getCount());
                    }
                }
                this.validity = val.complete();
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return this.validity;
    }

    public void performSearch() throws SearchServiceException, UIException, SQLException {
        DSpaceObject dso = this.getScope();
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        this.queryArgs = this.getQueryArgs(this.context, dso, DiscoveryUIUtils.getFilterQueries((Request)request, (Context)this.context));
        String query = request.getParameter("query");
        if (query != null && !"".equals(query)) {
            query = DiscoveryUIUtils.escapeQueryChars((String)query);
            this.queryArgs.setQuery(query);
        }
        this.queryArgs.setMaxResults(0);
        this.queryResults = this.getSearchService().search(this.context, dso, this.queryArgs);
    }

    public void addOptions(Options options) throws SAXException, WingException, SQLException, IOException, AuthorizeException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        try {
            this.performSearch();
        }
        catch (Exception e) {
            log.error((Object)"Error while searching for sidebar facets", (Throwable)e);
            return;
        }
        if (this.queryResults != null) {
            DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
            List<String> fqs = Arrays.asList(DiscoveryUIUtils.getFilterQueries((Request)request, (Context)this.context));
            DiscoveryConfiguration discoveryConfiguration = SearchUtils.getDiscoveryConfiguration((DSpaceObject)dso);
            List facets = discoveryConfiguration.getSidebarFacets();
            if (facets != null && 0 < facets.size()) {
                org.dspace.app.xmlui.wing.element.List browse = null;
                block2: for (DiscoverySearchFilterFacet field : facets) {
                    List facetValues = this.queryResults.getFacetResult(field.getIndexFieldName());
                    if (facetValues.size() == 0 && field.getType().equals("date")) {
                        facetValues = this.queryResults.getFacetResult(field.getIndexFieldName() + ".year");
                    }
                    int shownFacets = field.getFacetLimit() + 1;
                    if (facetValues == null || 0 >= facetValues.size()) continue;
                    if (browse == null) {
                        browse = options.addList("discovery");
                        browse.setHead(T_FILTER_HEAD);
                    }
                    Iterator iter = facetValues.iterator();
                    org.dspace.app.xmlui.wing.element.List filterValsList = browse.addList(field.getIndexFieldName());
                    filterValsList.setHead(SidebarFacetsTransformer.message((String)("xmlui.ArtifactBrowser.AdvancedSearch.type_" + field.getIndexFieldName())));
                    for (int i = 0; i < shownFacets; ++i) {
                        if (!iter.hasNext()) {
                            if (!field.getType().equals("hierarchical")) continue block2;
                            this.addViewMoreUrl(filterValsList, dso, request, field);
                            continue block2;
                        }
                        DiscoverResult.FacetResult value = (DiscoverResult.FacetResult)iter.next();
                        if (i < shownFacets - 1) {
                            String displayedValue = value.getDisplayedValue();
                            String filterQuery = value.getAsFilterQuery();
                            String filterType = value.getFilterType();
                            if (fqs.contains(this.getSearchService().toFilterQuery(this.context, field.getIndexFieldName(), value.getFilterType(), value.getAsFilterQuery()).getFilterQuery())) {
                                filterValsList.addItem(Math.random() + "", "selected").addContent(displayedValue + " (" + value.getCount() + ")");
                            } else {
                                String paramsQuery = this.retrieveParameters(request);
                                filterValsList.addItem().addXref(this.contextPath + (dso == null ? "" : "/handle/" + dso.getHandle()) + "/discover?" + paramsQuery + "filtertype=" + field.getIndexFieldName() + "&filter_relational_operator=" + filterType + "&filter=" + SidebarFacetsTransformer.encodeForURL((String)filterQuery), displayedValue + " (" + value.getCount() + ")");
                            }
                        }
                        if (i != shownFacets - 1 || field.getType().equals("date")) continue;
                        this.addViewMoreUrl(filterValsList, dso, request, field);
                    }
                }
            }
        }
    }

    private String retrieveParameters(Request request) throws UnsupportedEncodingException, UIException {
        ArrayList<String> parameters = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)request.getParameter("query"))) {
            parameters.add("query=" + SidebarFacetsTransformer.encodeForURL((String)request.getParameter("query")));
        }
        if (StringUtils.isNotBlank((String)request.getParameter("scope"))) {
            parameters.add("scope=" + request.getParameter("scope"));
        }
        if (StringUtils.isNotBlank((String)request.getParameter("sort_by"))) {
            parameters.add("sort_by=" + request.getParameter("sort_by"));
        }
        if (StringUtils.isNotBlank((String)request.getParameter("order"))) {
            parameters.add("order=" + request.getParameter("order"));
        }
        if (StringUtils.isNotBlank((String)request.getParameter("rpp"))) {
            parameters.add("rpp=" + request.getParameter("rpp"));
        }
        Map parameterFilterQueries = DiscoveryUIUtils.getParameterFilterQueries((Request)request);
        for (String parameter : parameterFilterQueries.keySet()) {
            for (int i = 0; i < ((String[])parameterFilterQueries.get(parameter)).length; ++i) {
                String value = ((String[])parameterFilterQueries.get(parameter))[i];
                parameters.add(parameter + "=" + SidebarFacetsTransformer.encodeForURL((String)value));
            }
        }
        String parametersString = StringUtils.join((Object[])parameters.toArray(new String[parameters.size()]), (String)"&");
        if (StringUtils.isNotEmpty((String)parametersString)) {
            parametersString = parametersString + "&";
        }
        return parametersString;
    }

    private void addViewMoreUrl(org.dspace.app.xmlui.wing.element.List facet, DSpaceObject dso, Request request, DiscoverySearchFilterFacet field) throws WingException, UnsupportedEncodingException {
        String parameters = this.retrieveParameters(request);
        facet.addItem().addXref(this.contextPath + (dso == null ? "" : "/handle/" + dso.getHandle()) + "/search-filter?" + parameters + "field" + "=" + field.getIndexFieldName() + "&order=" + field.getSortOrderFilterPage(), T_VIEW_MORE);
    }

    public DiscoverQuery getQueryArgs(Context context, DSpaceObject scope, String ... filterQueries) {
        DiscoverQuery queryArgs = new DiscoverQuery();
        DiscoveryConfiguration discoveryConfiguration = SearchUtils.getDiscoveryConfiguration((DSpaceObject)scope);
        List facets = discoveryConfiguration.getSidebarFacets();
        log.info((Object)("facets for scope, " + scope + ": " + (facets != null ? Integer.valueOf(facets.size()) : null)));
        if (facets != null) {
            queryArgs.setFacetMinCount(1);
        }
        queryArgs.addFilterQueries(discoveryConfiguration.getDefaultFilterQueries().toArray(new String[discoveryConfiguration.getDefaultFilterQueries().size()]));
        queryArgs.addFilterQueries(filterQueries);
        if (facets != null) {
            for (DiscoverySearchFilterFacet facet : facets) {
                if (facet.getType().equals("date")) {
                    String dateFacet = facet.getIndexFieldName() + ".year";
                    try {
                        int oldestYear = -1;
                        int newestYear = -1;
                        for (String filterQuery : filterQueries) {
                            if (!filterQuery.startsWith(dateFacet + ":")) continue;
                            Pattern pattern = Pattern.compile("\\[(.*? TO .*?)\\]");
                            Matcher matcher = pattern.matcher(filterQuery);
                            boolean hasPattern = matcher.find();
                            if (hasPattern) {
                                filterQuery = matcher.group(0);
                                int tempOldYear = Integer.parseInt(filterQuery.split(" TO ")[0].replace("[", "").trim());
                                int tempNewYear = Integer.parseInt(filterQuery.split(" TO ")[1].replace("]", "").trim());
                                if (tempNewYear >= newestYear && oldestYear >= tempOldYear && newestYear != -1) continue;
                                oldestYear = tempOldYear;
                                newestYear = tempNewYear;
                                continue;
                            }
                            if (filterQuery.indexOf(" OR ") != -1) {
                                filterQuery = filterQuery.split(" OR ")[0];
                            }
                            newestYear = oldestYear = Integer.parseInt(filterQuery.split(":")[1].trim());
                            break;
                        }
                        if (oldestYear == -1 && newestYear == -1) {
                            List searchDocuments;
                            List searchDocuments2;
                            DiscoverQuery yearRangeQuery = new DiscoverQuery();
                            yearRangeQuery.setMaxResults(1);
                            yearRangeQuery.addFieldPresentQueries(new String[]{dateFacet});
                            yearRangeQuery.setSortField(dateFacet + "_sort", DiscoverQuery.SORT_ORDER.asc);
                            yearRangeQuery.addFilterQueries(filterQueries);
                            yearRangeQuery.addSearchField(dateFacet);
                            DiscoverResult lastYearResult = this.getSearchService().search(context, scope, yearRangeQuery);
                            if (0 < lastYearResult.getDspaceObjects().size() && 0 < (searchDocuments2 = lastYearResult.getSearchDocument((DSpaceObject)lastYearResult.getDspaceObjects().get(0))).size() && 0 < ((DiscoverResult.SearchDocument)searchDocuments2.get(0)).getSearchFieldValues(dateFacet).size()) {
                                oldestYear = Integer.parseInt((String)((DiscoverResult.SearchDocument)searchDocuments2.get(0)).getSearchFieldValues(dateFacet).get(0));
                            }
                            yearRangeQuery.setSortField(dateFacet + "_sort", DiscoverQuery.SORT_ORDER.desc);
                            DiscoverResult firstYearResult = this.getSearchService().search(context, scope, yearRangeQuery);
                            if (0 < firstYearResult.getDspaceObjects().size() && 0 < (searchDocuments = firstYearResult.getSearchDocument((DSpaceObject)firstYearResult.getDspaceObjects().get(0))).size() && 0 < ((DiscoverResult.SearchDocument)searchDocuments.get(0)).getSearchFieldValues(dateFacet).size()) {
                                newestYear = Integer.parseInt((String)((DiscoverResult.SearchDocument)searchDocuments.get(0)).getSearchFieldValues(dateFacet).get(0));
                            }
                            if (newestYear == -1 || oldestYear == -1) continue;
                        }
                        int gap = 1;
                        int yearDifference = newestYear - oldestYear;
                        if (yearDifference != 0) {
                            while (10.0 < (double)yearDifference / (double)gap) {
                                gap *= 10;
                            }
                        }
                        int topYear = (int)(Math.ceil((float)newestYear / (float)gap) * (double)gap);
                        if (gap == 1) {
                            queryArgs.addFacetField(new DiscoverFacetField(facet.getIndexFieldName(), facet.getType(), 10, facet.getSortOrderSidebar()));
                            continue;
                        }
                        ArrayList<String> facetQueries = new ArrayList<String>();
                        for (int year = topYear; year > oldestYear && facetQueries.size() < 11; year -= gap) {
                            int bottomYear = year - gap;
                            if (bottomYear < oldestYear) {
                                bottomYear = oldestYear;
                            }
                            int currentTop = year;
                            currentTop = year == topYear ? newestYear : --currentTop;
                            facetQueries.add(dateFacet + ":[" + bottomYear + " TO " + currentTop + "]");
                        }
                        for (String facetQuery : facetQueries) {
                            queryArgs.addFacetQuery(facetQuery);
                        }
                        continue;
                    }
                    catch (Exception e) {
                        log.error((Object)LogManager.getHeader((Context)context, (String)"Error in Discovery while setting up date facet range", (String)("date facet: " + dateFacet)), (Throwable)e);
                        continue;
                    }
                }
                int facetLimit = facet.getFacetLimit();
                queryArgs.addFacetField(new DiscoverFacetField(facet.getIndexFieldName(), facet.getType(), ++facetLimit, facet.getSortOrderSidebar()));
            }
        }
        return queryArgs;
    }

    private DSpaceObject getScope() throws SQLException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String scopeString = request.getParameter("scope");
        DSpaceObject dso = scopeString == null || "".equals(scopeString) ? HandleUtil.obtainHandle((Map)this.objectModel) : this.handleService.resolveToObject(this.context, scopeString);
        return dso;
    }

    public void recycle() {
        this.queryResults = null;
        this.queryArgs = null;
        this.validity = null;
        super.recycle();
    }
}

