/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.general;

import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.matching.Matcher;
import org.apache.cocoon.sitemap.PatternException;
import org.apache.commons.collections.CollectionUtils;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;

public class HandleMatcher
extends AbstractLogEnabled
implements Matcher {
    public Map match(String pattern, Map objectModel, Parameters parameters) throws PatternException {
        try {
            DSpaceObject dso = HandleUtil.obtainHandle((Map)objectModel);
            if (dso == null) {
                return null;
            }
            DSpaceObject parent = this.dspaceObjectWalk(dso, pattern);
            if (parent != null) {
                return new HashMap();
            }
            return null;
        }
        catch (SQLException sqle) {
            throw new PatternException("Unable to obtain DSpace Context", (Throwable)sqle);
        }
    }

    private DSpaceObject dspaceObjectWalk(DSpaceObject dso, String handle) throws SQLException {
        DSpaceObject current = dso;
        while (current != null) {
            if (current.getHandle().equals(handle)) {
                return current;
            }
            if (dso.getType() == 2) {
                current = ((Item)current).getOwningCollection();
                continue;
            }
            if (dso.getType() == 3) {
                current = (DSpaceObject)((org.dspace.content.Collection)current).getCommunities().get(0);
                continue;
            }
            if (dso.getType() != 4) continue;
            List parentCommunities = ((Community)current).getParentCommunities();
            if (CollectionUtils.isNotEmpty((Collection)parentCommunities)) {
                current = (DSpaceObject)parentCommunities.get(0);
                continue;
            }
            current = null;
        }
        return null;
    }
}

