/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.submission;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.DSpaceValidity;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.GroupService;
import org.xml.sax.SAXException;

public class CollectionViewer
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    protected static final Message T_title = CollectionViewer.message((String)"xmlui.Submission.SelectCollection.title");
    protected static final Message T_submit = CollectionViewer.message((String)"xmlui.Submission.CollectionViewer.link1");
    private SourceValidity validity;
    protected AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    protected GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();

    public Serializable getKey() {
        try {
            DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
            if (dso == null) {
                return "0";
            }
            return Long.valueOf(HashUtil.hash((String)dso.getHandle()));
        }
        catch (SQLException sqle) {
            return "0";
        }
    }

    public SourceValidity getValidity() {
        if (this.validity == null) {
            try {
                DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
                if (dso == null) {
                    return null;
                }
                if (!(dso instanceof Collection)) {
                    return null;
                }
                Collection collection = (Collection)dso;
                DSpaceValidity validity = new DSpaceValidity();
                validity.add(this.context, (DSpaceObject)collection);
                validity.add(this.context, (DSpaceObject)this.eperson);
                List groups = this.groupService.allMemberGroups(this.context, this.eperson);
                for (Group group : groups) {
                    validity.add(this.context, (DSpaceObject)group);
                }
                this.validity = validity.complete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.validity;
    }

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        if (!(dso instanceof Collection)) {
            return;
        }
        Collection collection = (Collection)dso;
        if (this.authorizeService.authorizeActionBoolean(this.context, (DSpaceObject)collection, 3)) {
            Division home = body.addDivision("collection-home", "primary repository collection");
            Division viewer = home.addDivision("collection-view", "secondary");
            String submitURL = this.contextPath + "/handle/" + collection.getHandle() + "/submit";
            viewer.addPara().addXref(submitURL, T_submit);
        }
    }

    public void recycle() {
        this.validity = null;
        super.recycle();
    }
}

