/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.submission;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang.StringUtils;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Cell;
import org.dspace.app.xmlui.wing.element.CheckBox;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.SupervisedItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.eperson.EPerson;
import org.xml.sax.SAXException;

public class Submissions
extends AbstractDSpaceTransformer {
    protected static final Message T_title = Submissions.message((String)"xmlui.Submission.Submissions.title");
    protected static final Message T_dspace_home = Submissions.message((String)"xmlui.general.dspace_home");
    protected static final Message T_trail = Submissions.message((String)"xmlui.Submission.Submissions.trail");
    protected static final Message T_head = Submissions.message((String)"xmlui.Submission.Submissions.head");
    protected static final Message T_untitled = Submissions.message((String)"xmlui.Submission.Submissions.untitled");
    protected static final Message T_email = Submissions.message((String)"xmlui.Submission.Submissions.email");
    protected static final Message T_s_head1 = Submissions.message((String)"xmlui.Submission.Submissions.submit_head1");
    protected static final Message T_s_info1a = Submissions.message((String)"xmlui.Submission.Submissions.submit_info1a");
    protected static final Message T_s_info1b = Submissions.message((String)"xmlui.Submission.Submissions.submit_info1b");
    protected static final Message T_s_info1c = Submissions.message((String)"xmlui.Submission.Submissions.submit_info1c");
    protected static final Message T_s_head2 = Submissions.message((String)"xmlui.Submission.Submissions.submit_head2");
    protected static final Message T_s_info2a = Submissions.message((String)"xmlui.Submission.Submissions.submit_info2a");
    protected static final Message T_s_info2b = Submissions.message((String)"xmlui.Submission.Submissions.submit_info2b");
    protected static final Message T_s_info2c = Submissions.message((String)"xmlui.Submission.Submissions.submit_info2c");
    protected static final Message T_s_column1 = Submissions.message((String)"xmlui.Submission.Submissions.submit_column1");
    protected static final Message T_s_column2 = Submissions.message((String)"xmlui.Submission.Submissions.submit_column2");
    protected static final Message T_s_column3 = Submissions.message((String)"xmlui.Submission.Submissions.submit_column3");
    protected static final Message T_s_column4 = Submissions.message((String)"xmlui.Submission.Submissions.submit_column4");
    protected static final Message T_s_head3 = Submissions.message((String)"xmlui.Submission.Submissions.submit_head3");
    protected static final Message T_s_info3 = Submissions.message((String)"xmlui.Submission.Submissions.submit_info3");
    protected static final Message T_s_head4 = Submissions.message((String)"xmlui.Submission.Submissions.submit_head4");
    protected static final Message T_s_submit_remove = Submissions.message((String)"xmlui.Submission.Submissions.submit_submit_remove");
    protected static final Message T_c_head = Submissions.message((String)"xmlui.Submission.Submissions.completed.head");
    protected static final Message T_c_info = Submissions.message((String)"xmlui.Submission.Submissions.completed.info");
    protected static final Message T_c_column1 = Submissions.message((String)"xmlui.Submission.Submissions.completed.column1");
    protected static final Message T_c_column2 = Submissions.message((String)"xmlui.Submission.Submissions.completed.column2");
    protected static final Message T_c_column3 = Submissions.message((String)"xmlui.Submission.Submissions.completed.column3");
    protected static final Message T_c_limit = Submissions.message((String)"xmlui.Submission.Submissions.completed.limit");
    protected static final Message T_c_displayall = Submissions.message((String)"xmlui.Submission.Submissions.completed.displayall");
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected SupervisedItemService supervisedItemService = ContentServiceFactory.getInstance().getSupervisedItemService();

    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrailLink(null, T_trail);
    }

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        boolean displayAll = false;
        if (request.getParameter("all") != null) {
            displayAll = true;
        }
        Division div = body.addInteractiveDivision("submissions", this.contextPath + "/submissions", "post", "primary");
        div.setHead(T_head);
        this.addUnfinishedSubmissions(div);
        this.addPreviousSubmissions(div, displayAll);
    }

    private void addWorkflowTasksDiv(Division division) throws SQLException, WingException, AuthorizeException, IOException {
        division.addDivision("workflow-tasks");
    }

    private void addUnfinishedSubmissions(Division division) throws SQLException, WingException {
        Cell cell;
        Row row;
        String collectionName;
        String submitterEmail;
        String submitterName;
        String url;
        int workspaceItemID;
        EPerson submitterEPerson;
        String title;
        List collections;
        List unfinishedItems = this.workspaceItemService.findByEPerson(this.context, this.context.getCurrentUser());
        List supervisedItems = this.supervisedItemService.findbyEPerson(this.context, this.context.getCurrentUser());
        if (unfinishedItems.size() <= 0 && supervisedItems.size() <= 0 && (collections = this.collectionService.findAuthorizedOptimized(this.context, 3)).size() > 0) {
            Division start = division.addDivision("start-submision");
            start.setHead(T_s_head1);
            Para p = start.addPara();
            p.addContent(T_s_info1a);
            p.addXref(this.contextPath + "/submit", T_s_info1b);
            Para secondP = start.addPara();
            secondP.addContent(T_s_info1c);
            return;
        }
        Division unfinished = division.addDivision("unfinished-submisions");
        unfinished.setHead(T_s_head2);
        Para p = unfinished.addPara();
        p.addContent(T_s_info2a);
        p.addHighlight("bold").addXref(this.contextPath + "/submit", T_s_info2b);
        p.addContent(T_s_info2c);
        int rows = unfinishedItems.size() + supervisedItems.size() + 2;
        if (supervisedItems.size() > 0 && unfinishedItems.size() > 0) {
            ++rows;
        }
        if (supervisedItems.size() > 0) {
            ++rows;
        }
        Table table = unfinished.addTable("unfinished-submissions", rows, 5);
        Row header = table.addRow("header");
        header.addCellContent(T_s_column1);
        header.addCellContent(T_s_column2);
        header.addCellContent(T_s_column3);
        header.addCellContent(T_s_column4);
        if (supervisedItems.size() > 0 && unfinishedItems.size() > 0) {
            header = table.addRow();
            header.addCell(null, "header", 0, 5, null).addContent(T_s_head3);
        }
        if (unfinishedItems.size() > 0) {
            for (WorkspaceItem workspaceItem : unfinishedItems) {
                title = workspaceItem.getItem().getName();
                submitterEPerson = workspaceItem.getItem().getSubmitter();
                workspaceItemID = workspaceItem.getID();
                url = this.contextPath + "/submit?workspaceID=" + workspaceItemID;
                submitterName = submitterEPerson.getFullName();
                submitterEmail = submitterEPerson.getEmail();
                collectionName = workspaceItem.getCollection().getName();
                row = table.addRow("data");
                CheckBox remove = row.addCell().addCheckBox("workspaceID");
                remove.setLabel("remove");
                remove.addOption(workspaceItemID);
                if (StringUtils.isNotBlank((String)title)) {
                    if (title.length() > 50) {
                        title = title.substring(0, 50) + " ...";
                    }
                    row.addCell().addXref(url, title);
                } else {
                    row.addCell().addXref(url, T_untitled);
                }
                row.addCell().addXref(url, collectionName);
                cell = row.addCell();
                cell.addContent(T_email);
                cell.addXref("mailto:" + submitterEmail, submitterName);
            }
        } else {
            header = table.addRow();
            header.addCell(0, 5).addHighlight("italic").addContent(T_s_info3);
        }
        if (supervisedItems.size() > 0) {
            header = table.addRow();
            header.addCell(null, "header", 0, 5, null).addContent(T_s_head4);
        }
        for (WorkspaceItem workspaceItem : supervisedItems) {
            title = workspaceItem.getItem().getName();
            submitterEPerson = workspaceItem.getItem().getSubmitter();
            workspaceItemID = workspaceItem.getID();
            url = this.contextPath + "/submit?workspaceID=" + workspaceItemID;
            submitterName = submitterEPerson.getFullName();
            submitterEmail = submitterEPerson.getEmail();
            collectionName = workspaceItem.getCollection().getName();
            row = table.addRow("data");
            CheckBox selected = row.addCell().addCheckBox("workspaceID");
            selected.setLabel("select");
            selected.addOption(workspaceItemID);
            if (StringUtils.isNotBlank((String)title)) {
                if (title.length() > 50) {
                    title = title.substring(0, 50) + " ...";
                }
                row.addCell().addXref(url, title);
            } else {
                row.addCell().addXref(url, T_untitled);
            }
            row.addCell().addXref(url, collectionName);
            cell = row.addCell();
            cell.addContent(T_email);
            cell.addXref("mailto:" + submitterEmail, submitterName);
        }
        header = table.addRow();
        Cell lastCell = header.addCell(0, 5);
        if (unfinishedItems.size() > 0 || supervisedItems.size() > 0) {
            lastCell.addButton("submit_submissions_remove").setValue(T_s_submit_remove);
        }
    }

    private void addSubmissionsInWorkflowDiv(Division division) throws SQLException, WingException, AuthorizeException, IOException {
        division.addDivision("submissions-inprogress");
    }

    private void addPreviousSubmissions(Division division, boolean displayAll) throws SQLException, WingException {
        LinkedList subList = new LinkedList();
        Integer limit = displayAll ? Integer.valueOf(-1) : Integer.valueOf(50);
        Iterator subs = this.itemService.findBySubmitterDateSorted(this.context, this.context.getCurrentUser(), limit);
        while (subs.hasNext()) {
            subList.add(subs.next());
        }
        if (subList.size() <= 0) {
            return;
        }
        Division completedSubmissions = division.addDivision("completed-submissions");
        completedSubmissions.setHead(T_c_head);
        completedSubmissions.addPara(T_c_info);
        Table table = completedSubmissions.addTable("completed-submissions", subList.size() + 2, 3);
        Row header = table.addRow("header");
        header.addCellContent(T_c_column1);
        header.addCellContent(T_c_column2);
        header.addCellContent(T_c_column3);
        int count = 0;
        Iterator i = subList.iterator();
        while (i.hasNext() && (++count <= limit || displayAll)) {
            Item published = (Item)i.next();
            String collUrl = this.contextPath + "/handle/" + published.getOwningCollection().getHandle();
            String itemUrl = this.contextPath + "/handle/" + published.getHandle();
            List titles = this.itemService.getMetadata((DSpaceObject)published, "dc", "title", null, "*");
            String collectionName = published.getOwningCollection().getName();
            List ingestDate = this.itemService.getMetadata((DSpaceObject)published, "dc", "date", "accessioned", "*");
            Row row = table.addRow();
            if (ingestDate != null && ingestDate.size() > 0 && ((MetadataValue)ingestDate.get(0)).getValue() != null) {
                String displayDate = ((MetadataValue)ingestDate.get(0)).getValue().substring(0, 10);
                Cell cellDate = row.addCell();
                cellDate.addContent(displayDate);
            } else {
                row.addCell().addContent("");
            }
            if (titles != null && titles.size() > 0 && ((MetadataValue)titles.get(0)).getValue() != null) {
                String displayTitle = ((MetadataValue)titles.get(0)).getValue();
                if (displayTitle.length() > 50) {
                    displayTitle = displayTitle.substring(0, 50) + " ...";
                }
                row.addCell().addXref(itemUrl, displayTitle);
            } else {
                row.addCell().addXref(itemUrl, T_untitled);
            }
            row.addCell().addXref(collUrl, collectionName);
        }
        if (!displayAll && count == limit) {
            Para limitedList = completedSubmissions.addPara();
            limitedList.addContent(T_c_limit);
            limitedList.addXref(this.contextPath + "/submissions?all", T_c_displayall);
        }
    }
}

