/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.submission.submit;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.dspace.app.xmlui.aspect.submission.AbstractSubmissionStep;
import org.dspace.app.xmlui.aspect.submission.submit.ReviewStep;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.CheckBox;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.xml.sax.SAXException;

public class InitialQuestionsStep
extends AbstractSubmissionStep {
    protected static final Message T_head = InitialQuestionsStep.message((String)"xmlui.Submission.submit.InitialQuestionsStep.head");
    protected static final Message T_important_note = InitialQuestionsStep.message((String)"xmlui.Submission.submit.InitialQuestionsStep.important_note");
    protected static final Message T_and = InitialQuestionsStep.message((String)"xmlui.Submission.submit.InitialQuestionsStep.and");
    protected static final Message T_separator = InitialQuestionsStep.message((String)"xmlui.Submission.submit.InitialQuestionsStep.separator");
    protected static final Message T_open = InitialQuestionsStep.message((String)"xmlui.Submission.submit.InitialQuestionsStep.open_set");
    protected static final Message T_close = InitialQuestionsStep.message((String)"xmlui.Submission.submit.InitialQuestionsStep.close_set");
    protected static final Message T_multiple_titles = InitialQuestionsStep.message((String)"xmlui.Submission.submit.InitialQuestionsStep.multiple_titles");
    protected static final Message T_multiple_titles_help = InitialQuestionsStep.message((String)"xmlui.Submission.submit.InitialQuestionsStep.multiple_titles_help");
    protected static final Message T_multiple_titles_note = InitialQuestionsStep.message((String)"xmlui.Submission.submit.InitialQuestionsStep.multiple_titles_note");
    protected static final Message T_published_before = InitialQuestionsStep.message((String)"xmlui.Submission.submit.InitialQuestionsStep.published_before");
    protected static final Message T_published_before_help = InitialQuestionsStep.message((String)"xmlui.Submission.submit.InitialQuestionsStep.published_before_help");
    protected static final Message T_published_before_note = InitialQuestionsStep.message((String)"xmlui.Submission.submit.InitialQuestionsStep.published_before_note");
    protected static final Message T_date_issued = InitialQuestionsStep.message((String)"xmlui.Submission.submit.InitialQuestionsStep.date_issued");
    protected static final Message T_citation = InitialQuestionsStep.message((String)"xmlui.Submission.submit.InitialQuestionsStep.citation");
    protected static final Message T_publisher = InitialQuestionsStep.message((String)"xmlui.Submission.submit.InitialQuestionsStep.publisher");
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();

    public InitialQuestionsStep() {
        this.requireSubmission = true;
        this.requireStep = true;
    }

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        Item item = this.submission.getItem();
        Collection collection = this.submission.getCollection();
        String actionURL = this.contextPath + "/handle/" + collection.getHandle() + "/submit/" + this.knot.getId() + ".continue";
        List titles = this.itemService.getMetadata((DSpaceObject)item, "dc", "title", "alternative", "*");
        List dateIssued = this.itemService.getMetadata((DSpaceObject)item, "dc", "date", "issued", "*");
        List citation = this.itemService.getMetadata((DSpaceObject)item, "dc", "identifier", "citation", "*");
        List publisher = this.itemService.getMetadata((DSpaceObject)item, "dc", "publisher", null, "*");
        Division div = body.addInteractiveDivision("submit-initial-questions", actionURL, "post", "primary submission");
        div.setHead(T_submission_head);
        this.addSubmissionProgressList(div);
        org.dspace.app.xmlui.wing.element.List form = div.addList("submit-initial-questions", "form");
        form.setHead(T_head);
        CheckBox multipleTitles = form.addItem().addCheckBox("multiple_titles");
        multipleTitles.setLabel(T_multiple_titles);
        multipleTitles.setHelp(T_multiple_titles_help);
        multipleTitles.addOption("true");
        if (this.submission.hasMultipleTitles()) {
            multipleTitles.setOptionSelected("true");
        }
        if (titles.size() > 0) {
            org.dspace.app.xmlui.wing.element.Item note = form.addItem();
            note.addHighlight("bold").addContent(T_important_note);
            note.addContent(T_multiple_titles_note);
            for (int i = 0; i < titles.size(); ++i) {
                if (i > 0) {
                    note.addContent(T_separator);
                }
                note.addContent("\"");
                note.addHighlight("bold").addContent(((MetadataValue)titles.get(i)).getValue());
                note.addContent("\"");
            }
        }
        CheckBox publishedBefore = form.addItem().addCheckBox("published_before");
        publishedBefore.setLabel(T_published_before);
        publishedBefore.setHelp(T_published_before_help);
        publishedBefore.addOption("true");
        if (this.submission.isPublishedBefore()) {
            publishedBefore.setOptionSelected("true");
        }
        if (dateIssued.size() > 0 || citation.size() > 0 || publisher.size() > 0) {
            int i;
            org.dspace.app.xmlui.wing.element.Item note = form.addItem();
            note.addHighlight("bold").addContent(T_important_note);
            note.addContent(T_published_before_note);
            if (dateIssued.size() > 0) {
                note.addHighlight("bold").addContent(T_date_issued);
                note.addContent(T_open);
                for (i = 0; i < dateIssued.size(); ++i) {
                    if (i > 0) {
                        note.addContent(T_separator);
                    }
                    note.addContent(((MetadataValue)dateIssued.get(i)).getValue());
                }
                note.addContent(T_close);
            }
            if (dateIssued.size() > 0 && (citation.size() > 0 || publisher.size() > 0)) {
                note.addContent(T_separator);
            }
            if (dateIssued.size() > 0 && citation.size() > 0 && publisher.size() == 0) {
                note.addContent(T_and);
            }
            if (citation.size() > 0) {
                note.addHighlight("bold").addContent(T_citation);
                note.addContent(T_open);
                for (i = 0; i < citation.size(); ++i) {
                    if (i > 0) {
                        note.addContent(T_separator);
                    }
                    note.addContent(((MetadataValue)citation.get(i)).getValue());
                }
                note.addContent(T_close);
            }
            if (citation.size() > 0 && publisher.size() > 0) {
                note.addContent(T_separator);
            }
            if ((dateIssued.size() > 0 || citation.size() > 0) && publisher.size() > 0) {
                note.addContent(T_and);
            }
            if (publisher.size() > 0) {
                note.addHighlight("bold").addContent(T_publisher);
                note.addContent(T_open);
                for (i = 0; i < publisher.size(); ++i) {
                    if (i > 0) {
                        note.addContent(T_separator);
                    }
                    note.addContent(((MetadataValue)publisher.get(i)).getValue());
                }
                note.addContent(T_close);
            }
        }
        this.addControlButtons(form);
        div.addHidden("prune").setValue("true");
    }

    public org.dspace.app.xmlui.wing.element.List addReviewSection(org.dspace.app.xmlui.wing.element.List reviewList) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        org.dspace.app.xmlui.wing.element.List initSection = reviewList.addList("submit-review-" + this.stepAndPage, "form");
        initSection.setHead(T_head);
        Message multipleTitles = ReviewStep.T_no;
        if (this.submission.hasMultipleTitles()) {
            multipleTitles = ReviewStep.T_yes;
        }
        Message publishedBefore = ReviewStep.T_no;
        if (this.submission.isPublishedBefore()) {
            publishedBefore = ReviewStep.T_yes;
        }
        initSection.addLabel(T_multiple_titles);
        initSection.addItem(multipleTitles);
        initSection.addLabel(T_published_before);
        initSection.addItem(publishedBefore);
        return initSection;
    }
}

