/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.submission.submit;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.dspace.app.xmlui.aspect.submission.AbstractSubmissionStep;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.MetadataFieldService;
import org.xml.sax.SAXException;

public class StartSubmissionLookupStep
extends AbstractSubmissionStep {
    protected static final Message T_title = StartSubmissionLookupStep.message((String)"xmlui.Submission.submit.StartSubmissionLookupStep.title");
    protected static final Message T_lookup_help = StartSubmissionLookupStep.message((String)"xmlui.Submission.submit.StartSubmissionLookupStep.lookup_help");
    protected static final Message T_submit_lookup = StartSubmissionLookupStep.message((String)"xmlui.Submission.submit.StartSubmissionLookupStep.submit_lookup");
    protected static final Message T_submit_publication_item = StartSubmissionLookupStep.message((String)"xmlui.Submission.submit.StartSubmissionLookupStep.submit_publication_item");
    private ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    MetadataFieldService metadataFieldService = ContentServiceFactory.getInstance().getMetadataFieldService();

    public org.dspace.app.xmlui.wing.element.List addReviewSection(org.dspace.app.xmlui.wing.element.List reviewList) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        return null;
    }

    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException {
        pageMeta.addMetadata("title").addContent(T_submission_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrail().addContent(T_submission_trail);
        pageMeta.addMetadata("javascript", null, "handlebars", true).addContent("../../static/handlebars/handlebars.js");
        pageMeta.addMetadata("javascript", null, "submission-lookup", true).addContent("../../static/js/submission-lookup.js");
        pageMeta.addMetadata("stylesheet", "screen", "datatables", true).addContent("../../static/Datatables/DataTables-1.8.0/media/css/datatables.css");
        pageMeta.addMetadata("javascript", "static", "datatables", true).addContent("static/Datatables/DataTables-1.8.0/media/js/jquery.dataTables.min.js");
    }

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        Collection collection = this.submission.getCollection();
        String actionURL = this.contextPath + "/handle/" + collection.getHandle() + "/submit/" + this.knot.getId() + ".continue";
        Division div = body.addInteractiveDivision("StartSubmissionLookupStep", actionURL, "post", "primary submission");
        div.setHead(T_submission_head);
        this.addSubmissionProgressList(div);
        org.dspace.app.xmlui.wing.element.List form = div.addList("submit-lookup", "form");
        form.setHead(T_title);
        form.addItem().addContent(T_lookup_help);
        org.dspace.app.xmlui.wing.element.Item item = form.addItem("lookup-group", "input-group");
        item.addText("search");
        item.addButton("lookup").setValue(T_submit_lookup);
        Item submissionItem = this.submission.getItem();
        List pubmedId = this.itemService.getMetadata((DSpaceObject)submissionItem, "dc", "identifier", "other", "*");
        if (pubmedId.size() > 0) {
            List authors;
            form.addItem("publication-header", "page-header").addContent(T_submit_publication_item);
            List titles = this.itemService.getMetadata((DSpaceObject)submissionItem, "dc", "title", null, "*");
            if (titles.size() > 0) {
                form.addItem("publication-title", "bold").addContent(((MetadataValue)titles.get(0)).getValue());
            }
            if ((authors = this.itemService.getMetadata((DSpaceObject)submissionItem, "dc", "contributor", "author", "*")).size() > 0) {
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < authors.size(); ++i) {
                    builder.append(((MetadataValue)authors.get(i)).getValue());
                    if (i + 1 >= authors.size()) continue;
                    builder.append(", ");
                }
                if (builder.length() > 150) {
                    builder.setLength(147);
                    builder.append("...");
                }
                form.addItem().addContent(builder.toString());
            }
        }
        div.addDivision("lookup-modal");
        div.addHidden("publication_id");
        this.addControlButtons(form);
    }
}

