/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.versioning;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.dspace.app.util.Util;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.DSpaceValidity;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Options;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.GroupService;
import org.dspace.versioning.factory.VersionServiceFactory;
import org.dspace.versioning.service.VersionHistoryService;
import org.xml.sax.SAXException;

public class Navigation
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    private static final Message T_context_head = Navigation.message((String)"xmlui.administrative.Navigation.context_head");
    private static final Message T_context_create_version = Navigation.message((String)"xmlui.aspect.versioning.VersioningNavigation.context_create_version");
    private static final Message T_context_show_version_history = Navigation.message((String)"xmlui.aspect.versioning.VersioningNavigation.context_show_version_history");
    private SourceValidity validity;
    protected GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
    protected AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected VersionHistoryService versionHistoryService = VersionServiceFactory.getInstance().getVersionHistoryService();

    public Serializable getKey() {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        if (request.getParameter("login_email") != null || request.getParameter("login_password") != null || request.getParameter("login_realm") != null) {
            return "0";
        }
        String key = this.context.getCurrentUser() != null ? this.context.getCurrentUser().getEmail() : "anonymous";
        return Long.valueOf(HashUtil.hash((String)key));
    }

    public SourceValidity getValidity() {
        if (this.validity == null) {
            if (this.context.getCurrentUser() != null) {
                try {
                    DSpaceValidity validity = new DSpaceValidity();
                    validity.add(this.context, (DSpaceObject)this.eperson);
                    List groups = this.groupService.allMemberGroups(this.context, this.eperson);
                    for (Group group : groups) {
                        validity.add(this.context, (DSpaceObject)group);
                    }
                    DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
                    if (dso != null) {
                        validity.add(this.context, dso);
                    }
                    this.validity = validity.complete();
                }
                catch (SQLException sQLException) {}
            } else {
                this.validity = NOPValidity.SHARED_INSTANCE;
            }
        }
        return this.validity;
    }

    public void addOptions(Options options) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        Item item;
        options.addList("browse");
        options.addList("account");
        org.dspace.app.xmlui.wing.element.List context = options.addList("context");
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        if (dso == null) {
            dso = this.getItemById();
        }
        if (dso != null && dso.getType() == 2 && this.authorizeService.isAdmin(this.context, (DSpaceObject)(item = (Item)dso).getOwningCollection())) {
            boolean headAdded = false;
            if (this.versionHistoryService.isLastVersion(this.context, item) && item.isArchived()) {
                context.setHead(T_context_head);
                headAdded = true;
                context.addItem().addXref(this.contextPath + "/item/version?itemID=" + item.getID(), T_context_create_version);
            }
            if (this.versionHistoryService.hasVersionHistory(this.context, item)) {
                if (!headAdded) {
                    context.setHead(T_context_head);
                }
                context.addItem().addXref(this.contextPath + "/item/versionhistory?itemID=" + item.getID(), T_context_show_version_history);
            }
        }
    }

    private Item getItemById() throws SQLException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        Item item = null;
        UUID itemId = Util.getUUIDParameter((HttpServletRequest)request, (String)"itemID");
        if (itemId != null) {
            item = (Item)this.itemService.find(this.context, itemId);
        }
        return item;
    }

    public void recycle() {
        this.validity = null;
        super.recycle();
    }
}

