/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.versioning;

import java.sql.SQLException;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Composite;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DCDate;
import org.dspace.versioning.Version;
import org.dspace.versioning.factory.VersionServiceFactory;
import org.dspace.versioning.service.VersioningService;

public class RestoreVersionForm
extends AbstractDSpaceTransformer {
    private static final Message T_dspace_home = RestoreVersionForm.message((String)"xmlui.general.dspace_home");
    private static final Message T_item_trail = RestoreVersionForm.message((String)"xmlui.administrative.item.general.item_trail");
    private static final Message T_title = RestoreVersionForm.message((String)"xmlui.aspect.versioning.RestoreVersionForm.title");
    private static final Message T_trail = RestoreVersionForm.message((String)"xmlui.aspect.versioning.RestoreVersionForm.trail");
    private static final Message T_head1 = RestoreVersionForm.message((String)"xmlui.aspect.versioning.RestoreVersionForm.head1");
    private static final Message T_para1 = RestoreVersionForm.message((String)"xmlui.aspect.versioning.RestoreVersionForm.para1");
    private static final Message T_column1 = RestoreVersionForm.message((String)"xmlui.aspect.versioning.RestoreVersionForm.column1");
    private static final Message T_column2 = RestoreVersionForm.message((String)"xmlui.aspect.versioning.RestoreVersionForm.column2");
    private static final Message T_column3 = RestoreVersionForm.message((String)"xmlui.aspect.versioning.RestoreVersionForm.column3");
    private static final Message T_column4 = RestoreVersionForm.message((String)"xmlui.aspect.versioning.RestoreVersionForm.column4");
    private static final Message T_submit_restore = RestoreVersionForm.message((String)"xmlui.aspect.versioning.RestoreVersionForm.restore");
    private static final Message T_submit_cancel = RestoreVersionForm.message((String)"xmlui.general.cancel");
    protected VersioningService versioningService = VersionServiceFactory.getInstance().getVersionService();

    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrailLink(this.contextPath + "/admin/item", T_item_trail);
        pageMeta.addTrail().addContent(T_trail);
    }

    public void addBody(Body body) throws WingException, AuthorizeException, SQLException {
        Division main = this.createMainDivision(body);
        this.createTable(main);
        this.addButtons(main);
        main.addHidden("versioning-continue").setValue(this.knot.getId());
    }

    private Division createMainDivision(Body body) throws WingException {
        Division main = body.addInteractiveDivision("restore-version", this.contextPath + "/item/versionhistory", "post", "restore version");
        main.setHead(T_head1);
        main.addPara(T_para1);
        return main;
    }

    private void createTable(Division main) throws WingException, SQLException {
        String id = this.parameters.getParameter("versionID", null);
        Table table = main.addTable("version", 1, 1);
        Row header = table.addRow("header");
        header.addCellContent(T_column1);
        header.addCellContent(T_column2);
        header.addCellContent(T_column3);
        header.addCellContent(T_column4);
        Version version = this.versioningService.getVersion(this.context, Integer.parseInt(id));
        Row row = table.addRow();
        row.addCell().addContent(version.getVersionNumber());
        row.addCell().addContent(version.getEPerson().getEmail());
        row.addCell().addContent(new DCDate(version.getVersionDate()).toString());
        row.addCell().addContent(version.getSummary());
        List fields = main.addList("fields", "form");
        Composite addComposite = fields.addItem().addComposite("summary");
        addComposite.setLabel(T_column4);
        addComposite.addTextArea("summary");
    }

    private void addButtons(Division main) throws WingException {
        Para buttons = main.addPara();
        buttons.addButton("submit_restore").setValue(T_submit_restore);
        buttons.addButton("submit_cancel").setValue(T_submit_cancel);
    }
}

