/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.cocoon;

import java.io.File;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.configuration.XMLUIConfiguration;
import org.dspace.app.xmlui.utils.AuthenticationUtil;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.harvest.factory.HarvestServiceFactory;
import org.dspace.harvest.service.HarvestSchedulingService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class DSpaceCocoonServletFilter
implements Filter {
    private static final Logger LOG = Logger.getLogger(DSpaceCocoonServletFilter.class);
    private static final long serialVersionUID = 1L;
    protected HarvestSchedulingService harvestSchedulingService = HarvestServiceFactory.getInstance().getHarvestSchedulingService();

    public void init(FilterConfig arg0) throws ServletException {
        String webappConfigPath = null;
        String installedConfigPath = null;
        try {
            webappConfigPath = arg0.getServletContext().getRealPath("/") + File.separator + "WEB-INF" + File.separator + "xmlui.xconf";
            installedConfigPath = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("dspace.dir") + File.separator + "config" + File.separator + "xmlui.xconf";
            XMLUIConfiguration.loadConfig((String[])new String[]{webappConfigPath, installedConfigPath});
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException("\n\nDSpace has failed to initialize, during stage 3. Error while attempting to read \nthe XML UI configuration file (Path: " + webappConfigPath + " or '" + installedConfigPath + "').\n" + "This has likely occurred because either the file does not exist, or its permissions \n" + "are set incorrectly, or the path to the configuration file is incorrect. The XML UI \n" + "configuration file should be named \"xmlui.xconf\" and located inside the standard \n" + "DSpace configuration directory. \n\n", (Throwable)e);
        }
        if (DSpaceServicesFactory.getInstance().getConfigurationService().getBooleanProperty("oai.harvester.autoStart")) {
            try {
                this.harvestSchedulingService.startNewScheduler();
            }
            catch (RuntimeException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain arg2) throws IOException, ServletException {
        HttpServletRequest realRequest = (HttpServletRequest)request;
        HttpServletResponse realResponse = (HttpServletResponse)response;
        try {
            realRequest = AuthenticationUtil.resumeRequest((HttpServletRequest)realRequest);
            String requestUri = realRequest.getRequestURI();
            String contextPath = realRequest.getContextPath();
            String uri = requestUri.replace(contextPath, "");
            if (uri == null || uri.length() == 0) {
                String locationWithTrailingSlash = realRequest.getRequestURI() + "/";
                realResponse.reset();
                realResponse.sendRedirect(locationWithTrailingSlash);
            } else if (DSpaceServicesFactory.getInstance().getConfigurationService().getBooleanProperty("xmlui.force.ssl") && AuthenticationUtil.isLoggedIn((HttpServletRequest)realRequest) && !realRequest.isSecure()) {
                StringBuffer location = new StringBuffer("https://");
                location.append(DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("dspace.hostname")).append(realRequest.getRequestURI()).append(realRequest.getQueryString() == null ? "" : "?" + realRequest.getQueryString());
                realResponse.sendRedirect(location.toString());
            } else {
                arg2.doFilter((ServletRequest)realRequest, (ServletResponse)realResponse);
            }
        }
        catch (IOException e) {
            ContextUtil.abortContext((HttpServletRequest)realRequest);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"The connection was reset", (Throwable)e);
            } else {
                LOG.error((Object)"Client closed the connection before file download was complete");
            }
        }
        catch (RuntimeException e) {
            ContextUtil.abortContext((HttpServletRequest)realRequest);
            LOG.error((Object)"Serious Runtime Error Occurred Processing Request!", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            ContextUtil.abortContext((HttpServletRequest)realRequest);
            LOG.error((Object)"Serious Error Occurred Processing Request!", (Throwable)e);
        }
        finally {
            ContextUtil.completeContext((HttpServletRequest)realRequest);
        }
    }

    public void destroy() {
    }
}

