/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.objectmanager;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dspace.app.util.Util;
import org.dspace.app.xmlui.wing.AttributeMap;
import org.dspace.app.xmlui.wing.Namespace;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Item;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.DisseminationCrosswalk;
import org.dspace.core.Context;
import org.dspace.core.factory.CoreServiceFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

public abstract class AbstractAdapter {
    public static final String METS_URI = "http://www.loc.gov/METS/";
    public static final Namespace METS = new Namespace("http://www.loc.gov/METS/");
    public static final String XLINK_URI = "http://www.w3.org/TR/xlink/";
    public static final Namespace XLINK = new Namespace("http://www.w3.org/TR/xlink/");
    public static final String XSI_URI = "http://www.w3.org/2001/XMLSchema-instance";
    public static final Namespace XSI = new Namespace("http://www.w3.org/2001/XMLSchema-instance");
    public static final String DIM_URI = "http://www.dspace.org/xmlns/dspace/dim";
    public static final Namespace DIM = new Namespace("http://www.dspace.org/xmlns/dspace/dim");
    private int idSequence = 0;
    protected String contextPath;
    protected ContentHandler contentHandler;
    protected LexicalHandler lexicalHandler;
    protected NamespaceSupport namespaces;
    List<String> sections = new ArrayList();
    List<String> dmdTypes = new ArrayList();
    Map<String, List> amdTypes = new HashMap();
    List<String> fileGrpTypes = new ArrayList();
    List<String> structTypes = new ArrayList();
    public static final String[] METS_DEFINED_TYPES = new String[]{"MARC", "MODS", "EAD", "DC", "NISOIMG", "LC-AV", "VRA", "TEIHDR", "DDI", "FGDC", "PREMIS"};

    public AbstractAdapter(String contextPath) {
        this.contextPath = contextPath;
    }

    public final void setSections(String sections) {
        if (sections == null) {
            return;
        }
        for (String section : sections.split(",")) {
            this.sections.add(section);
        }
    }

    public final void setDmdTypes(String dmdTypes) {
        if (dmdTypes == null) {
            return;
        }
        for (String dmdType : dmdTypes.split(",")) {
            this.dmdTypes.add(dmdType);
        }
    }

    public final void setAmdTypes(String amdSec, String mdTypes) {
        if (mdTypes == null) {
            return;
        }
        ArrayList<String> mdTypeList = new ArrayList<String>();
        for (String mdType : mdTypes.split(",")) {
            mdTypeList.add(mdType);
        }
        this.amdTypes.put(amdSec, mdTypeList);
    }

    public final void setTechMDTypes(String techMDTypes) {
        this.setAmdTypes("techMD", techMDTypes);
    }

    public final void setRightsMDTypes(String rightsMDTypes) {
        this.setAmdTypes("rightsMD", rightsMDTypes);
    }

    public final void setSourceMDTypes(String sourceMDTypes) {
        this.setAmdTypes("sourceMD", sourceMDTypes);
    }

    public final void setDigiProvMDTypes(String digiprovMDTypes) {
        this.setAmdTypes("digiprovMD", digiprovMDTypes);
    }

    public final void setFileGrpTypes(String fileGrpTypes) {
        if (fileGrpTypes == null) {
            return;
        }
        for (String fileGrpType : fileGrpTypes.split(",")) {
            this.fileGrpTypes.add(fileGrpType);
        }
    }

    public final void setStructTypes(String structTypes) {
        if (structTypes == null) {
            return;
        }
        for (String structType : structTypes.split(",")) {
            this.structTypes.add(structType);
        }
    }

    protected abstract String getMETSOBJID() throws WingException;

    protected abstract String getMETSOBJEDIT();

    protected abstract String getMETSID() throws WingException;

    protected abstract String getMETSProfile() throws WingException;

    protected abstract String getMETSLabel() throws WingException;

    public final void renderMETS(Context context, ContentHandler contentHandler, LexicalHandler lexicalHandler) throws WingException, SAXException, CrosswalkException, IOException, SQLException {
        this.contentHandler = contentHandler;
        this.lexicalHandler = lexicalHandler;
        this.namespaces = new NamespaceSupport();
        this.namespaces.pushContext();
        this.namespaces.declarePrefix("mets", AbstractAdapter.METS.URI);
        this.namespaces.declarePrefix("xlink", AbstractAdapter.XLINK.URI);
        this.namespaces.declarePrefix("xsi", AbstractAdapter.XSI.URI);
        this.namespaces.declarePrefix("dim", AbstractAdapter.DIM.URI);
        contentHandler.startPrefixMapping("mets", AbstractAdapter.METS.URI);
        contentHandler.startPrefixMapping("xlink", AbstractAdapter.XLINK.URI);
        contentHandler.startPrefixMapping("xsi", AbstractAdapter.XSI.URI);
        contentHandler.startPrefixMapping("dim", AbstractAdapter.DIM.URI);
        AttributeMap attributes = new AttributeMap();
        attributes.put((Object)"ID", (Object)this.getMETSID());
        attributes.put((Object)"PROFILE", (Object)this.getMETSProfile());
        attributes.put((Object)"LABEL", (Object)this.getMETSLabel());
        String objid = this.getMETSOBJID();
        if (objid != null) {
            attributes.put((Object)"OBJID", (Object)objid);
        }
        if ((objid = this.getMETSOBJEDIT()) != null) {
            attributes.put((Object)"OBJEDIT", (Object)objid);
        }
        this.startElement(METS, "METS", new AttributeMap[]{attributes});
        boolean all = this.sections.isEmpty();
        if (all || this.sections.contains("metsHdr")) {
            this.renderHeader();
        }
        if (all || this.sections.contains("dmdSec")) {
            this.renderDescriptiveSection();
        }
        if (all || this.sections.contains("amdSec")) {
            this.renderAdministrativeSection();
        }
        if (all || this.sections.contains("fileSec")) {
            this.renderFileSection(context);
        }
        if (all || this.sections.contains("structMap")) {
            this.renderStructureMap();
        }
        if (all || this.sections.contains("structLink")) {
            this.renderStructuralLink();
        }
        if (all || this.sections.contains("behaviorSec")) {
            this.renderBehavioralSection();
        }
        if (all || this.sections.contains("extraSec")) {
            this.renderExtraSections();
        }
        this.endElement(METS, "METS");
        contentHandler.endPrefixMapping("mets");
        contentHandler.endPrefixMapping("xlink");
        contentHandler.endPrefixMapping("dim");
        this.namespaces.popContext();
    }

    protected void renderHeader() throws WingException, SAXException, CrosswalkException, IOException, SQLException {
    }

    protected void renderDescriptiveSection() throws WingException, SAXException, CrosswalkException, IOException, SQLException {
    }

    protected void renderAdministrativeSection() throws WingException, SAXException, CrosswalkException, IOException, SQLException {
    }

    protected void renderFileSection(Context context) throws WingException, SAXException, CrosswalkException, IOException, SQLException {
    }

    protected void renderStructureMap() throws WingException, SAXException, CrosswalkException, IOException, SQLException {
    }

    protected void renderStructuralLink() throws WingException, SAXException, CrosswalkException, IOException, SQLException {
    }

    protected void renderBehavioralSection() throws WingException, SAXException, CrosswalkException, IOException, SQLException {
    }

    protected void renderExtraSections() throws WingException, SAXException, CrosswalkException, SQLException, IOException {
    }

    protected final void renderFile(Context context, Item item, Bitstream bitstream, String fileID, String groupID) throws SAXException, SQLException {
        this.renderFile(context, item, bitstream, fileID, groupID, null);
    }

    protected final void renderFile(Context context, Item item, Bitstream bitstream, String fileID, String groupID, String admID) throws SAXException, SQLException {
        BitstreamFormat format = bitstream.getFormat(context);
        String mimeType = null;
        if (format != null) {
            mimeType = format.getMIMEType();
        }
        String checksumType = bitstream.getChecksumAlgorithm();
        String checksum = bitstream.getChecksum();
        long size = bitstream.getSize();
        AttributeMap attributes = new AttributeMap();
        attributes.put((Object)"ID", (Object)fileID);
        attributes.put((Object)"GROUPID", (Object)groupID);
        if (admID != null && admID.length() > 0) {
            attributes.put((Object)"ADMID", (Object)admID);
        }
        if (mimeType != null && mimeType.length() > 0) {
            attributes.put((Object)"MIMETYPE", (Object)mimeType);
        }
        if (checksumType != null && checksum != null) {
            attributes.put((Object)"CHECKSUM", (Object)checksum);
            attributes.put((Object)"CHECKSUMTYPE", (Object)checksumType);
        }
        attributes.put((Object)"SIZE", (Object)String.valueOf(size));
        this.startElement(METS, "file", new AttributeMap[]{attributes});
        String name = bitstream.getName();
        String description = bitstream.getDescription();
        String identifier = null;
        identifier = item != null && item.getHandle() != null ? "handle/" + item.getHandle() : (item != null ? "item/" + item.getID() : "id/" + bitstream.getID());
        String url = this.contextPath + "/bitstream/" + identifier + "/";
        try {
            if (bitstream.getName() != null) {
                url = url + Util.encodeBitstreamName((String)bitstream.getName(), (String)"UTF-8");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        url = url + "?sequence=" + bitstream.getSequenceID();
        attributes = new AttributeMap();
        AttributeMap attributesXLINK = new AttributeMap();
        attributesXLINK.setNamespace(XLINK);
        attributes.put((Object)"LOCTYPE", (Object)"URL");
        attributesXLINK.put((Object)"type", (Object)"locator");
        attributesXLINK.put((Object)"title", (Object)name);
        if (description != null) {
            attributesXLINK.put((Object)"label", (Object)description);
        }
        attributesXLINK.put((Object)"href", (Object)url);
        this.startElement(METS, "FLocat", new AttributeMap[]{attributes, attributesXLINK});
        this.endElement(METS, "FLocate");
        this.endElement(METS, "file");
    }

    protected final String getGenericID(String prefix) {
        return prefix + this.idSequence++;
    }

    public final DisseminationCrosswalk getDisseminationCrosswalk(String crosswalkName) throws WingException {
        DisseminationCrosswalk crosswalk = (DisseminationCrosswalk)CoreServiceFactory.getInstance().getPluginService().getNamedPlugin(DisseminationCrosswalk.class, crosswalkName);
        if (crosswalk == null) {
            throw new WingException("Unable to find named DisseminationCrosswalk: " + crosswalkName);
        }
        return crosswalk;
    }

    public final boolean isDefinedMETStype(String metadataType) {
        for (String definedType : METS_DEFINED_TYPES) {
            if (!definedType.equals(metadataType)) continue;
            return true;
        }
        return false;
    }

    protected final void startElement(Namespace namespace, String name, AttributeMap ... attributes) throws SAXException {
        this.contentHandler.startElement(namespace.URI, name, this.qName(namespace, name), this.map2sax(namespace, attributes));
    }

    protected final void sendCharacters(String characters) throws SAXException {
        if (characters != null) {
            char[] contentArray = characters.toCharArray();
            this.contentHandler.characters(contentArray, 0, contentArray.length);
        }
    }

    protected final void endElement(Namespace namespace, String name) throws SAXException {
        this.contentHandler.endElement(namespace.URI, name, this.qName(namespace, name));
    }

    private AttributesImpl map2sax(Namespace elementNamespace, AttributeMap ... attributeMaps) {
        AttributesImpl attributes = new AttributesImpl();
        for (AttributeMap attributeMap : attributeMaps) {
            boolean differentNamespaces = false;
            Namespace attributeNamespace = attributeMap.getNamespace();
            if (attributeNamespace != null && !attributeNamespace.URI.equals(elementNamespace.URI)) {
                differentNamespaces = true;
            }
            for (Map.Entry attr : attributeMap.entrySet()) {
                if (attr.getValue() == null) continue;
                if (differentNamespaces) {
                    attributes.addAttribute(attributeNamespace.URI, (String)attr.getKey(), this.qName(attributeNamespace, (String)attr.getKey()), "CDATA", (String)attr.getValue());
                    continue;
                }
                attributes.addAttribute("", (String)attr.getKey(), (String)attr.getKey(), "CDATA", (String)attr.getValue());
            }
        }
        return attributes;
    }

    private String qName(Namespace namespace, String localName) {
        String prefix = this.namespaces.getPrefix(namespace.URI);
        if (prefix == null || prefix.equals("")) {
            return localName;
        }
        return prefix + ":" + localName;
    }
}

