/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.wing.element;

import org.dspace.app.xmlui.wing.WingConstants;
import org.dspace.app.xmlui.wing.WingContext;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.AbstractWingElement;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.RepositoryMeta;
import org.dspace.app.xmlui.wing.element.UserMeta;
import org.dspace.app.xmlui.wing.element.WingMergeableElement;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class Meta
extends AbstractWingElement
implements WingMergeableElement {
    public static final String E_META = "meta";
    private boolean merged = false;
    private UserMeta userMeta;
    private PageMeta pageMeta;
    private RepositoryMeta repositoryMeta;

    protected Meta(WingContext context) throws WingException {
        super(context);
        this.userMeta = new UserMeta(context);
        this.pageMeta = new PageMeta(context);
        this.repositoryMeta = new RepositoryMeta(context);
    }

    public UserMeta setUserMeta() throws WingException {
        return this.userMeta;
    }

    public PageMeta setPageMeta() throws WingException {
        return this.pageMeta;
    }

    public RepositoryMeta setRepositoryMeta() throws WingException {
        return this.repositoryMeta;
    }

    public boolean mergeEqual(String namespace, String localName, String qName, Attributes attributes) throws SAXException, WingException {
        if (!WingConstants.DRI.URI.equals(namespace)) {
            return false;
        }
        return E_META.equals(localName);
    }

    public WingMergeableElement mergeChild(String namespace, String localName, String qName, Attributes attributes) throws SAXException, WingException {
        if (this.userMeta != null && this.userMeta.mergeEqual(namespace, localName, qName, attributes)) {
            UserMeta thisUserMeta = this.userMeta;
            this.userMeta = null;
            return thisUserMeta;
        }
        if (this.pageMeta != null && this.pageMeta.mergeEqual(namespace, localName, qName, attributes)) {
            PageMeta thisPageMeta = this.pageMeta;
            this.pageMeta = null;
            return thisPageMeta;
        }
        if (this.repositoryMeta != null && this.repositoryMeta.mergeEqual(namespace, localName, qName, attributes)) {
            RepositoryMeta thisRepositoryMeta = this.repositoryMeta;
            this.repositoryMeta = null;
            return thisRepositoryMeta;
        }
        return null;
    }

    public Attributes merge(Attributes attributes) throws SAXException, WingException {
        this.merged = true;
        return attributes;
    }

    public void toSAX(ContentHandler contentHandler, LexicalHandler lexicalHandler, NamespaceSupport namespaces) throws SAXException {
        if (!this.merged) {
            this.startElement(contentHandler, namespaces, E_META, null);
        }
        if (this.userMeta != null) {
            this.userMeta.toSAX(contentHandler, lexicalHandler, namespaces);
        }
        if (this.pageMeta != null) {
            this.pageMeta.toSAX(contentHandler, lexicalHandler, namespaces);
        }
        if (this.repositoryMeta != null) {
            this.repositoryMeta.toSAX(contentHandler, lexicalHandler, namespaces);
        }
        if (!this.merged) {
            this.endElement(contentHandler, namespaces, E_META);
        }
    }

    public void dispose() {
        if (this.userMeta != null) {
            this.userMeta.dispose();
        }
        if (this.pageMeta != null) {
            this.pageMeta.dispose();
        }
        if (this.repositoryMeta != null) {
            this.repositoryMeta.dispose();
        }
        this.userMeta = null;
        this.pageMeta = null;
        this.repositoryMeta = null;
        super.dispose();
    }
}

