/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative.item;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.dspace.app.xmlui.aspect.administrative.item.ConfirmItemForm;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Button;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;

public class ConfirmItemForm
extends AbstractDSpaceTransformer {
    private static final Message T_dspace_home = ConfirmItemForm.message((String)"xmlui.general.dspace_home");
    private static final Message T_item_trail = ConfirmItemForm.message((String)"xmlui.administrative.item.general.item_trail");
    private static final Message T_submit_cancel = ConfirmItemForm.message((String)"xmlui.general.cancel");
    private static final Message T_title = ConfirmItemForm.message((String)"xmlui.administrative.item.ConfirmItemForm.title");
    private static final Message T_trail = ConfirmItemForm.message((String)"xmlui.administrative.item.ConfirmItemForm.trail");
    private static final Message T_head1 = ConfirmItemForm.message((String)"xmlui.administrative.item.ConfirmItemForm.head1");
    private static final Message T_para_delete = ConfirmItemForm.message((String)"xmlui.administrative.item.ConfirmItemForm.para_delete");
    private static final Message T_para_withdraw = ConfirmItemForm.message((String)"xmlui.administrative.item.ConfirmItemForm.para_withdraw");
    private static final Message T_para_reinstate = ConfirmItemForm.message((String)"xmlui.administrative.item.ConfirmItemForm.para_reinstate");
    private static final Message T_column1 = ConfirmItemForm.message((String)"xmlui.administrative.item.ConfirmItemForm.column1");
    private static final Message T_column2 = ConfirmItemForm.message((String)"xmlui.administrative.item.ConfirmItemForm.column2");
    private static final Message T_column3 = ConfirmItemForm.message((String)"xmlui.administrative.item.ConfirmItemForm.column3");
    private static final Message T_submit_delete = ConfirmItemForm.message((String)"xmlui.general.delete");
    private static final Message T_submit_withdraw = ConfirmItemForm.message((String)"xmlui.administrative.item.ConfirmItemForm.submit_withdraw");
    private static final Message T_submit_reinstate = ConfirmItemForm.message((String)"xmlui.administrative.item.ConfirmItemForm.submit_reinstate");
    private static final Message T_submit_private = ConfirmItemForm.message((String)"xmlui.administrative.item.ConfirmItemForm.submit_private");
    private static final Message T_submit_public = ConfirmItemForm.message((String)"xmlui.administrative.item.ConfirmItemForm.submit_public");
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();

    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrailLink(this.contextPath + "/admin/item", T_item_trail);
        pageMeta.addTrail().addContent(T_trail);
    }

    public void addBody(Body body) throws WingException, SQLException {
        UUID itemID = UUID.fromString(this.parameters.getParameter("itemID", null));
        Item item = (Item)this.itemService.find(this.context, itemID);
        List values = this.itemService.getMetadata((DSpaceObject)item, "*", "*", "*", "*");
        Collections.sort(values, new DCValueComparator());
        String confirm = this.parameters.getParameter("confirm", null);
        Division main = body.addInteractiveDivision("confirm-item", this.contextPath + "/admin/item", "post", "primary administrative item");
        main.setHead(T_head1.parameterize(new Object[]{item.getHandle()}));
        if ("delete".equals(confirm)) {
            main.addPara(T_para_delete);
        } else if ("reinstate".equals(confirm)) {
            main.addPara(T_para_reinstate);
        } else if ("withdraw".equals(confirm)) {
            main.addPara(T_para_withdraw);
        }
        Table table = main.addTable("withdrawValues", values.size() + 1, 3);
        Row header = table.addRow("header");
        header.addCell().addContent(T_column1);
        header.addCell().addContent(T_column2);
        header.addCell().addContent(T_column3);
        for (MetadataValue value : values) {
            MetadataField metadataField = value.getMetadataField();
            String dcValue = metadataField.getMetadataSchema().getName() + ". " + metadataField.getElement() + (metadataField.getQualifier() == null ? "" : ". " + metadataField.getQualifier());
            Row row = table.addRow();
            row.addCell().addContent(dcValue);
            row.addCell().addContent(value.getValue());
            row.addCell().addContent(value.getLanguage());
        }
        org.dspace.app.xmlui.wing.element.Item actions = main.addList("actions", "form").addItem();
        Button confirmButton = actions.addButton("submit_confirm");
        if ("delete".equals(confirm)) {
            confirmButton.setValue(T_submit_delete);
        } else if ("reinstate".equals(confirm)) {
            confirmButton.setValue(T_submit_reinstate);
        } else if ("private".equals(confirm)) {
            confirmButton.setValue(T_submit_private);
        } else if ("public".equals(confirm)) {
            confirmButton.setValue(T_submit_public);
        } else if ("withdraw".equals(confirm)) {
            confirmButton.setValue(T_submit_withdraw);
        }
        actions.addButton("submit_cancel").setValue(T_submit_cancel);
        main.addHidden("administrative-continue").setValue(this.knot.getId());
    }
}

