/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import javax.mail.MessagingException;
import javax.servlet.http.HttpServletRequest;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang.StringUtils;
import org.dspace.app.xmlui.aspect.administrative.FlowResult;
import org.dspace.app.xmlui.utils.AuthenticationUtil;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.EPersonDeletionException;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.AccountService;
import org.dspace.eperson.service.EPersonService;

public class FlowEPersonUtils {
    private static final Message T_add_eperson_success_notice = new Message("default", "xmlui.administrative.FlowEPersonUtils.add_eperson_success_notice");
    private static final Message T_edit_eperson_success_notice = new Message("default", "xmlui.administrative.FlowEPersonUtils.edit_eperson_success_notice");
    private static final Message T_reset_password_success_notice = new Message("default", "xmlui.administrative.FlowEPersonUtils.reset_password_success_notice");
    private static final Message t_delete_eperson_success_notice = new Message("default", "xmlui.administrative.FlowEPersonUtils.delete_eperson_success_notice");
    private static final Message t_delete_eperson_failed_notice = new Message("default", "xmlui.administrative.FlowEPersonUtils.delete_eperson_failed_notice");
    protected static final AccountService accountService = EPersonServiceFactory.getInstance().getAccountService();
    protected static final EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();

    public static FlowResult processAddEPerson(Context context, Request request, Map objectModel) throws SQLException, AuthorizeException {
        EPerson potentialDupicate;
        boolean certificate;
        FlowResult result = new FlowResult();
        result.setContinue(false);
        String email = request.getParameter("email_address").trim();
        String first = request.getParameter("first_name").trim();
        String last = request.getParameter("last_name").trim();
        String phone = request.getParameter("phone").trim();
        boolean login = request.getParameter("can_log_in") != null;
        boolean bl = certificate = request.getParameter("certificate") != null;
        if (StringUtils.isEmpty((String)email)) {
            result.addError("email_address");
        }
        if (StringUtils.isEmpty((String)first)) {
            result.addError("first_name");
        }
        if (StringUtils.isEmpty((String)last)) {
            result.addError("last_name");
        }
        if ((potentialDupicate = ePersonService.findByEmail(context, email)) != null) {
            result.addError("eperson_email_key");
        }
        if (result.getErrors() == null) {
            EPerson newPerson = AuthenticationUtil.createNewEperson((Map)objectModel, (String)email);
            newPerson.setFirstName(context, first);
            newPerson.setLastName(context, last);
            ePersonService.setMetadata(context, newPerson, "phone", phone);
            newPerson.setCanLogIn(login);
            newPerson.setRequireCertificate(certificate);
            newPerson.setSelfRegistered(false);
            ePersonService.update(context, (DSpaceObject)newPerson);
            result.setContinue(true);
            result.setOutcome(true);
            result.setMessage(T_add_eperson_success_notice);
            result.setParameter("epersonID", (Object)newPerson.getID());
        }
        return result;
    }

    public static FlowResult processEditEPerson(Context context, Request request, Map ObjectModel, UUID epersonID) throws SQLException, AuthorizeException {
        boolean certificate;
        FlowResult result = new FlowResult();
        result.setContinue(false);
        String email = request.getParameter("email_address");
        String first = request.getParameter("first_name");
        String last = request.getParameter("last_name");
        String phone = request.getParameter("phone");
        boolean login = request.getParameter("can_log_in") != null;
        boolean bl = certificate = request.getParameter("certificate") != null;
        if (StringUtils.isEmpty((String)email)) {
            result.addError("email_address");
        }
        if (StringUtils.isEmpty((String)first)) {
            result.addError("first_name");
        }
        if (StringUtils.isEmpty((String)last)) {
            result.addError("last_name");
        }
        if (result.getErrors() == null) {
            String originalPhone;
            String originalLastName;
            String originalFirstName;
            EPerson personModified = (EPerson)ePersonService.find(context, epersonID);
            String originalEmail = personModified.getEmail();
            if (originalEmail == null || !originalEmail.equals(email)) {
                EPerson potentialDupicate = ePersonService.findByEmail(context, email);
                if (potentialDupicate == null) {
                    personModified.setEmail(email);
                } else {
                    result.addError("eperson_email_key");
                    return result;
                }
            }
            if ((originalFirstName = personModified.getFirstName()) == null || !originalFirstName.equals(first)) {
                personModified.setFirstName(context, first);
            }
            if ((originalLastName = personModified.getLastName()) == null || !originalLastName.equals(last)) {
                personModified.setLastName(context, last);
            }
            if ((originalPhone = ePersonService.getMetadata((DSpaceObject)personModified, "phone")) == null || !originalPhone.equals(phone)) {
                ePersonService.setMetadata(context, personModified, "phone", phone);
            }
            personModified.setCanLogIn(login);
            personModified.setRequireCertificate(certificate);
            ePersonService.update(context, (DSpaceObject)personModified);
            result.setContinue(true);
            result.setOutcome(true);
            result.setMessage(T_edit_eperson_success_notice);
        }
        return result;
    }

    public static FlowResult processResetPassword(Context context, UUID epersonID) throws IOException, MessagingException, SQLException, AuthorizeException {
        EPerson eperson = (EPerson)ePersonService.find(context, epersonID);
        accountService.sendForgotPasswordInfo(context, eperson.getEmail());
        FlowResult result = new FlowResult();
        result.setContinue(true);
        result.setOutcome(true);
        result.setMessage(T_reset_password_success_notice);
        return result;
    }

    public static FlowResult processLoginAs(Context context, Map objectModel, UUID epersonID) throws SQLException {
        FlowResult result = new FlowResult();
        result.setContinue(true);
        result.setOutcome(true);
        HttpServletRequest request = (HttpServletRequest)objectModel.get("httprequest");
        EPerson eperson = (EPerson)ePersonService.find(context, epersonID);
        try {
            AuthenticationUtil.loginAs((Context)context, (HttpServletRequest)request, (EPerson)eperson);
        }
        catch (AuthorizeException ae) {
            result.setOutcome(false);
            result.setMessage(new Message(null, ae.getMessage()));
        }
        return result;
    }

    public static FlowResult processDeleteEPeople(Context context, String[] epeopleIDs) throws NumberFormatException, SQLException, AuthorizeException, EPersonDeletionException, IOException {
        FlowResult result = new FlowResult();
        ArrayList unableList = new ArrayList();
        for (String id : epeopleIDs) {
            EPerson personDeleted = (EPerson)ePersonService.find(context, UUID.fromString(id));
            ePersonService.delete(context, (DSpaceObject)personDeleted);
        }
        if (unableList.size() > 0) {
            result.setOutcome(false);
            result.setMessage(t_delete_eperson_failed_notice);
            String characters = null;
            for (String unable : unableList) {
                if (characters == null) {
                    characters = unable;
                    continue;
                }
                characters = characters + ", " + unable;
            }
            result.setCharacters(characters);
        } else {
            result.setOutcome(true);
            result.setMessage(t_delete_eperson_success_notice);
        }
        return result;
    }
}

