/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative.controlpanel;

import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.dspace.app.xmlui.aspect.administrative.CurrentActivityAction;
import org.dspace.app.xmlui.aspect.administrative.controlpanel.AbstractControlPanelTab;
import org.dspace.app.xmlui.aspect.administrative.controlpanel.ControlPanelCurrentActivityTab;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;

public class ControlPanelCurrentActivityTab
extends AbstractControlPanelTab {
    private static final Message T_activity_head = ControlPanelCurrentActivityTab.message((String)"xmlui.administrative.ControlPanel.activity_head");
    private static final Message T_stop_anonymous = ControlPanelCurrentActivityTab.message((String)"xmlui.administrative.ControlPanel.stop_anonymous");
    private static final Message T_start_anonymous = ControlPanelCurrentActivityTab.message((String)"xmlui.administrative.ControlPanel.start_anonymous");
    private static final Message T_stop_bot = ControlPanelCurrentActivityTab.message((String)"xmlui.administrative.ControlPanel.stop_bot");
    private static final Message T_start_bot = ControlPanelCurrentActivityTab.message((String)"xmlui.administrative.ControlPanel.start_bot");
    private static final Message T_activity_sort_time = ControlPanelCurrentActivityTab.message((String)"xmlui.administrative.ControlPanel.activity_sort_time");
    private static final Message T_activity_sort_user = ControlPanelCurrentActivityTab.message((String)"xmlui.administrative.ControlPanel.activity_sort_user");
    private static final Message T_activity_sort_ip = ControlPanelCurrentActivityTab.message((String)"xmlui.administrative.ControlPanel.activity_sort_ip");
    private static final Message T_activity_sort_url = ControlPanelCurrentActivityTab.message((String)"xmlui.administrative.ControlPanel.activity_sort_url");
    private static final Message T_activity_sort_agent = ControlPanelCurrentActivityTab.message((String)"xmlui.administrative.ControlPanel.activity_sort_Agent");
    private static final Message T_activity_anonymous = ControlPanelCurrentActivityTab.message((String)"xmlui.administrative.ControlPanel.activity_anonymous");
    private static final Message T_activity_none = ControlPanelCurrentActivityTab.message((String)"xmlui.administrative.ControlPanel.activity_none");
    private static final Message T_seconds = ControlPanelCurrentActivityTab.message((String)"xmlui.administrative.ControlPanel.seconds");
    private static final Message T_hours = ControlPanelCurrentActivityTab.message((String)"xmlui.administrative.ControlPanel.hours");
    private static final Message T_minutes = ControlPanelCurrentActivityTab.message((String)"xmlui.administrative.ControlPanel.minutes");
    private static final Message T_detail = ControlPanelCurrentActivityTab.message((String)"xmlui.administrative.ControlPanel.detail");
    private static final Message T_show_hide = ControlPanelCurrentActivityTab.message((String)"xmlui.administrative.ControlPanel.show_hide");
    private static final Message T_host = ControlPanelCurrentActivityTab.message((String)"xmlui.administrative.ControlPanel.host");
    private static final Message T_puser = ControlPanelCurrentActivityTab.message((String)"xmlui.administrative.ControlPanel.puser");
    private static final Message T_headers = ControlPanelCurrentActivityTab.message((String)"xmlui.administrative.ControlPanel.headers");
    private static final Message T_cookies = ControlPanelCurrentActivityTab.message((String)"xmlui.administrative.ControlPanel.cookies");
    protected EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();

    public void addBody(Map objectModel, Division div) throws WingException, SQLException {
        String recordBotString;
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String recordAnonymousString = request.getParameter("recordanonymous");
        if (recordAnonymousString != null) {
            if ("ON".equals(recordAnonymousString)) {
                CurrentActivityAction.setRecordAnonymousEvents((boolean)true);
            }
            if ("OFF".equals(recordAnonymousString)) {
                CurrentActivityAction.setRecordAnonymousEvents((boolean)false);
            }
        }
        if ((recordBotString = request.getParameter("recordbots")) != null) {
            if ("ON".equals(recordBotString)) {
                CurrentActivityAction.setRecordBotEvents((boolean)true);
            }
            if ("OFF".equals(recordBotString)) {
                CurrentActivityAction.setRecordBotEvents((boolean)false);
            }
        }
        EventSort sortBy = EventSort.TIME;
        String sortByString = request.getParameter("sortBy");
        if (EventSort.TIME.toString().equals(sortByString)) {
            sortBy = EventSort.TIME;
        }
        if (EventSort.URL.toString().equals(sortByString)) {
            sortBy = EventSort.URL;
        }
        if (EventSort.SESSION.toString().equals(sortByString)) {
            sortBy = EventSort.SESSION;
        }
        if (EventSort.AGENT.toString().equals(sortByString)) {
            sortBy = EventSort.AGENT;
        }
        if (EventSort.IP.toString().equals(sortByString)) {
            sortBy = EventSort.IP;
        }
        List events = CurrentActivityAction.getEvents();
        Collections.sort(events, new ActivitySort(sortBy));
        Collections.reverse(events);
        div = div.addDivision("activitydiv", "well well-light");
        if (CurrentActivityAction.getRecordAnonymousEvents()) {
            div.addPara().addXref(this.web_link + "&sortBy=" + sortBy + "&recordanonymous=OFF").addContent(T_stop_anonymous);
        } else {
            div.addPara().addXref(this.web_link + "&sortBy=" + sortBy + "&recordanonymous=ON").addContent(T_start_anonymous);
        }
        if (CurrentActivityAction.getRecordBotEvents()) {
            div.addPara().addXref(this.web_link + "&sortBy=" + sortBy + "&recordbots=OFF").addContent(T_stop_bot);
        } else {
            div.addPara().addXref(this.web_link + "&sortBy=" + sortBy + "&recordbots=ON").addContent(T_start_bot);
        }
        Table activeUsers = div.addTable("users", 1, 1);
        activeUsers.setHead(T_activity_head.parameterize(new Object[]{CurrentActivityAction.MAX_EVENTS}));
        Row row = activeUsers.addRow(null, "header", "font_smaller");
        if (sortBy == EventSort.TIME) {
            row.addCell().addHighlight("bold").addXref(this.web_link + "&sortBy=" + EventSort.TIME).addContent(T_activity_sort_time);
        } else {
            row.addCell().addXref(this.web_link + "&sortBy=" + EventSort.TIME).addContent(T_activity_sort_time);
        }
        if (sortBy == EventSort.SESSION) {
            row.addCell().addHighlight("bold").addXref(this.web_link + "&sortBy=" + EventSort.SESSION).addContent(T_activity_sort_user);
        } else {
            row.addCell().addXref(this.web_link + "&sortBy=" + EventSort.SESSION).addContent(T_activity_sort_user);
        }
        if (sortBy == EventSort.IP) {
            row.addCell().addHighlight("bold").addXref(this.web_link + "&sortBy=" + EventSort.IP).addContent(T_activity_sort_ip);
        } else {
            row.addCell().addXref(this.web_link + "&sortBy=" + EventSort.IP).addContent(T_activity_sort_ip);
        }
        if (sortBy == EventSort.URL) {
            row.addCell().addHighlight("bold").addXref(this.web_link + "&sortBy=" + EventSort.URL).addContent(T_activity_sort_url);
        } else {
            row.addCell().addXref(this.web_link + "&sortBy=" + EventSort.URL).addContent(T_activity_sort_url);
        }
        if (sortBy == EventSort.AGENT) {
            row.addCell().addHighlight("bold").addXref(this.web_link + "&sortBy=" + EventSort.AGENT).addContent(T_activity_sort_agent);
        } else {
            row.addCell().addXref(this.web_link + "&sortBy=" + EventSort.AGENT).addContent(T_activity_sort_agent);
        }
        row.addCellContent(T_detail);
        HashMap<String, Integer> anonymousHash = new HashMap<String, Integer>();
        int anonymousCount = 1;
        int shown = 0;
        for (CurrentActivityAction.Event event : events) {
            if (event == null) continue;
            ++shown;
            Message timeStampMessage = null;
            long ago = System.currentTimeMillis() - event.getTimeStamp();
            timeStampMessage = ago > 0x6DDD00L ? T_hours.parameterize(new Object[]{ago / 3600000L}) : (ago > 60000L ? T_minutes.parameterize(new Object[]{ago / 60000L}) : T_seconds.parameterize(new Object[]{ago / 1000L}));
            Row eventRow = activeUsers.addRow(null, "data", "font_smaller");
            eventRow.addCellContent(timeStampMessage);
            UUID eid = event.getEPersonID();
            EPerson eperson = (EPerson)this.ePersonService.find(this.context, eid);
            if (eperson != null) {
                String name = eperson.getFullName();
                eventRow.addCellContent(name);
            } else {
                if (!anonymousHash.containsKey(event.getSessionID())) {
                    anonymousHash.put(event.getSessionID(), anonymousCount++);
                }
                eventRow.addCellContent(T_activity_anonymous.parameterize(new Object[]{anonymousHash.get(event.getSessionID())}));
            }
            eventRow.addCellContent(event.getIP());
            eventRow.addCell().addXref(this.contextPath + "/" + event.getURL()).addContent("/" + event.getURL());
            eventRow.addCellContent(event.getDectectedBrowser());
            eventRow.addCell(null, null, "toggle-onclick-parent-next4 bold btn-link").addContent(T_show_hide);
            String not_present = "not present";
            String host = event.host != null ? event.host : "not present";
            activeUsers.addRow(null, null, "hidden font_smaller").addCell(1, 6).addContent(T_host.parameterize(new Object[]{host}));
            String puser = event.puser != null ? event.puser : "not present";
            activeUsers.addRow(null, null, "hidden font_smaller").addCell(1, 6).addContent(T_puser.parameterize(new Object[]{puser}));
            String headers = "";
            for (Map.Entry o : event.headers.entrySet()) {
                headers = headers + (String)o.getKey() + ":[" + (String)o.getValue() + "];";
            }
            headers = headers != "" ? headers : "not present";
            activeUsers.addRow(null, null, "hidden").addCell(1, 6).addContent(T_headers.parameterize(new Object[]{headers}));
            String cookies = "";
            for (Map.Entry o : event.cookieMap.entrySet()) {
                cookies = cookies + (String)o.getKey() + ":[" + (String)o.getValue() + "];";
            }
            cookies = cookies != "" ? cookies : "not present";
            activeUsers.addRow(null, null, "hidden font_smaller").addCell(1, 6).addContent(T_cookies.parameterize(new Object[]{cookies}));
        }
        if (shown == 0) {
            activeUsers.addRow().addCell(1, 5).addContent(T_activity_none);
        }
    }
}

