/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative.item;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.ArrayUtils;
import org.dspace.app.xmlui.aspect.submission.submit.AccessStepUtil;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Button;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.File;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Select;
import org.dspace.app.xmlui.wing.element.Text;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class AddBitstreamForm
extends AbstractDSpaceTransformer {
    private static final Message T_dspace_home = AddBitstreamForm.message((String)"xmlui.general.dspace_home");
    private static final Message T_submit_cancel = AddBitstreamForm.message((String)"xmlui.general.cancel");
    private static final Message T_item_trail = AddBitstreamForm.message((String)"xmlui.administrative.item.general.item_trail");
    private static final Message T_title = AddBitstreamForm.message((String)"xmlui.administrative.item.AddBitstreamForm.title");
    private static final Message T_trail = AddBitstreamForm.message((String)"xmlui.administrative.item.AddBitstreamForm.trail");
    private static final Message T_head1 = AddBitstreamForm.message((String)"xmlui.administrative.item.AddBitstreamForm.head1");
    private static final Message T_bundle_label = AddBitstreamForm.message((String)"xmlui.administrative.item.AddBitstreamForm.bundle_label");
    private static final Message T_file_label = AddBitstreamForm.message((String)"xmlui.administrative.item.AddBitstreamForm.file_label");
    private static final Message T_file_help = AddBitstreamForm.message((String)"xmlui.administrative.item.AddBitstreamForm.file_help");
    private static final Message T_description_label = AddBitstreamForm.message((String)"xmlui.administrative.item.AddBitstreamForm.description_label");
    private static final Message T_description_help = AddBitstreamForm.message((String)"xmlui.administrative.item.AddBitstreamForm.description_help");
    private static final Message T_submit_upload = AddBitstreamForm.message((String)"xmlui.administrative.item.AddBitstreamForm.submit_upload");
    private static final Message T_no_bundles = AddBitstreamForm.message((String)"xmlui.administrative.item.AddBitstreamForm.no_bundles");
    private static final String[] DEFAULT_BUNDLE_LIST = new String[]{"ORIGINAL", "METADATA", "THUMBNAIL", "LICENSE", "CC-LICENSE"};
    private boolean isAdvancedFormEnabled = true;
    protected AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();

    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrailLink(this.contextPath + "/admin/item", T_item_trail);
        pageMeta.addTrail().addContent(T_trail);
        pageMeta.addMetadata("javascript", "static").addContent("static/js/editItemUtil.js");
    }

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        this.isAdvancedFormEnabled = DSpaceServicesFactory.getInstance().getConfigurationService().getBooleanProperty("webui.submission.restrictstep.enableAdvancedForm", false);
        UUID itemID = UUID.fromString(this.parameters.getParameter("itemID", null));
        Item item = (Item)this.itemService.find(this.context, itemID);
        Division div = body.addInteractiveDivision("add-bitstream", this.contextPath + "/admin/item", "multipart", "primary administrative item");
        org.dspace.app.xmlui.wing.element.List upload = div.addList("submit-upload-new", "form");
        upload.setHead(T_head1);
        int bundleCount = 0;
        Select select = upload.addItem().addSelect("bundle");
        select.setLabel(T_bundle_label);
        Object[] bundles = DSpaceServicesFactory.getInstance().getConfigurationService().getArrayProperty("xmlui.bundle.upload");
        if (ArrayUtils.isEmpty((Object[])bundles)) {
            bundles = DEFAULT_BUNDLE_LIST;
        }
        for (Object part : bundles) {
            if (!this.addBundleOption(item, select, ((String)part).trim())) continue;
            ++bundleCount;
        }
        select.setOptionSelected("ORIGINAL");
        if (bundleCount == 0) {
            select.setDisabled();
        }
        File file = upload.addItem().addFile("file");
        file.setLabel(T_file_label);
        file.setHelp(T_file_help);
        file.setRequired();
        if (bundleCount == 0) {
            file.setDisabled();
        }
        Text description = upload.addItem().addText("description");
        description.setLabel(T_description_label);
        description.setHelp(T_description_help);
        if (bundleCount == 0) {
            description.setDisabled();
        }
        if (bundleCount == 0) {
            upload.addItem().addContent(T_no_bundles);
        }
        if (!this.isAdvancedFormEnabled) {
            AccessStepUtil asu = new AccessStepUtil(this.context);
            asu.addEmbargoDateSimpleForm((DSpaceObject)item, upload, -1);
            asu.addReason(null, upload, -1);
        }
        org.dspace.app.xmlui.wing.element.Item actions = upload.addItem();
        Button button = actions.addButton("submit_upload");
        button.setValue(T_submit_upload);
        if (bundleCount == 0) {
            button.setDisabled();
        }
        actions.addButton("submit_cancel").setValue(T_submit_cancel);
        div.addHidden("administrative-continue").setValue(this.knot.getId());
    }

    public boolean addBundleOption(Item item, Select select, String bundleName) throws SQLException, WingException {
        List bundles = this.itemService.getBundles(item, bundleName);
        if (bundles == null || bundles.size() == 0) {
            if (!this.authorizeService.authorizeActionBoolean(this.context, (DSpaceObject)item, 3)) {
                return false;
            }
        } else {
            Bundle bundle = (Bundle)bundles.get(0);
            if (!this.authorizeService.authorizeActionBoolean(this.context, (DSpaceObject)bundle, 3)) {
                return false;
            }
            if (!this.authorizeService.authorizeActionBoolean(this.context, (DSpaceObject)bundle, 1)) {
                return false;
            }
        }
        select.addOption(bundleName, AddBitstreamForm.message((String)("xmlui.administrative.item.AddBitstreamForm.bundle." + bundleName)));
        return true;
    }
}

