/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.submission.submit;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.SourceResolver;
import org.dspace.app.util.Util;
import org.dspace.app.xmlui.aspect.submission.submit.AccessStepUtil;
import org.dspace.app.xmlui.aspect.submission.submit.EditBitstreamPolicies;
import org.dspace.app.xmlui.aspect.submission.submit.EditFileStep;
import org.dspace.app.xmlui.aspect.submission.submit.EditPolicyStep;
import org.dspace.app.xmlui.aspect.submission.submit.ReviewStep;
import org.dspace.app.xmlui.aspect.submission.submit.UploadStep;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Button;
import org.dspace.app.xmlui.wing.element.Cell;
import org.dspace.app.xmlui.wing.element.CheckBox;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.File;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Radio;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.app.xmlui.wing.element.Text;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.xml.sax.SAXException;

public class UploadWithEmbargoStep
extends UploadStep {
    protected static final Message T_head = UploadWithEmbargoStep.message((String)"xmlui.Submission.submit.UploadWithEmbargoStep.head");
    protected static final Message T_file = UploadWithEmbargoStep.message((String)"xmlui.Submission.submit.UploadWithEmbargoStep.file");
    protected static final Message T_file_help = UploadWithEmbargoStep.message((String)"xmlui.Submission.submit.UploadWithEmbargoStep.file_help");
    protected static final Message T_file_error = UploadWithEmbargoStep.message((String)"xmlui.Submission.submit.UploadWithEmbargoStep.file_error");
    protected static final Message T_upload_error = UploadWithEmbargoStep.message((String)"xmlui.Submission.submit.UploadWithEmbargoStep.upload_error");
    protected static final Message T_virus_checker_error = UploadWithEmbargoStep.message((String)"xmlui.Submission.submit.UploadWithEmbargoStep.virus_checker_error");
    protected static final Message T_virus_error = UploadWithEmbargoStep.message((String)"xmlui.Submission.submit.UploadWithEmbargoStep.virus_error");
    protected static final Message T_description = UploadWithEmbargoStep.message((String)"xmlui.Submission.submit.UploadWithEmbargoStep.description");
    protected static final Message T_description_help = UploadWithEmbargoStep.message((String)"xmlui.Submission.submit.UploadWithEmbargoStep.description_help");
    protected static final Message T_submit_upload = UploadWithEmbargoStep.message((String)"xmlui.Submission.submit.UploadWithEmbargoStep.submit_upload");
    protected static final Message T_head2 = UploadWithEmbargoStep.message((String)"xmlui.Submission.submit.UploadWithEmbargoStep.head2");
    protected static final Message T_column0 = UploadWithEmbargoStep.message((String)"xmlui.Submission.submit.UploadWithEmbargoStep.column0");
    protected static final Message T_column1 = UploadWithEmbargoStep.message((String)"xmlui.Submission.submit.UploadWithEmbargoStep.column1");
    protected static final Message T_column2 = UploadWithEmbargoStep.message((String)"xmlui.Submission.submit.UploadWithEmbargoStep.column2");
    protected static final Message T_column3 = UploadWithEmbargoStep.message((String)"xmlui.Submission.submit.UploadWithEmbargoStep.column3");
    protected static final Message T_column4 = UploadWithEmbargoStep.message((String)"xmlui.Submission.submit.UploadWithEmbargoStep.column4");
    protected static final Message T_column5 = UploadWithEmbargoStep.message((String)"xmlui.Submission.submit.UploadWithEmbargoStep.column5");
    protected static final Message T_column6 = UploadWithEmbargoStep.message((String)"xmlui.Submission.submit.UploadWithEmbargoStep.column6");
    protected static final Message T_unknown_name = UploadWithEmbargoStep.message((String)"xmlui.Submission.submit.UploadWithEmbargoStep.unknown_name");
    protected static final Message T_unknown_format = UploadWithEmbargoStep.message((String)"xmlui.Submission.submit.UploadWithEmbargoStep.unknown_format");
    protected static final Message T_supported = UploadWithEmbargoStep.message((String)"xmlui.Submission.submit.UploadWithEmbargoStep.supported");
    protected static final Message T_known = UploadWithEmbargoStep.message((String)"xmlui.Submission.submit.UploadWithEmbargoStep.known");
    protected static final Message T_unsupported = UploadWithEmbargoStep.message((String)"xmlui.Submission.submit.UploadWithEmbargoStep.unsupported");
    protected static final Message T_submit_edit = UploadWithEmbargoStep.message((String)"xmlui.Submission.submit.UploadWithEmbargoStep.submit_edit");
    protected static final Message T_submit_policy = UploadWithEmbargoStep.message((String)"xmlui.Submission.submit.UploadWithEmbargoStep.submit_policy");
    protected static final Message T_checksum = UploadWithEmbargoStep.message((String)"xmlui.Submission.submit.UploadWithEmbargoStep.checksum");
    protected static final Message T_submit_remove = UploadWithEmbargoStep.message((String)"xmlui.Submission.submit.UploadWithEmbargoStep.submit_remove");
    private EditFileStep editFile = null;
    private EditBitstreamPolicies editBitstreamPolicies = null;
    private EditPolicyStep editPolicy = null;
    private boolean isAdvancedFormEnabled = true;

    public UploadWithEmbargoStep() {
        this.requireSubmission = true;
        this.requireStep = true;
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, parameters);
        if (this.errorFlag == 20) {
            this.editFile = new EditFileStep();
            this.editFile.setup(resolver, objectModel, src, parameters);
        } else if (this.errorFlag == 30 || this.errorFlag == 31 || this.errorFlag == 32) {
            this.editBitstreamPolicies = new EditBitstreamPolicies();
            this.editBitstreamPolicies.setup(resolver, objectModel, src, parameters);
        } else if (this.errorFlag == 10 || this.errorFlag == 33 || this.errorFlag == 34) {
            this.editPolicy = new EditPolicyStep();
            this.editPolicy.setup(resolver, objectModel, src, parameters);
        } else {
            this.editFile = null;
            this.editBitstreamPolicies = null;
            this.editPolicy = null;
        }
        this.isAdvancedFormEnabled = DSpaceServicesFactory.getInstance().getConfigurationService().getBooleanProperty("webui.submission.restrictstep.enableAdvancedForm", false);
    }

    public void addPageMeta(PageMeta pageMeta) throws WingException, AuthorizeException, IOException, SAXException, SQLException {
        super.addPageMeta(pageMeta);
        pageMeta.addMetadata("javascript", "static").addContent("static/js/accessFormUtil.js");
    }

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        if (this.editFile != null) {
            this.editFile.addBody(body);
            return;
        }
        if (this.editBitstreamPolicies != null && this.isAdvancedFormEnabled) {
            this.editBitstreamPolicies.addBody(body);
            return;
        }
        if (this.editPolicy != null && this.isAdvancedFormEnabled) {
            this.editPolicy.addBody(body);
            return;
        }
        Item item = this.submission.getItem();
        Collection collection = this.submission.getCollection();
        String actionURL = this.contextPath + "/handle/" + collection.getHandle() + "/submit/" + this.knot.getId() + ".continue";
        boolean disableFileEditing = this.submissionInfo.isInWorkflow() && !DSpaceServicesFactory.getInstance().getConfigurationService().getBooleanProperty("workflow.reviewer.file-edit");
        List bundles = this.itemService.getBundles(item, "ORIGINAL");
        List bitstreams = new ArrayList();
        if (bundles.size() > 0) {
            bitstreams = ((Bundle)bundles.get(0)).getBitstreams();
        }
        Division div = body.addInteractiveDivision("submit-upload", actionURL, "multipart", "primary submission");
        div.setHead(T_submission_head);
        this.addSubmissionProgressList(div);
        org.dspace.app.xmlui.wing.element.List upload = null;
        if (!disableFileEditing) {
            upload = div.addList("submit-upload-new", "form");
            upload.setHead(T_head);
            File file = upload.addItem().addFile("file");
            file.setLabel(T_file);
            file.setHelp(T_file_help);
            file.setRequired();
            if (this.errorFlag == 5) {
                file.addError(T_file_error);
            }
            if (this.errorFlag == 2) {
                file.addError(T_upload_error);
            }
            if (this.errorFlag == 14) {
                file.addError(T_virus_checker_error);
            }
            if (this.errorFlag == 16) {
                file.addError(T_virus_error);
            }
            Text description = upload.addItem().addText("description");
            description.setLabel(T_description);
            description.setHelp(T_description_help);
            if (!this.isAdvancedFormEnabled) {
                AccessStepUtil asu = new AccessStepUtil(this.context);
                asu.addEmbargoDateSimpleForm((DSpaceObject)item, upload, this.errorFlag);
                asu.addReason(null, upload, this.errorFlag);
            }
            Button uploadSubmit = upload.addItem().addButton("submit_upload");
            uploadSubmit.setValue(T_submit_upload);
        }
        this.make_sherpaRomeo_submission(item, div);
        if (bitstreams.size() > 0 || disableFileEditing) {
            Table summary = div.addTable("submit-upload-summary", bitstreams.size() * 2 + 2, 7);
            summary.setHead(T_head2);
            Row header = summary.addRow("header");
            header.addCellContent(T_column0);
            header.addCellContent(T_column1);
            header.addCellContent(T_column2);
            header.addCellContent(T_column3);
            header.addCellContent(T_column4);
            header.addCellContent(T_column5);
            header.addCellContent(T_column6);
            for (Bitstream bitstream : bitstreams) {
                UUID id = bitstream.getID();
                String name = bitstream.getName();
                String url = this.makeBitstreamLink(item, bitstream);
                long bytes = bitstream.getSize();
                String desc = bitstream.getDescription();
                String algorithm = bitstream.getChecksumAlgorithm();
                String checksum = bitstream.getChecksum();
                Row row = summary.addRow();
                Radio primary = row.addCell().addRadio("primary_bitstream_id");
                primary.addOption(String.valueOf(id));
                if (((Bundle)bundles.get(0)).getPrimaryBitstream() != null && ((Bundle)bundles.get(0)).getPrimaryBitstream().getID().equals(id)) {
                    primary.setOptionSelected(String.valueOf(id));
                }
                if (!disableFileEditing) {
                    CheckBox remove = row.addCell().addCheckBox("remove");
                    remove.setLabel("remove");
                    remove.addOption(id.toString());
                } else {
                    row.addCell();
                }
                row.addCell().addXref(url, name);
                row.addCellContent(bytes + " bytes");
                if (desc == null || desc.length() == 0) {
                    row.addCellContent(T_unknown_name);
                } else {
                    row.addCellContent(desc);
                }
                BitstreamFormat format = bitstream.getFormat(this.context);
                if (format == null) {
                    row.addCellContent(T_unknown_format);
                } else {
                    int support = format.getSupportLevel();
                    Cell cell = row.addCell();
                    cell.addContent(format.getMIMEType());
                    cell.addContent(" ");
                    switch (support) {
                        case 1: {
                            cell.addContent(T_supported);
                            break;
                        }
                        case 2: {
                            cell.addContent(T_known);
                            break;
                        }
                        case 3: {
                            cell.addContent(T_unsupported);
                        }
                    }
                }
                Button edit = row.addCell().addButton("submit_edit_" + id);
                edit.setValue(T_submit_edit);
                if (this.isAdvancedFormEnabled) {
                    Button policy = row.addCell().addButton("submit_editPolicy_" + id);
                    policy.setValue(T_submit_policy);
                }
                Row checksumRow = summary.addRow();
                checksumRow.addCell();
                Cell checksumCell = checksumRow.addCell(null, null, 0, 6, null);
                checksumCell.addHighlight("bold").addContent(T_checksum);
                checksumCell.addContent(" ");
                checksumCell.addContent(algorithm + ":" + checksum);
            }
            if (!disableFileEditing) {
                Row actionRow = summary.addRow();
                actionRow.addCell();
                Button removeSeleceted = actionRow.addCell(null, null, 0, 6, null).addButton("submit_remove_selected");
                removeSeleceted.setValue(T_submit_remove);
            }
            upload = div.addList("submit-upload-new-part2", "form");
        }
        this.addControlButtons(upload);
    }

    public org.dspace.app.xmlui.wing.element.List addReviewSection(org.dspace.app.xmlui.wing.element.List reviewList) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        org.dspace.app.xmlui.wing.element.List uploadSection = reviewList.addList("submit-review-" + this.stepAndPage, "form");
        uploadSection.setHead(T_head);
        Item item = this.submission.getItem();
        List bundles = this.itemService.getBundles(item, "ORIGINAL");
        List bitstreams = new ArrayList();
        if (bundles.size() > 0) {
            bitstreams = ((Bundle)bundles.get(0)).getBitstreams();
        }
        for (Bitstream bitstream : bitstreams) {
            BitstreamFormat bitstreamFormat = bitstream.getFormat(this.context);
            String name = bitstream.getName();
            String url = this.makeBitstreamLink(item, bitstream);
            String format = bitstreamFormat.getShortDescription();
            Message support = ReviewStep.T_unknown;
            if (bitstreamFormat.getSupportLevel() == 1) {
                support = T_known;
            } else if (bitstreamFormat.getSupportLevel() == 2) {
                support = T_supported;
            }
            org.dspace.app.xmlui.wing.element.Item file = uploadSection.addItem();
            file.addXref(url, name);
            file.addContent(" - " + format + " ");
            file.addContent(support);
        }
        return uploadSection;
    }

    private String makeBitstreamLink(Item item, Bitstream bitstream) {
        String name = bitstream.getName();
        StringBuilder result = new StringBuilder(this.contextPath);
        result.append("/bitstream/item/").append(String.valueOf(item.getID()));
        try {
            if (name != null) {
                result.append("/").append(Util.encodeBitstreamName((String)name, (String)"UTF-8"));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        result.append("?sequence=").append(String.valueOf(bitstream.getSequenceID()));
        return result.toString();
    }
}

