/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.versioning;

import java.sql.SQLException;
import java.util.UUID;
import org.apache.avalon.framework.parameters.ParameterException;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Composite;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.TextArea;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.versioning.VersionHistory;
import org.dspace.versioning.factory.VersionServiceFactory;
import org.dspace.versioning.service.VersionHistoryService;

public class VersionItemForm
extends AbstractDSpaceTransformer {
    private static final Message T_dspace_home = VersionItemForm.message((String)"xmlui.general.dspace_home");
    private static final Message T_submit_cancel = VersionItemForm.message((String)"xmlui.general.cancel");
    private static final Message T_title = VersionItemForm.message((String)"xmlui.aspect.versioning.VersionItemForm.title");
    private static final Message T_trail = VersionItemForm.message((String)"xmlui.aspect.versioning.VersionItemForm.trail");
    private static final Message T_head1 = VersionItemForm.message((String)"xmlui.aspect.versioning.VersionItemForm.head1");
    private static final Message T_submit_version = VersionItemForm.message((String)"xmlui.aspect.versioning.VersionItemForm.submit_version");
    private static final Message T_submit_update_version = VersionItemForm.message((String)"xmlui.aspect.versioning.VersionItemForm.submit_update_version");
    private static final Message T_summary = VersionItemForm.message((String)"xmlui.aspect.versioning.VersionItemForm.summary");
    protected AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected VersionHistoryService versionHistoryService = VersionServiceFactory.getInstance().getVersionHistoryService();

    public void addPageMeta(PageMeta pageMeta) throws WingException, SQLException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        Item item = this.getItem();
        if (item != null) {
            HandleUtil.buildHandleTrail((Context)this.context, (DSpaceObject)item, (PageMeta)pageMeta, (String)this.contextPath);
            pageMeta.addTrailLink(this.contextPath + "/handle/" + item.getHandle(), item.getName());
        }
        pageMeta.addTrail().addContent(T_trail);
    }

    public void addBody(Body body) throws WingException, SQLException, AuthorizeException {
        String summary;
        Item item = this.getItem();
        if (!this.authorizeService.isAdmin(this.context, (DSpaceObject)item.getOwningCollection())) {
            throw new AuthorizeException();
        }
        try {
            summary = this.parameters.getParameter("summary");
        }
        catch (ParameterException e) {
            throw new RuntimeException(e);
        }
        Division main = body.addInteractiveDivision("version-item", this.contextPath + "/item/version", "post", "primary administrative version");
        main.setHead(T_head1.parameterize(new Object[]{item.getHandle()}));
        List fields = main.addList("fields", "form");
        Composite addComposite = fields.addItem().addComposite("summary");
        addComposite.setLabel(T_summary);
        TextArea addValue = addComposite.addTextArea("summary");
        if (summary != null) {
            addValue.setValue(summary);
        }
        Para actions = main.addPara();
        VersionHistory history = this.retrieveVersionHistory(item);
        if (history != null && this.versionHistoryService.hasNext(this.context, history, item)) {
            actions.addButton("submit_update_version").setValue(T_submit_update_version);
        } else {
            actions.addButton("submit_version").setValue(T_submit_version);
        }
        actions.addButton("submit_cancel").setValue(T_submit_cancel);
        main.addHidden("versioning-continue").setValue(this.knot.getId());
    }

    private Item getItem() throws SQLException {
        UUID itemID = UUID.fromString(this.parameters.getParameter("itemID", null));
        return (Item)this.itemService.find(this.context, itemID);
    }

    private VersionHistory retrieveVersionHistory(Item item) throws SQLException {
        return this.versionHistoryService.findByItem(this.context, item);
    }
}

