/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.cocoon;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.environment.http.HttpResponse;
import org.apache.cocoon.reading.AbstractReader;
import org.apache.cocoon.util.ByteRange;
import org.dspace.app.itemexport.factory.ItemExportServiceFactory;
import org.dspace.app.itemexport.service.ItemExportService;
import org.dspace.app.xmlui.utils.AuthenticationUtil;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.core.Context;
import org.xml.sax.SAXException;

public class ItemExportDownloadReader
extends AbstractReader
implements Recyclable {
    private static final String AUTH_REQUIRED_HEADER = "xmlui.ItemExportDownloadReader.auth_header";
    private static final String AUTH_REQUIRED_MESSAGE = "xmlui.ItemExportDownloadReader.auth_message";
    protected static final int BUFFER_SIZE = 8192;
    protected static final int expires = 216000000;
    protected Response response;
    protected Request request;
    protected InputStream compressedExportInputStream;
    protected long compressedExportSize;
    protected String compressedExportName;
    protected ItemExportService itemExportService = ItemExportServiceFactory.getInstance().getItemExportService();

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        try {
            this.request = ObjectModelHelper.getRequest((Map)objectModel);
            this.response = ObjectModelHelper.getResponse((Map)objectModel);
            Context context = ContextUtil.obtainContext((Map)objectModel);
            String fileName = par.getParameter("fileName", null);
            if (!this.itemExportService.canDownload(context, fileName)) {
                if (context.getCurrentUser() != null) {
                    String redictURL = this.request.getContextPath() + "/restricted-resource?name=" + fileName;
                    HttpServletResponse httpResponse = (HttpServletResponse)objectModel.get("httpresponse");
                    httpResponse.sendRedirect(redictURL);
                    return;
                }
                AuthenticationUtil.interruptRequest((Map)objectModel, (String)AUTH_REQUIRED_HEADER, (String)AUTH_REQUIRED_MESSAGE, null);
                String redictURL = this.request.getContextPath() + "/login";
                HttpServletResponse httpResponse = (HttpServletResponse)objectModel.get("httpresponse");
                httpResponse.sendRedirect(redictURL);
                return;
            }
            this.compressedExportInputStream = this.itemExportService.getExportDownloadInputStream(fileName, context.getCurrentUser());
            this.compressedExportSize = this.itemExportService.getExportFileSize(context, fileName);
            this.compressedExportName = fileName;
        }
        catch (Exception e) {
            throw new ProcessingException("Unable to read bitstream.", (Throwable)e);
        }
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        if (this.compressedExportInputStream == null) {
            return;
        }
        byte[] buffer = new byte[8192];
        int length = -1;
        this.response.setDateHeader("Expires", System.currentTimeMillis() + 216000000L);
        this.response.setHeader("Content-disposition", "attachement; filename=" + this.compressedExportName);
        Object byteRange = null;
        if (byteRange != null) {
            String entityRange;
            String entityLength;
            if (this.compressedExportSize != -1L) {
                entityLength = "" + this.compressedExportSize;
                entityRange = byteRange.intersection(new ByteRange(0L, this.compressedExportSize)).toString();
            } else {
                entityLength = "*";
                entityRange = byteRange.toString();
            }
            this.response.setHeader("Content-Range", entityRange + "/" + entityLength);
            if (this.response instanceof HttpResponse) {
                ((HttpResponse)this.response).setStatus(206);
            }
            int pos = 0;
            while ((length = this.compressedExportInputStream.read(buffer)) > -1) {
                int posEnd = pos + length - 1;
                ByteRange intersection = byteRange.intersection(new ByteRange((long)pos, (long)posEnd));
                if (intersection != null) {
                    this.out.write(buffer, (int)intersection.getStart() - pos, (int)intersection.length());
                }
                pos += length;
            }
        } else {
            this.response.setHeader("Content-Length", String.valueOf(this.compressedExportSize));
            while ((length = this.compressedExportInputStream.read(buffer)) > -1) {
                this.out.write(buffer, 0, length);
            }
            this.out.flush();
        }
        this.out.close();
    }

    public String getMimeType() {
        return "application/zip";
    }

    public void recycle() {
        this.response = null;
        this.request = null;
        this.compressedExportInputStream = null;
        this.compressedExportSize = 0L;
        this.compressedExportName = null;
        super.recycle();
    }
}

