/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.wing.element;

import java.util.ArrayList;
import org.dspace.app.xmlui.wing.AttributeMap;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingConstants;
import org.dspace.app.xmlui.wing.WingContext;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.AbstractWingElement;
import org.dspace.app.xmlui.wing.element.Head;
import org.dspace.app.xmlui.wing.element.Hidden;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.ReferenceSet;
import org.dspace.app.xmlui.wing.element.SimpleHTMLFragment;
import org.dspace.app.xmlui.wing.element.StructuralElement;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.app.xmlui.wing.element.WingMergeableElement;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class Division
extends AbstractWingElement
implements StructuralElement,
WingMergeableElement {
    public static final String E_DIVISION = "div";
    public static final String A_INTERACTIVE = "interactive";
    public static final String A_ACTION = "action";
    public static final String A_METHOD = "method";
    public static final String A_BEHAVIOR = "behavior";
    public static final String A_BEHVIOR_SENSITIVE_FIELDS = "behaviorSensitiveFields";
    public static final String A_PAGINATION = "pagination";
    public static final String A_PREVIOUS_PAGE = "previousPage";
    public static final String A_NEXT_PAGE = "nextPage";
    public static final String A_ITEMS_TOTAL = "itemsTotal";
    public static final String A_FIRST_ITEM_INDEX = "firstItemIndex";
    public static final String A_LAST_ITEM_INDEX = "lastItemIndex";
    public static final String A_CURRENT_PAGE = "currentPage";
    public static final String A_PAGES_TOTAL = "pagesTotal";
    public static final String A_PAGE_URL_MASK = "pageURLMask";
    private boolean merged = false;
    private final String name;
    private boolean interactive;
    private String action;
    private String method;
    private boolean behaviorAJAXenabled = false;
    private String behaviorSensitiveFields;
    private final String rend;
    private Head head;
    private Para hiddenFieldsPara;
    private String paginationType;
    private String previousPage;
    private String nextPage;
    private int itemsTotal;
    private int firstItemIndex;
    private int lastItemIndex;
    private int currentPage;
    private int pagesTotal;
    private String pageURLMask;
    public static final String METHOD_GET = "get";
    public static final String METHOD_POST = "post";
    public static final String METHOD_MULTIPART = "multipart";
    public static final String[] METHODS = new String[]{"get", "post", "multipart"};
    public static final String PAGINATION_SIMPLE = "simple";
    public static final String PAGINATION_MASKED = "masked";
    public static final String[] PAGINATION_TYPES = new String[]{"simple", "masked"};
    private java.util.List<AbstractWingElement> contents = new ArrayList();

    protected Division(WingContext context, String name, String rend) throws WingException {
        super(context);
        this.require(name, "The 'name' parameter is required for divisions.");
        this.name = name;
        this.rend = rend;
    }

    protected Division(WingContext context, String name, String action, String method, String rend) throws WingException {
        super(context);
        this.require(name, "The 'name' parameter is required for divisions.");
        this.require(method, "The 'method' parameter is required for divisions.");
        this.restrict(method, METHODS, "The 'method' parameter must be one of these values: 'get', 'post' or 'multipart'.");
        this.name = name;
        this.interactive = true;
        this.action = action;
        this.method = method;
        this.rend = rend;
    }

    public void enableAJAX() {
        this.behaviorAJAXenabled = true;
    }

    public void addBehaviorSensitiveField(String fieldName) throws WingException {
        this.require(fieldName, "The fieldName parameter is required for the behaviorSensitiveFields attribute.");
        this.behaviorSensitiveFields = this.behaviorSensitiveFields == null ? fieldName : this.behaviorSensitiveFields + " " + fieldName;
    }

    public void setSimplePagination(int itemsTotal, int firstItemIndex, int lastItemIndex, String previousPage, String nextPage) {
        this.paginationType = PAGINATION_SIMPLE;
        this.previousPage = previousPage;
        this.nextPage = nextPage;
        this.itemsTotal = itemsTotal;
        this.firstItemIndex = firstItemIndex;
        this.lastItemIndex = lastItemIndex;
    }

    public void setMaskedPagination(int itemsTotal, int firstItemIndex, int lastItemIndex, int currentPage, int pagesTotal, String pageURLMask) {
        this.paginationType = PAGINATION_MASKED;
        this.itemsTotal = itemsTotal;
        this.firstItemIndex = firstItemIndex;
        this.lastItemIndex = lastItemIndex;
        this.currentPage = currentPage;
        this.pagesTotal = pagesTotal;
        this.pageURLMask = pageURLMask;
    }

    public Head setHead() throws WingException {
        this.head = new Head(this.context, null);
        return this.head;
    }

    public void setHead(String characters) throws WingException {
        Head theHead = this.setHead();
        theHead.addContent(characters);
    }

    public void setHead(Message message) throws WingException {
        Head theHead = this.setHead();
        theHead.addContent(message);
    }

    public Division addDivision(String name, String rend) throws WingException {
        Division division = new Division(this.context, name, rend);
        this.contents.add(division);
        return division;
    }

    public Division addDivision(String name) throws WingException {
        return this.addDivision(name, null);
    }

    public Division addInteractiveDivision(String name, String action, String method, String rend) throws WingException {
        Division division = new Division(this.context, name, action, method, rend);
        this.contents.add(division);
        return division;
    }

    public Division addInteractiveDivision(String name, String action, String method) throws WingException {
        return this.addInteractiveDivision(name, action, method, null);
    }

    public Para addPara(String name, String rend) throws WingException {
        Para para = new Para(this.context, name, rend);
        this.contents.add(para);
        return para;
    }

    public Para addPara() throws WingException {
        return this.addPara(null, null);
    }

    public void addPara(String characters) throws WingException {
        Para para = this.addPara();
        para.addContent(characters);
    }

    public void addPara(Message message) throws WingException {
        Para para = this.addPara();
        para.addContent(message);
    }

    public List addList(String name, String type, String rend) throws WingException {
        List list = new List(this.context, name, type, rend);
        this.contents.add(list);
        return list;
    }

    public List addList(String name, String type) throws WingException {
        return this.addList(name, type, null);
    }

    public List addList(String name) throws WingException {
        return this.addList(name, null, null);
    }

    public Table addTable(String name, int rows, int cols, String rend) throws WingException {
        Table table = new Table(this.context, name, rows, cols, rend);
        this.contents.add(table);
        return table;
    }

    public Table addTable(String name, int rows, int cols) throws WingException {
        return this.addTable(name, rows, cols, null);
    }

    public ReferenceSet addReferenceSet(String name, String type, String orderBy, String rend) throws WingException {
        ReferenceSet referenceSet = new ReferenceSet(this.context, false, name, type, orderBy, rend);
        this.contents.add(referenceSet);
        return referenceSet;
    }

    public ReferenceSet addReferenceSet(String name, String type) throws WingException {
        return this.addReferenceSet(name, type, null, null);
    }

    public Hidden addHidden(String name) throws WingException {
        if (this.hiddenFieldsPara == null) {
            this.hiddenFieldsPara = this.addPara("hidden-fields", "hidden");
        }
        return this.hiddenFieldsPara.addHidden(name);
    }

    public void addSimpleHTMLFragment(boolean blankLines, String HTML) throws WingException {
        this.contents.add(new SimpleHTMLFragment(this.context, blankLines, HTML));
    }

    public boolean mergeEqual(String namespace, String localName, String qName, Attributes attributes) throws SAXException, WingException {
        if (!WingConstants.DRI.URI.equals(namespace)) {
            return false;
        }
        if (!E_DIVISION.equals(localName)) {
            return false;
        }
        this.context.getLogger().debug((Object)"Merging a division");
        String aName = attributes.getValue("n");
        String isInteractive = attributes.getValue(A_INTERACTIVE);
        String anAction = attributes.getValue(A_ACTION);
        String aMethod = attributes.getValue(A_METHOD);
        String render = attributes.getValue("rend");
        String pagination = attributes.getValue(A_PAGINATION);
        String behavior = attributes.getValue(A_BEHAVIOR);
        this.context.getLogger().debug((Object)("Merging got parameters name=" + aName + ", interactive=" + isInteractive + ", action=" + anAction + ", method=" + aMethod + ", render=" + render + ", pagination=" + pagination));
        if (!this.name.equals(aName)) {
            return false;
        }
        if (this.rend == null ? render != null : !this.rend.equals(render)) {
            return false;
        }
        if (this.interactive) {
            if (!"yes".equals(isInteractive)) {
                return false;
            }
            if (!this.action.equals(anAction)) {
                return false;
            }
            if (!this.method.equals(aMethod)) {
                return false;
            }
            if (behavior != null && !behavior.equals("")) {
                return false;
            }
        } else if (isInteractive != null && !"no".equals(isInteractive)) {
            return false;
        }
        return true;
    }

    public WingMergeableElement mergeChild(String namespace, String localName, String qName, Attributes attributes) throws SAXException, WingException {
        WingMergeableElement found = null;
        for (AbstractWingElement content : this.contents) {
            WingMergeableElement candidate;
            if (!(content instanceof WingMergeableElement) || !(candidate = (WingMergeableElement)content).mergeEqual(namespace, localName, qName, attributes)) continue;
            found = candidate;
        }
        this.contents.remove(found);
        return found;
    }

    public Attributes merge(Attributes attributes) throws SAXException, WingException {
        this.merged = true;
        return attributes;
    }

    public void toSAX(ContentHandler contentHandler, LexicalHandler lexicalHandler, NamespaceSupport namespaces) throws SAXException {
        if (!this.merged) {
            AttributeMap divAttributes = new AttributeMap();
            divAttributes.put((Object)"n", (Object)this.name);
            divAttributes.put((Object)"id", (Object)this.context.generateID(E_DIVISION, this.name));
            if (this.interactive) {
                divAttributes.put((Object)A_INTERACTIVE, (Object)"yes");
                divAttributes.put((Object)A_ACTION, (Object)this.action);
                divAttributes.put((Object)A_METHOD, (Object)this.method);
                if (this.behaviorAJAXenabled) {
                    divAttributes.put((Object)A_BEHAVIOR, (Object)"ajax");
                }
                if (this.behaviorSensitiveFields != null) {
                    divAttributes.put((Object)A_BEHVIOR_SENSITIVE_FIELDS, (Object)this.behaviorSensitiveFields);
                }
            }
            if (PAGINATION_SIMPLE.equals(this.paginationType)) {
                divAttributes.put((Object)A_PAGINATION, (Object)this.paginationType);
                if (this.previousPage != null) {
                    divAttributes.put((Object)A_PREVIOUS_PAGE, (Object)this.previousPage);
                }
                if (this.nextPage != null) {
                    divAttributes.put((Object)A_NEXT_PAGE, (Object)this.nextPage);
                }
                divAttributes.put(A_ITEMS_TOTAL, this.itemsTotal);
                divAttributes.put(A_FIRST_ITEM_INDEX, this.firstItemIndex);
                divAttributes.put(A_LAST_ITEM_INDEX, this.lastItemIndex);
            } else if (PAGINATION_MASKED.equals(this.paginationType)) {
                divAttributes.put((Object)A_PAGINATION, (Object)this.paginationType);
                divAttributes.put(A_ITEMS_TOTAL, this.itemsTotal);
                divAttributes.put(A_FIRST_ITEM_INDEX, this.firstItemIndex);
                divAttributes.put(A_LAST_ITEM_INDEX, this.lastItemIndex);
                divAttributes.put(A_CURRENT_PAGE, this.currentPage);
                divAttributes.put(A_PAGES_TOTAL, this.pagesTotal);
                divAttributes.put((Object)A_PAGE_URL_MASK, (Object)this.pageURLMask);
            }
            if (this.rend != null) {
                divAttributes.put((Object)"rend", (Object)this.rend);
            }
            this.startElement(contentHandler, namespaces, E_DIVISION, divAttributes);
            if (this.head != null) {
                this.head.toSAX(contentHandler, lexicalHandler, namespaces);
            }
        }
        for (AbstractWingElement content : this.contents) {
            content.toSAX(contentHandler, lexicalHandler, namespaces);
        }
        if (!this.merged) {
            this.endElement(contentHandler, namespaces, E_DIVISION);
        }
    }

    public void dispose() {
        if (this.head != null) {
            this.head.dispose();
            this.head = null;
        }
        if (this.contents != null) {
            for (AbstractWingElement content : this.contents) {
                content.dispose();
            }
            this.contents.clear();
            this.contents = null;
        }
        super.dispose();
    }
}

