/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.dspace.app.itemexport.factory.ItemExportServiceFactory;
import org.dspace.app.itemexport.service.ItemExportService;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.DSpaceValidity;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.ItemService;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.GroupService;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class ItemExport
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    private static final Message T_dspace_home = ItemExport.message((String)"xmlui.general.dspace_home");
    private static final Message T_main_head = ItemExport.message((String)"xmlui.administrative.ItemExport.head");
    private static final Message T_export_bad_item_id = ItemExport.message((String)"xmlui.administrative.ItemExport.item.id.error");
    private static final Message T_export_bad_col_id = ItemExport.message((String)"xmlui.administrative.ItemExport.collection.id.error");
    private static final Message T_export_bad_community_id = ItemExport.message((String)"xmlui.administrative.ItemExport.community.id.error");
    private static final Message T_export_item_not_found = ItemExport.message((String)"xmlui.administrative.ItemExport.item.not.found");
    private static final Message T_export_col_not_found = ItemExport.message((String)"xmlui.administrative.ItemExport.collection.not.found");
    private static final Message T_export_community_not_found = ItemExport.message((String)"xmlui.administrative.ItemExport.community.not.found");
    private static final Message T_item_export_success = ItemExport.message((String)"xmlui.administrative.ItemExport.item.success");
    private static final Message T_col_export_success = ItemExport.message((String)"xmlui.administrative.ItemExport.collection.success");
    private static final Message T_community_export_success = ItemExport.message((String)"xmlui.administrative.ItemExport.community.success");
    private static final Message T_avail_head = ItemExport.message((String)"xmlui.administrative.ItemExport.available.head");
    Request request;
    Response response;
    List<Message> errors;
    List<String> availableExports;
    Message message;
    private SourceValidity validity;
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected ItemExportService itemExportService = ItemExportServiceFactory.getInstance().getItemExportService();
    protected GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, parameters);
        this.objectModel = objectModel;
        this.request = ObjectModelHelper.getRequest((Map)objectModel);
        this.response = ObjectModelHelper.getResponse((Map)objectModel);
        this.errors = new ArrayList();
        if (this.request.getParameter("itemID") != null) {
            Item item = null;
            try {
                item = (Item)this.itemService.find(this.context, UUID.fromString(this.request.getParameter("itemID")));
            }
            catch (Exception e) {
                this.errors.add(T_export_bad_item_id);
            }
            if (item == null) {
                this.errors.add(T_export_item_not_found);
            } else {
                try {
                    this.itemExportService.createDownloadableExport((DSpaceObject)item, this.context, false);
                }
                catch (Exception e) {
                    this.errors.add(ItemExport.message((String)e.getMessage()));
                }
            }
            if (this.errors.size() <= 0) {
                this.message = T_item_export_success;
            }
        } else if (this.request.getParameter("collectionID") != null) {
            Collection col = null;
            try {
                col = (Collection)this.collectionService.find(this.context, UUID.fromString(this.request.getParameter("collectionID")));
            }
            catch (Exception e) {
                this.errors.add(T_export_bad_col_id);
            }
            if (col == null) {
                this.errors.add(T_export_col_not_found);
            } else {
                try {
                    this.itemExportService.createDownloadableExport((DSpaceObject)col, this.context, false);
                }
                catch (Exception e) {
                    this.errors.add(ItemExport.message((String)e.getMessage()));
                }
            }
            if (this.errors.size() <= 0) {
                this.message = T_col_export_success;
            }
        } else if (this.request.getParameter("communityID") != null) {
            Community com = null;
            try {
                com = (Community)this.communityService.find(this.context, UUID.fromString(this.request.getParameter("communityID")));
            }
            catch (Exception e) {
                this.errors.add(T_export_bad_community_id);
            }
            if (com == null) {
                this.errors.add(T_export_community_not_found);
            } else {
                try {
                    this.itemExportService.createDownloadableExport((DSpaceObject)com, this.context, false);
                }
                catch (Exception e) {
                    this.errors.add(ItemExport.message((String)e.getMessage()));
                }
            }
            if (this.errors.size() <= 0) {
                this.message = T_community_export_success;
            }
        }
        try {
            this.availableExports = this.itemExportService.getExportsAvailable(this.context.getCurrentUser());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Serializable getKey() {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        if (request.getParameter("login_email") != null || request.getParameter("login_password") != null || request.getParameter("login_realm") != null) {
            return "0";
        }
        StringBuilder key = new StringBuilder();
        if (this.context.getCurrentUser() != null) {
            key.append(this.context.getCurrentUser().getEmail());
            if (this.availableExports != null && this.availableExports.size() > 0) {
                for (String fileName : this.availableExports) {
                    key.append(":").append(fileName);
                }
            }
            if (request.getQueryString() != null) {
                key.append(request.getQueryString());
            }
        } else {
            key.append("anonymous");
        }
        return Long.valueOf(HashUtil.hash((String)key.toString()));
    }

    public SourceValidity getValidity() {
        if (this.validity == null) {
            if (this.context.getCurrentUser() != null) {
                try {
                    DSpaceValidity validity = new DSpaceValidity();
                    validity.add(this.context, (DSpaceObject)this.eperson);
                    Set groups = this.groupService.allMemberGroupsSet(this.context, this.eperson);
                    for (Group group : groups) {
                        validity.add(this.context, (DSpaceObject)group);
                    }
                    this.validity = validity.complete();
                }
                catch (SQLException sQLException) {}
            } else {
                this.validity = NOPValidity.SHARED_INSTANCE;
            }
        }
        return this.validity;
    }

    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        pageMeta.addMetadata("title").addContent(T_main_head);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrail().addContent(T_main_head);
    }

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        Division main = body.addDivision("export_main");
        main.setHead(T_main_head);
        if (this.message != null) {
            main.addDivision("success", "success").addPara(this.message);
        }
        if (this.errors.size() > 0) {
            Division errors = main.addDivision("export-errors", "error");
            for (Message error : this.errors) {
                errors.addPara(error);
            }
        }
        if (this.availableExports != null && this.availableExports.size() > 0) {
            Division avail = main.addDivision("available-exports", "available-exports");
            avail.setHead(T_avail_head);
            org.dspace.app.xmlui.wing.element.List fileList = avail.addList("available-files", "ordered");
            for (String fileName : this.availableExports) {
                fileList.addItem().addXref(this.contextPath + "/exportdownload/" + fileName, fileName);
            }
        }
    }

    public void recycle() {
        this.validity = null;
        this.errors = null;
        this.message = null;
        this.availableExports = null;
        this.response = null;
        this.request = null;
        super.recycle();
    }
}

