/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.utils;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.aspect.administrative.SystemwideAlerts;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.app.xmlui.utils.RequestInfo;
import org.dspace.authenticate.factory.AuthenticateServiceFactory;
import org.dspace.authenticate.service.AuthenticationService;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.GroupService;
import org.dspace.services.factory.DSpaceServicesFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class AuthenticationUtil {
    private static final Logger log = Logger.getLogger(AuthenticationUtil.class);
    public static final String REQUEST_INTERRUPTED = "dspace.request.interrupted";
    public static final String REQUEST_RESUME = "dspace.request.resume";
    public static final String REQUEST_INTERRUPTED_HEADER = "dspace.request.interrupted.header";
    public static final String REQUEST_INTERRUPTED_MESSAGE = "dspace.request.interrupted.message";
    public static final String REQUEST_INTERRUPTED_CHARACTERS = "dspace.request.interrupted.characters";
    private static final String CURRENT_IP_ADDRESS = "dspace.user.ip";
    private static final String EFFECTIVE_USER_ID = "dspace.user.effective";
    private static final String AUTHENTICATED_USER_ID = "dspace.user.authenticated";
    protected static final AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    protected static final AuthenticationService authenticationService = AuthenticateServiceFactory.getInstance().getAuthenticationService();
    protected static final EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
    protected static final GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();

    public static Context authenticate(Map objectModel, String email, String password, String realm) throws SQLException {
        HttpServletRequest request = (HttpServletRequest)objectModel.get("httprequest");
        Context context = ContextUtil.obtainContext((Map)objectModel);
        int implicitStatus = authenticationService.authenticateImplicit(context, null, null, null, request);
        if (implicitStatus == 1) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"login", (String)"type=implicit"));
            AuthenticationUtil.logIn((Context)context, (HttpServletRequest)request, (EPerson)context.getCurrentUser());
        } else {
            int explicitStatus = authenticationService.authenticate(context, email, password, realm, request);
            if (explicitStatus == 1) {
                log.info((Object)LogManager.getHeader((Context)context, (String)"login", (String)"type=explicit"));
                AuthenticationUtil.logIn((Context)context, (HttpServletRequest)request, (EPerson)context.getCurrentUser());
            } else {
                log.info((Object)LogManager.getHeader((Context)context, (String)"failed_login", (String)("email=" + email + ", realm=" + realm + ", result=" + explicitStatus)));
            }
        }
        return context;
    }

    public static Context authenticateImplicit(Map objectModel) throws SQLException {
        HttpServletRequest request = (HttpServletRequest)objectModel.get("httprequest");
        Context context = ContextUtil.obtainContext((Map)objectModel);
        int implicitStatus = authenticationService.authenticateImplicit(context, null, null, null, request);
        if (implicitStatus == 1) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"login", (String)"type=implicit"));
            AuthenticationUtil.logIn((Context)context, (HttpServletRequest)request, (EPerson)context.getCurrentUser());
        }
        return context;
    }

    private static void logIn(Context context, HttpServletRequest request, EPerson eperson) throws SQLException {
        if (eperson == null) {
            return;
        }
        HttpSession session = request.getSession();
        context.setCurrentUser(eperson);
        if (!authorizeService.isAdmin(context) && !SystemwideAlerts.canUserStartSession()) {
            context.setCurrentUser(null);
            return;
        }
        List groups = authenticationService.getSpecialGroups(context, request);
        for (Group group : groups) {
            context.setSpecialGroup(group.getID());
        }
        session.setAttribute("dspace.user.ip", (Object)request.getRemoteAddr());
        session.setAttribute("dspace.user.effective", (Object)eperson.getID());
        session.setAttribute("dspace.user.authenticated", (Object)eperson.getID());
    }

    public static void logIn(Map objectModel, EPerson eperson) throws SQLException {
        HttpServletRequest request = (HttpServletRequest)objectModel.get("httprequest");
        Context context = ContextUtil.obtainContext((Map)objectModel);
        AuthenticationUtil.logIn((Context)context, (HttpServletRequest)request, (EPerson)eperson);
    }

    public static void resumeLogin(Context context, HttpServletRequest request) throws SQLException {
        HttpSession session = request.getSession(false);
        if (session != null) {
            UUID id = (UUID)session.getAttribute("dspace.user.effective");
            UUID realid = (UUID)session.getAttribute("dspace.user.authenticated");
            if (id != null) {
                boolean ipcheck = DSpaceServicesFactory.getInstance().getConfigurationService().getBooleanProperty("xmlui.session.ipcheck", true);
                String address = (String)session.getAttribute("dspace.user.ip");
                if (!ipcheck || address != null && address.equals(request.getRemoteAddr())) {
                    EPerson eperson = (EPerson)ePersonService.find(context, id);
                    context.setCurrentUser(eperson);
                    if (!authorizeService.isAdmin(context) && !SystemwideAlerts.canUserMaintainSession()) {
                        EPerson realEPerson = (EPerson)ePersonService.find(context, realid);
                        Group administrators = groupService.findByName(context, "Administrator");
                        if (!groupService.isDirectMember(administrators, realEPerson)) {
                            context.setCurrentUser(null);
                            return;
                        }
                    }
                    List groups = authenticationService.getSpecialGroups(context, request);
                    for (Group group : groups) {
                        context.setSpecialGroup(group.getID());
                    }
                } else {
                    log.warn((Object)LogManager.getHeader((Context)context, (String)"ip_mismatch", (String)("id=" + id + ", request ip=" + request.getRemoteAddr() + ", session ip=" + address)));
                }
            }
        }
    }

    public static void loginAs(Context context, HttpServletRequest request, EPerson loginAs) throws SQLException, AuthorizeException {
        if (!DSpaceServicesFactory.getInstance().getConfigurationService().getBooleanProperty("webui.user.assumelogin", false)) {
            return;
        }
        if (!authorizeService.isAdmin(context)) {
            throw new AuthorizeException("xmlui.utils.AuthenticationUtil.onlyAdmins");
        }
        HttpSession session = request.getSession(false);
        UUID authenticatedID = (UUID)session.getAttribute("dspace.user.authenticated");
        if (!context.getCurrentUser().getID().equals(authenticatedID)) {
            throw new AuthorizeException("xmlui.utils.AuthenticationUtil.onlyAuthenticatedAdmins");
        }
        if (loginAs == null) {
            return;
        }
        Group administrators = groupService.findByName(context, "Administrator");
        if (groupService.isDirectMember(administrators, loginAs)) {
            throw new AuthorizeException("xmlui.utils.AuthenticationUtil.notAnotherAdmin");
        }
        context.setCurrentUser(loginAs);
        List groups = authenticationService.getSpecialGroups(context, request);
        for (Group group : groups) {
            context.setSpecialGroup(group.getID());
        }
        session.setAttribute("dspace.user.effective", (Object)loginAs.getID());
    }

    public static void logOut(Context context, HttpServletRequest request) throws SQLException {
        UUID authenticatedID;
        UUID effectiveID;
        HttpSession session = request.getSession();
        if (session.getAttribute("dspace.user.effective") != null && session.getAttribute("dspace.user.authenticated") != null && !(effectiveID = (UUID)session.getAttribute("dspace.user.effective")).equals(authenticatedID = (UUID)session.getAttribute("dspace.user.authenticated"))) {
            EPerson authenticatedUser = (EPerson)ePersonService.find(context, authenticatedID);
            context.setCurrentUser(authenticatedUser);
            session.setAttribute("dspace.user.effective", (Object)authenticatedID);
            return;
        }
        context.setCurrentUser(null);
        session.removeAttribute("dspace.user.effective");
        session.removeAttribute("dspace.user.authenticated");
        session.removeAttribute("dspace.user.ip");
    }

    public static boolean canSelfRegister(Map objectModel, String email) throws SQLException {
        HttpServletRequest request = (HttpServletRequest)objectModel.get("httprequest");
        Context context = ContextUtil.obtainContext((Map)objectModel);
        if (SystemwideAlerts.canUserStartSession()) {
            return authenticationService.canSelfRegister(context, request, email);
        }
        return false;
    }

    public static boolean allowSetPassword(Map objectModel, String email) throws SQLException {
        HttpServletRequest request = (HttpServletRequest)objectModel.get("httprequest");
        Context context = ContextUtil.obtainContext((Map)objectModel);
        return authenticationService.allowSetPassword(context, request, email);
    }

    public static EPerson createNewEperson(Map objectModel, String email) throws SQLException, AuthorizeException {
        HttpServletRequest request = (HttpServletRequest)objectModel.get("httprequest");
        Context context = ContextUtil.obtainContext((Map)objectModel);
        context.turnOffAuthorisationSystem();
        EPerson eperson = ePersonService.create(context);
        eperson.setEmail(email);
        eperson.setCanLogIn(true);
        eperson.setSelfRegistered(true);
        ePersonService.update(context, (DSpaceObject)eperson);
        context.restoreAuthSystemState();
        authenticationService.initEPerson(context, request, eperson);
        return eperson;
    }

    public static boolean isInterupptedRequest(Map objectModel) {
        HttpServletRequest request = (HttpServletRequest)objectModel.get("httprequest");
        HttpSession session = request.getSession();
        Object interruptedObject = session.getAttribute("dspace.request.interrupted");
        return interruptedObject instanceof RequestInfo;
    }

    public static void interruptRequest(Map objectModel, String header, String message, String characters) {
        HttpServletRequest request = (HttpServletRequest)objectModel.get("httprequest");
        HttpSession session = request.getSession();
        RequestInfo interruptedRequest = new RequestInfo(request);
        session.setAttribute("dspace.request.interrupted", (Object)interruptedRequest);
        session.setAttribute("dspace.request.resume", null);
        session.setAttribute("dspace.request.interrupted.header", (Object)header);
        session.setAttribute("dspace.request.interrupted.message", (Object)message);
        session.setAttribute("dspace.request.interrupted.characters", (Object)characters);
    }

    public static String resumeInterruptedRequest(Map objectModel) {
        HttpServletRequest request = (HttpServletRequest)objectModel.get("httprequest");
        HttpSession session = request.getSession();
        session.setAttribute("dspace.request.interrupted.header", null);
        session.setAttribute("dspace.request.interrupted.message", null);
        session.setAttribute("dspace.request.interrupted.characters", null);
        Object interruptedObject = session.getAttribute("dspace.request.interrupted");
        if (interruptedObject instanceof RequestInfo) {
            RequestInfo interruptedRequest = (RequestInfo)interruptedObject;
            session.setAttribute("dspace.request.interrupted", null);
            session.setAttribute("dspace.request.resume", (Object)interruptedRequest);
            if (interruptedRequest.getServletPath() == null || interruptedRequest.getServletPath().length() == 0) {
                return interruptedRequest.getActualPath();
            }
            return interruptedRequest.getServletPath();
        }
        return null;
    }

    public static HttpServletRequest resumeRequest(HttpServletRequest realHttpRequest) {
        HttpSession session = realHttpRequest.getSession();
        Object object = session.getAttribute("dspace.request.resume");
        if (object instanceof RequestInfo) {
            RequestInfo interruptedRequest = (RequestInfo)object;
            String interruptedServletPath = interruptedRequest.getServletPath();
            String realServletPath = realHttpRequest.getServletPath();
            if (realServletPath != null && realServletPath.equals(interruptedServletPath)) {
                session.setAttribute("dspace.request.interrupted", null);
                session.setAttribute("dspace.request.resume", null);
                return interruptedRequest.wrapRequest(realHttpRequest);
            }
        }
        return realHttpRequest;
    }

    public static boolean isLoggedIn(HttpServletRequest request) {
        return null != request.getSession().getAttribute("dspace.user.effective");
    }
}

