/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.wing;

import java.util.Stack;
import org.apache.cocoon.transformation.AbstractTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.ObjectManager;
import org.dspace.app.xmlui.wing.WingContext;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.WingTransformer;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Options;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.UserMeta;
import org.dspace.app.xmlui.wing.element.WingDocument;
import org.dspace.app.xmlui.wing.element.WingMergeableElement;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.NamespaceSupport;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class AbstractWingTransformer
extends AbstractTransformer
implements WingTransformer {
    private boolean needNewNamespaceContext = true;
    private NamespaceSupport namespaces;
    private WingDocument feederDocument;
    private WingContext wingContext;
    private Stack<WingMergeableElement> stack;

    public void setupWing() throws WingException {
        this.wingContext = new WingContext();
        this.wingContext.setLogger(this.getLogger());
        this.wingContext.setComponentName(this.getComponentName());
        this.wingContext.setObjectManager(this.getObjectManager());
        this.feederDocument = this.createWingDocument(this.wingContext);
        this.stack = new Stack();
    }

    public void startDocument() throws SAXException {
        this.needNewNamespaceContext = true;
        this.namespaces = new NamespaceSupport();
        super.startDocument();
    }

    public void endDocument() throws SAXException {
        this.wingContext.dispose();
        super.endDocument();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.needNewNamespaceContext) {
            this.namespaces.pushContext();
            this.needNewNamespaceContext = false;
        }
        this.namespaces.declarePrefix(prefix, uri);
        super.startPrefixMapping(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        if (!this.needNewNamespaceContext) {
            this.namespaces.popContext();
            this.needNewNamespaceContext = true;
        }
        super.endPrefixMapping(prefix);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
        this.needNewNamespaceContext = true;
        try {
            if (this.stack == null) {
                throw new WingException("Stack not initialized.");
            }
            if (this.stack.isEmpty()) {
                if (!this.feederDocument.mergeEqual(namespaceURI, localName, qName, attributes)) throw new WingException("Attempting to merge DRI documents but the source document is not compatible with the feeder document.");
                attributes = this.feederDocument.merge(attributes);
                this.stack.push(this.feederDocument);
            } else if (this.stack.size() > 0) {
                WingMergeableElement peek = (WingMergeableElement)this.stack.peek();
                WingMergeableElement child = null;
                if (peek != null) {
                    child = peek.mergeChild(namespaceURI, localName, qName, attributes);
                }
                if (child instanceof UserMeta) {
                    this.addUserMeta((UserMeta)child);
                } else if (child instanceof PageMeta) {
                    this.addPageMeta((PageMeta)child);
                } else if (child instanceof Body) {
                    this.addBody((Body)child);
                } else if (child instanceof Options) {
                    this.addOptions((Options)child);
                }
                if (child != null) {
                    attributes = child.merge(attributes);
                }
                this.stack.push(child);
            }
            super.startElement(namespaceURI, localName, qName, attributes);
            return;
        }
        catch (SAXException saxe) {
            throw saxe;
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        try {
            WingMergeableElement poped;
            if (this.stack.size() > 0 && (poped = (WingMergeableElement)this.stack.pop()) != null) {
                poped.toSAX(this.contentHandler, this.lexicalHandler, this.namespaces);
                poped.dispose();
            }
            super.endElement(namespaceURI, localName, qName);
        }
        catch (SAXException saxe) {
            throw saxe;
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void handleException(Exception e) throws SAXException {
        throw new SAXException("An error was encountered while processing the Wing based component: " + this.getClass().getName(), e);
    }

    protected WingDocument createWingDocument(WingContext wingContext) throws WingException {
        return new WingDocument(wingContext);
    }

    public void addBody(Body body) throws Exception {
    }

    public void addOptions(Options options) throws Exception {
    }

    public void addUserMeta(UserMeta userMeta) throws Exception {
    }

    public void addPageMeta(PageMeta pageMeta) throws Exception {
    }

    public ObjectManager getObjectManager() {
        return null;
    }

    public String getComponentName() {
        return this.getClass().getName();
    }

    public static String getDefaultMessageCatalogue() {
        return "default";
    }

    public static Message message(String key) {
        return AbstractWingTransformer.message((String)AbstractWingTransformer.getDefaultMessageCatalogue(), (String)key);
    }

    public static Message message(String catalogue, String key) {
        return new Message(catalogue, key);
    }

    public void recycle() {
        this.namespaces = null;
        this.feederDocument = null;
        this.wingContext = null;
        this.stack = null;
        super.recycle();
    }

    public void dispose() {
        this.namespaces = null;
        this.feederDocument = null;
        this.wingContext = null;
        this.stack = null;
    }
}

