/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.artifactbrowser;

import java.net.InetAddress;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.acting.AbstractAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.I18nUtil;
import org.dspace.eperson.EPerson;
import org.dspace.services.factory.DSpaceServicesFactory;

public class SendFeedbackAction
extends AbstractAction {
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String page = request.getParameter("page");
        String address = request.getParameter("email");
        String agent = request.getHeader("User-Agent");
        String session = request.getSession().getId();
        String comments = request.getParameter("comments");
        String fromPage = request.getHeader("Referer");
        String host = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("dspace.hostname");
        String basicHost = "";
        if ("localhost".equals(host) || "127.0.0.1".equals(host) || host.equals(InetAddress.getLocalHost().getHostAddress())) {
            basicHost = host;
        } else {
            int lastDot = host.lastIndexOf(46);
            if (host.substring(0, lastDot).contains(".")) {
                basicHost = host.substring(host.substring(0, lastDot).lastIndexOf(46));
            }
        }
        if (fromPage == null || !fromPage.contains(basicHost) && !this.isValidReferral(fromPage)) {
            throw new AuthorizeException(I18nUtil.getMessage((String)"feedback.error.forbidden"));
        }
        Context context = ContextUtil.obtainContext((Map)objectModel);
        EPerson loggedin = context.getCurrentUser();
        String eperson = null;
        if (loggedin != null) {
            eperson = loggedin.getEmail();
        }
        if (page == null || page.equals("")) {
            page = fromPage;
        }
        if (address == null || address.equals("") || comments == null || comments.equals("")) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("page", page);
            if (address == null || address.equals("")) {
                map.put("email", eperson);
            } else {
                map.put("email", address);
            }
            map.put("comments", comments);
            return map;
        }
        Email email = Email.getEmail((String)I18nUtil.getEmailFilename((Locale)context.getCurrentLocale(), (String)"feedback"));
        email.addRecipient(DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("feedback.recipient"));
        email.addArgument((Object)new Date());
        email.addArgument((Object)address);
        email.addArgument((Object)eperson);
        email.addArgument((Object)page);
        email.addArgument((Object)agent);
        email.addArgument((Object)session);
        email.addArgument((Object)comments);
        email.setReplyTo(address);
        email.send();
        return null;
    }

    private boolean isValidReferral(String fromPage) {
        String[] allowedReferrers = DSpaceServicesFactory.getInstance().getConfigurationService().getArrayProperty("mail.allowed.referrers");
        if (allowedReferrers != null && fromPage != null) {
            for (String allowedReferrer : allowedReferrers) {
                if (!fromPage.contains(allowedReferrer)) continue;
                return true;
            }
        }
        return false;
    }
}

