/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.versioning;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Cell;
import org.dspace.app.xmlui.wing.element.CheckBox;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.DCDate;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.eperson.EPerson;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.versioning.Version;
import org.dspace.versioning.VersionHistory;
import org.dspace.versioning.factory.VersionServiceFactory;
import org.dspace.versioning.service.VersionHistoryService;
import org.dspace.versioning.service.VersioningService;
import org.dspace.workflow.WorkflowItem;
import org.dspace.workflow.WorkflowItemService;
import org.dspace.workflow.factory.WorkflowServiceFactory;

public class VersionHistoryForm
extends AbstractDSpaceTransformer {
    private static final Message T_head2 = VersionHistoryForm.message((String)"xmlui.aspect.versioning.VersionHistoryForm.head2");
    private static final Message T_column1 = VersionHistoryForm.message((String)"xmlui.aspect.versioning.VersionHistoryForm.column1");
    private static final Message T_column2 = VersionHistoryForm.message((String)"xmlui.aspect.versioning.VersionHistoryForm.column2");
    private static final Message T_column3 = VersionHistoryForm.message((String)"xmlui.aspect.versioning.VersionHistoryForm.column3");
    private static final Message T_column4 = VersionHistoryForm.message((String)"xmlui.aspect.versioning.VersionHistoryForm.column4");
    private static final Message T_column5 = VersionHistoryForm.message((String)"xmlui.aspect.versioning.VersionHistoryForm.column5");
    private static final Message T_column6 = VersionHistoryForm.message((String)"xmlui.aspect.versioning.VersionHistoryForm.column6");
    private static final Message T_submit_update = VersionHistoryForm.message((String)"xmlui.aspect.versioning.VersionHistoryForm.update");
    private static final Message T_submit_cancel = VersionHistoryForm.message((String)"xmlui.aspect.versioning.VersionHistoryForm.return");
    private static final Message T_submit_delete = VersionHistoryForm.message((String)"xmlui.aspect.versioning.VersionHistoryForm.delete");
    private static final Message T_legend = VersionHistoryForm.message((String)"xmlui.aspect.versioning.VersionHistoryForm.legend");
    protected AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    protected VersioningService versioningService = VersionServiceFactory.getInstance().getVersionService();
    protected VersionHistoryService versionHistoryService = VersionServiceFactory.getInstance().getVersionHistoryService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
    protected WorkflowItemService workflowItemService = WorkflowServiceFactory.getInstance().getWorkflowItemService();

    public void addBody(Body body) throws WingException, SQLException, AuthorizeException {
        VersionHistory versionHistory;
        boolean isItemView = this.parameters.getParameter("itemID", null) == null;
        Item item = this.getItem();
        if (item == null || !this.authorizeService.isAdmin(this.context, (DSpaceObject)item.getOwningCollection())) {
            if (isItemView) {
                if (((Boolean)DSpaceServicesFactory.getInstance().getConfigurationService().getPropertyAsType("versioning.item.history.view.admin", (Object)false)).booleanValue()) {
                    return;
                }
            } else {
                throw new AuthorizeException();
            }
        }
        if ((versionHistory = this.versionHistoryService.findByItem(this.context, item)) != null) {
            Division main = this.createMain(body);
            this.createTable(main, versionHistory, isItemView, item);
            if (!isItemView) {
                this.addButtons(main, versionHistory);
                main.addHidden("versioning-continue").setValue(this.knot.getId());
            }
            Para note = main.addPara();
            note.addContent(T_legend);
        }
    }

    private Item getItem() throws WingException {
        try {
            if (this.parameters.getParameter("itemID", null) == null) {
                DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
                if (!(dso instanceof Item)) {
                    return null;
                }
                return (Item)dso;
            }
            return (Item)this.itemService.find(this.context, UUID.fromString(this.parameters.getParameter("itemID", null)));
        }
        catch (SQLException e) {
            throw new WingException((Throwable)e);
        }
    }

    private Division createMain(Body body) throws WingException {
        Division main = body.addInteractiveDivision("view-version-history", this.contextPath + "/item/versionhistory", "post", "view version history");
        main.setHead(T_head2);
        return main;
    }

    private void createTable(Division main, VersionHistory history, boolean isItemView, Item item) throws WingException, SQLException {
        Boolean isVisible = DSpaceServicesFactory.getInstance().getConfigurationService().getBooleanProperty("versioning.item.history.include.submitter", Boolean.FALSE.booleanValue());
        boolean isAdmin = this.authorizeService.isAdmin(this.context, (DSpaceObject)item.getOwningCollection());
        if (isAdmin) {
            isVisible = true;
        }
        Table table = main.addTable("versionhistory", 1, 1);
        Row header = table.addRow("header");
        if (!isItemView) {
            header.addCell().addContent("");
        }
        header.addCell().addContent(T_column1);
        header.addCell().addContent(T_column2);
        if (isVisible.booleanValue()) {
            header.addCell().addContent(T_column3);
        }
        header.addCell().addContent(T_column4);
        header.addCell().addContent(T_column5);
        if (!isItemView) {
            header.addCell().addContent(T_column6);
        }
        if (history != null) {
            for (Version version : this.versioningService.getVersionsByHistory(this.context, history)) {
                if (this.isItemInSubmission(version.getItem())) continue;
                Row row = table.addRow(null, "data", "metadata-value");
                if (!isItemView) {
                    CheckBox remove = row.addCell().addCheckBox("remove");
                    remove.setLabel("remove");
                    remove.addOption(version.getID().intValue());
                }
                row.addCell().addContent(version.getVersionNumber());
                this.addItemIdentifier(row.addCell(), item, version);
                if (isVisible.booleanValue()) {
                    EPerson editor = version.getEPerson();
                    row.addCell().addXref("mailto:" + editor.getEmail(), editor.getFullName());
                }
                row.addCell().addContent(new DCDate(version.getVersionDate()).toString());
                row.addCell().addContent(version.getSummary());
                if (isItemView) continue;
                row.addCell().addXref(this.contextPath + "/item/versionhistory?versioning-continue=" + this.knot.getId() + "&versionID=" + version.getID() + "&itemID=" + version.getItem().getID() + "&submit_update", T_submit_update);
            }
        }
    }

    private boolean isItemInSubmission(Item item) throws SQLException {
        WorkspaceItem workspaceItem = this.workspaceItemService.findByItem(this.context, item);
        WorkflowItem workflowItem = this.workflowItemService.findByItem(this.context, item);
        return workspaceItem != null || workflowItem != null;
    }

    private void addItemIdentifier(Cell cell, Item item, Version version) throws WingException {
        String itemHandle = version.getItem().getHandle();
        List identifiers = this.itemService.getMetadata((DSpaceObject)version.getItem(), "dc", "identifier", null, "*");
        String itemIdentifier = null;
        if (identifiers != null && identifiers.size() > 0) {
            itemIdentifier = ((MetadataValue)identifiers.get(0)).getValue();
        }
        if (itemIdentifier != null) {
            cell.addXref(this.contextPath + "/resource/" + itemIdentifier, itemIdentifier);
        } else {
            cell.addXref(this.contextPath + "/handle/" + itemHandle, itemHandle);
        }
        if (item.equals((Object)version.getItem())) {
            cell.addContent("*");
        }
    }

    private void addButtons(Division main, VersionHistory history) throws WingException, SQLException {
        Para actions = main.addPara();
        if (history != null && this.versioningService.getVersionsByHistory(this.context, history).size() > 0) {
            actions.addButton("submit_delete").setValue(T_submit_delete);
        }
        actions.addButton("submit_cancel").setValue(T_submit_cancel);
    }
}

