/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.xmlworkflow;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.DSpaceValidity;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.Options;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.DSpaceObject;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.GroupService;
import org.xml.sax.SAXException;

public class Navigation
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    private static final Message T_xmlworkflow_overview = Navigation.message((String)"xmlui.XMLWorkflow.Navigation.xmlworkflow_overview");
    private SourceValidity validity;
    protected AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    protected GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();

    public Serializable getKey() {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        if (request.getParameter("login_email") != null || request.getParameter("login_password") != null || request.getParameter("login_realm") != null) {
            return "0";
        }
        if (this.context.getCurrentUser() == null) {
            return Long.valueOf(HashUtil.hash((String)"anonymous"));
        }
        return Long.valueOf(HashUtil.hash((String)this.context.getCurrentUser().getEmail()));
    }

    public SourceValidity getValidity() {
        if (this.validity == null) {
            if (this.context.getCurrentUser() != null) {
                try {
                    DSpaceValidity validity = new DSpaceValidity();
                    validity.add(this.context, (DSpaceObject)this.eperson);
                    Set groups = this.groupService.allMemberGroupsSet(this.context, this.eperson);
                    for (Group group : groups) {
                        validity.add(this.context, (DSpaceObject)group);
                    }
                    this.validity = validity.complete();
                }
                catch (SQLException sQLException) {}
            } else {
                this.validity = NOPValidity.SHARED_INSTANCE;
            }
        }
        return this.validity;
    }

    public void addOptions(Options options) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        List admin = options.addList("administrative");
        boolean isSystemAdmin = this.authorizeService.isAdmin(this.context);
        if (isSystemAdmin) {
            admin.addItemXref(this.contextPath + "/admin/xmlworkflowoverview", T_xmlworkflow_overview);
        }
    }

    public void recycle() {
        this.validity = null;
        super.recycle();
    }
}

