/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.utils;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.utils.AuthenticationUtil;
import org.dspace.authenticate.factory.AuthenticateServiceFactory;
import org.dspace.authenticate.service.AuthenticationService;
import org.dspace.core.Context;
import org.dspace.eperson.Group;
import org.dspace.services.factory.DSpaceServicesFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ContextUtil {
    private static Boolean useProxies;
    private static final Logger log;
    public static final String DSPACE_CONTEXT = "dspace.context";
    protected static final AuthenticationService authenticationService;

    public static Context obtainContext(Map objectModel) throws SQLException {
        return ContextUtil.obtainContext((HttpServletRequest)ObjectModelHelper.getRequest((Map)objectModel));
    }

    public static boolean isContextAvailable(Map objectModel) {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        Object object = request.getAttribute("dspace.context");
        return object instanceof Context;
    }

    public static Context obtainContext(HttpServletRequest request) throws SQLException {
        Context context = (Context)request.getAttribute("dspace.context");
        if (context == null) {
            context = new Context();
            context.setExtraLogInfo("session_id=" + request.getSession().getId());
            AuthenticationUtil.resumeLogin((Context)context, (HttpServletRequest)request);
            List groups = authenticationService.getSpecialGroups(context, request);
            for (int i = 0; i < groups.size(); ++i) {
                context.setSpecialGroup(((Group)groups.get(i)).getID());
                log.debug((Object)("Adding Special Group id=" + String.valueOf(((Group)groups.get(i)).getID())));
            }
            String ip = request.getRemoteAddr();
            if (useProxies == null) {
                useProxies = DSpaceServicesFactory.getInstance().getConfigurationService().getBooleanProperty("useProxies", false);
            }
            if (useProxies.booleanValue() && request.getHeader("X-Forwarded-For") != null) {
                for (String xfip : request.getHeader("X-Forwarded-For").split(",")) {
                    if (request.getHeader("X-Forwarded-For").contains(ip)) continue;
                    ip = xfip.trim();
                }
            }
            context.setExtraLogInfo("session_id=" + request.getSession().getId() + ":ip_addr=" + ip);
            request.setAttribute("dspace.context", (Object)context);
        }
        return context;
    }

    public static void completeContext(HttpServletRequest request) throws ServletException {
        Context context = (Context)request.getAttribute("dspace.context");
        if (context != null && context.isValid()) {
            try {
                context.complete();
            }
            catch (SQLException e) {
                throw new ServletException((Throwable)e);
            }
        }
    }

    public static void abortContext(HttpServletRequest request) {
        Context context = (Context)request.getAttribute("dspace.context");
        if (context != null && context.isValid()) {
            context.abort();
        }
    }

    static {
        log = Logger.getLogger(ContextUtil.class);
        authenticationService = AuthenticateServiceFactory.getInstance().getAuthenticationService();
    }
}

