/*
 * Decompiled with CFR 0.152.
 */
package net.cnri.simplexml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.cnri.simplexml.XUtil;

public class XTag {
    private String name;
    private Object value;
    private Vector subTags = null;
    private Hashtable attributes = null;
    private boolean suppressNewLine = false;

    public XTag(String name, Object value) {
        this.name = name.trim();
        if (value != null && value instanceof String) {
            value = ((String)value).trim();
        }
        this.value = value;
    }

    public XTag(String name) {
        this.name = name;
        this.value = null;
    }

    public boolean isContainer() {
        return this.value == null;
    }

    public void addSubTag(XTag value) {
        this.value = null;
        if (this.subTags == null) {
            this.subTags = new Vector();
        }
        this.subTags.addElement(value);
    }

    public int getSubTagCount() {
        if (this.subTags == null) {
            return 0;
        }
        return this.subTags.size();
    }

    public XTag getSubTag(int i) {
        if (this.subTags == null) {
            return null;
        }
        if (i < 0 || i >= this.subTags.size()) {
            return null;
        }
        return (XTag)this.subTags.elementAt(i);
    }

    public XTag getSubTag(String tagName) {
        if (this.subTags == null) {
            return null;
        }
        for (int i = 0; i < this.subTags.size(); ++i) {
            XTag subtag = (XTag)this.subTags.elementAt(i);
            if (!subtag.getName().equals(tagName)) continue;
            return subtag;
        }
        return null;
    }

    public XTag removeSubTag(int index) {
        if (index < 0 || index >= this.subTags.size()) {
            return null;
        }
        XTag rmTag = this.getSubTag(index);
        this.subTags.removeElementAt(index);
        return rmTag;
    }

    public boolean hasSubTag(String tagName) {
        if (this.subTags == null) {
            return false;
        }
        for (int i = 0; i < this.subTags.size(); ++i) {
            XTag subtag = (XTag)this.subTags.elementAt(i);
            if (!subtag.getName().equals(tagName)) continue;
            return true;
        }
        return false;
    }

    public void setSuppressNewLine(boolean suppressNewLine) {
        this.suppressNewLine = suppressNewLine;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public String getStrValue() {
        return String.valueOf(this.getValue());
    }

    public int getIntValue() throws Exception {
        return Integer.parseInt(this.getStrValue().trim());
    }

    public long getLongValue() throws Exception {
        return Long.parseLong(this.getStrValue().trim());
    }

    public URL getUrlValue() throws Exception {
        return new URL(this.getStrValue());
    }

    public boolean getBoolValue() {
        return this.getStrValue().toUpperCase().trim().startsWith("Y");
    }

    public boolean getBoolSubTag(String tagName, boolean defaultVal) {
        XTag subtag = this.getSubTag(tagName);
        if (subtag == null) {
            return defaultVal;
        }
        try {
            return subtag.getBoolValue();
        }
        catch (Exception e) {
            return defaultVal;
        }
    }

    public String getStrSubTag(String tagName, String defaultVal) {
        XTag subtag = this.getSubTag(tagName);
        if (subtag == null) {
            return defaultVal;
        }
        return subtag.getStrValue();
    }

    public int getIntSubTag(String tagName, int defaultVal) {
        XTag subtag = this.getSubTag(tagName);
        if (subtag == null) {
            return defaultVal;
        }
        try {
            return subtag.getIntValue();
        }
        catch (Exception e) {
            return defaultVal;
        }
    }

    public long getLongSubTag(String tagName, long defaultVal) {
        XTag subtag = this.getSubTag(tagName);
        if (subtag == null) {
            return defaultVal;
        }
        try {
            return subtag.getLongValue();
        }
        catch (Exception e) {
            return defaultVal;
        }
    }

    public URL getUrlSubTag(String tagName, URL defaultVal) {
        XTag subtag = this.getSubTag(tagName);
        if (subtag == null) {
            return defaultVal;
        }
        try {
            return subtag.getUrlValue();
        }
        catch (Exception e) {
            return defaultVal;
        }
    }

    public String[] getStrListSubTag(String tagName) {
        if (this.subTags == null) {
            return new String[0];
        }
        Vector<String> strVect = new Vector<String>();
        for (int i = 0; i < this.subTags.size(); ++i) {
            XTag subtag = (XTag)this.subTags.elementAt(i);
            if (!subtag.getName().equals(tagName)) continue;
            strVect.addElement(subtag.getStrValue());
        }
        return XUtil.vectorToStringArray(strVect);
    }

    public void setValue(String value) {
        this.value = value;
    }

    void setAttributes(Hashtable newAttributes) {
        this.attributes = newAttributes;
    }

    public void setAttribute(String name, String val) {
        if (this.attributes == null) {
            this.attributes = new Hashtable();
        }
        this.attributes.put(name, val);
    }

    public void setAttribute(String name, boolean val) {
        if (this.attributes == null) {
            this.attributes = new Hashtable();
        }
        this.attributes.put(name, val ? "yes" : "no");
    }

    public void setAttribute(String name, int val) {
        if (this.attributes == null) {
            this.attributes = new Hashtable();
        }
        this.attributes.put(name, String.valueOf(val));
    }

    public String getAttribute(String name, String defaultVal) {
        String val = this.getAttribute(name);
        if (val == null) {
            return defaultVal;
        }
        return val;
    }

    public String getAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return (String)this.attributes.get(name);
    }

    public boolean getBoolAttribute(String name, boolean defaultVal) {
        String val = this.getAttribute(name);
        if (val == null) {
            return defaultVal;
        }
        if ((val = val.toLowerCase()).equals("yes") || val.equals("true") || val.equals("1")) {
            return true;
        }
        if (val.equals("no") || val.equals("false") || val.equals("0")) {
            return false;
        }
        return defaultVal;
    }

    public String getStrAttribute(String tagName, String defaultVal) {
        return this.getAttribute(tagName, defaultVal);
    }

    public int getIntAttribute(String name, int defaultVal) {
        String val = this.getAttribute(name);
        if (val == null) {
            return defaultVal;
        }
        try {
            return Integer.parseInt(val.trim());
        }
        catch (Exception e) {
            return defaultVal;
        }
    }

    public long getLongAttribute(String name, long defaultVal) {
        String val = this.getAttribute(name);
        if (val == null) {
            return defaultVal;
        }
        try {
            return Long.parseLong(val.trim());
        }
        catch (Exception e) {
            return defaultVal;
        }
    }

    public void write(OutputStream out) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(out, "UTF8");
        this.write(w);
        w.flush();
    }

    public void write(Writer out) throws IOException {
        this.write(out, true, "");
    }

    public void write(Writer out, boolean pretty, String prefix) throws IOException {
        Object value = this.value;
        String valueStr = value == null ? null : String.valueOf(value);
        boolean emptyValue = this.getSubTagCount() <= 0 && (valueStr == null || valueStr.length() <= 0);
        StringBuffer sb = new StringBuffer();
        out.write("<");
        String tagName = XUtil.encodeString(this.name);
        out.write(tagName);
        Hashtable atts = this.attributes;
        if (atts != null) {
            Enumeration en = atts.keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                String val = (String)atts.get(key);
                out.write(" \"");
                out.write(XUtil.encodeString(key));
                out.write("\"=\"");
                out.write(XUtil.encodeString(val));
                out.write("\"");
            }
        }
        if (emptyValue) {
            out.write("/");
        }
        out.write(">");
        if (!emptyValue && this.getSubTagCount() <= 0) {
            out.write(XUtil.encodeString(valueStr));
        } else if (this.getSubTagCount() > 0) {
            if (pretty) {
                out.write("\n");
            }
            for (int i = 0; i < this.subTags.size(); ++i) {
                ((XTag)this.subTags.elementAt(i)).write(out, pretty, pretty ? prefix + "  " : "");
            }
        }
        if (!emptyValue) {
            out.write("</");
            out.write(tagName);
            out.write(">");
        }
        if (pretty && !this.suppressNewLine) {
            out.write("\n");
        }
    }

    public String toString() {
        StringWriter w = new StringWriter();
        try {
            this.write(w, true, "");
        }
        catch (Exception e) {
            System.err.println("Error encoding tags: " + e);
            e.printStackTrace(System.err);
        }
        return w.toString();
    }
}

