/*
 * Decompiled with CFR 0.152.
 */
package net.cnri.test;

import net.cnri.test.Testable;
import net.cnri.util.StreamTable;

public class Main {
    private static Testable testable = null;

    private static final void printUsage() {
        System.err.println("usage: java net.cnri.iptorepotest.Main <testerclass> <numthreads>");
    }

    public static void main(String[] argv) {
        int i;
        if (argv.length > 0) {
            try {
                testable = (Testable)Class.forName(argv[0]).newInstance();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (argv.length != 2) {
            Main.printUsage();
            if (testable != null) {
                System.out.println(testable.getConfigDescription());
            }
            System.exit(1);
        }
        if (testable == null) {
            System.err.println("Unable to locate test class: " + argv[0]);
            System.exit(1);
        }
        int numThreads = 1;
        try {
            numThreads = Integer.parseInt(argv[1]);
        }
        catch (Exception e) {
            System.err.println("Invalid number of threads: " + argv[1]);
            Main.printUsage();
            System.exit(1);
        }
        System.out.println("Reading configuration file from stdin...");
        StreamTable config = new StreamTable();
        try {
            config.readFrom(System.in);
        }
        catch (Exception e) {
            System.err.println("Error reading configuration file: " + e);
            System.exit(1);
        }
        System.out.println("Initializing tester...");
        try {
            testable.initialize(config);
        }
        catch (Exception e) {
            System.err.println("Error initializing tester: " + e);
            e.printStackTrace(System.err);
            System.exit(1);
        }
        System.out.println("Spawning threads...");
        Thread[] testers = new Thread[numThreads];
        for (int i2 = 0; i2 < numThreads; ++i2) {
            testers[i2] = new TesterThread();
        }
        System.out.println("Running " + numThreads + " parallel tests...");
        long startTime = System.currentTimeMillis();
        for (i = 0; i < numThreads; ++i) {
            testers[i].start();
        }
        for (i = 0; i < numThreads; ++i) {
            try {
                testers[i].join();
                continue;
            }
            catch (Exception e) {
                System.err.println("Error merging tester thread: " + e);
                System.err.println("Test results may be skewed or incomplete");
                e.printStackTrace(System.err);
            }
        }
        long totalTime = System.currentTimeMillis() - startTime;
        System.out.println("Total time: " + totalTime + " ms");
        testable.processResults();
    }

    private static class TesterThread
    extends Thread {
        private TesterThread() {
        }

        public void run() {
            try {
                testable.runTests();
            }
            catch (Exception e) {
                System.err.println("Error running test: " + e);
                e.printStackTrace(System.err);
            }
        }
    }
}

