/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.gui.jutil;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import net.handle.apps.gui.jutil.FileOpt;
import net.handle.apps.gui.jutil.InfoPanel;
import net.handle.apps.gui.jutil.MyButton;

public class BrowsePanel
extends JPanel
implements ActionListener {
    protected JTextField fileField;
    protected MyButton browseButton;
    protected static String pathStr = "";
    protected String[] exts = null;
    protected boolean saveFlag;

    public BrowsePanel(String title, String path, String filename, String[] exts, boolean saveFlag) {
        this.exts = exts;
        this.saveFlag = saveFlag;
        this.fileField = new JTextField("", 25);
        File f = new File(path);
        if (f.exists()) {
            pathStr = f.getAbsolutePath();
        }
        this.fileField.setText(pathStr + filename);
        this.fileField.setToolTipText("Set the path and name to save information");
        this.browseButton = new MyButton("Browse", " find the path to save file");
        this.browseButton.addActionListener(this);
        this.add(new JLabel(title, 4));
        this.add(this.fileField);
        this.add(this.browseButton);
    }

    public BrowsePanel(String title, File path, String filename, String[] exts, boolean saveFlag) {
        this.exts = exts;
        this.saveFlag = saveFlag;
        this.fileField = new JTextField("", 25);
        if (path != null) {
            pathStr = path.getAbsolutePath();
        }
        this.fileField.setText(pathStr + filename);
        this.fileField.setToolTipText("Set the path and name to save information");
        this.browseButton = new MyButton("Browse", " find the path to save file");
        this.browseButton.addActionListener(this);
        boolean x = false;
        boolean y = false;
        this.add(new JLabel(title, 4));
        this.add(this.fileField);
        this.add(this.browseButton);
    }

    public BrowsePanel() {
        this("filepath:", pathStr, "", null, false);
    }

    public BrowsePanel(String title, boolean flag) {
        this(title, pathStr, "", null, flag);
    }

    public BrowsePanel(String[] exts, boolean flag) {
        this("filepath:", pathStr, "", exts, flag);
    }

    public void actionPerformed(ActionEvent ae) {
        String choice = ae.getActionCommand();
        if (choice.equals("Browse")) {
            this.browseDir();
        } else {
            System.err.println("Error input");
        }
    }

    public void setBrowseEnabled(boolean enable) {
        this.fileField.setEditable(enable);
        this.browseButton.setEnabled(enable);
        if (!enable) {
            this.fileField.setText("");
        }
        this.validate();
    }

    public boolean getReadFile(File[] files) {
        String fstr = this.fileField.getText().trim();
        files[0] = null;
        try {
            File file = new File(fstr);
            if (!file.exists() || !file.canRead()) {
                this.warn("File can not read, reset");
                return false;
            }
            files[0] = file;
            pathStr = FileOpt.getParent(file).getAbsolutePath();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            this.warn("File can not read, reset");
            return false;
        }
    }

    public boolean getWriteFile(File[] files) {
        String fstr = this.fileField.getText().trim();
        File file = new File(fstr);
        files[0] = null;
        if (file.exists()) {
            if (file.isDirectory()) {
                this.warn("File is Directory, cannot write, reset");
                return false;
            }
            if (file.isFile()) {
                if (0 == JOptionPane.showConfirmDialog(this, "File " + fstr + " already exists. Do you want to overwrite the file?", "Overwrite:", 0, 3)) {
                    files[0] = file;
                    pathStr = FileOpt.getParent(file).getAbsolutePath();
                    return true;
                }
                InfoPanel.message("Please specify another file name.");
                return false;
            }
            return false;
        }
        if (FileOpt.getParent(file).canWrite()) {
            files[0] = file;
            return true;
        }
        this.warn("Parent directory does not allow to create new file, reset");
        return false;
    }

    public boolean getWriteDir(File[] files) {
        String fstr = this.fileField.getText().trim();
        File file = new File(fstr);
        files[0] = null;
        if (file.exists()) {
            if (file.isFile()) {
                this.warn("It is not a directory, reset");
                return false;
            }
            if (file.isDirectory()) {
                if (0 == JOptionPane.showConfirmDialog(this, "Overwrite the directory or not ?", "Overwrite:", 0, 3)) {
                    files[0] = file;
                    pathStr = FileOpt.getParent(file).getAbsolutePath();
                    return true;
                }
                this.warn("Directory cannot overwrite, reset");
                return false;
            }
            return false;
        }
        if (FileOpt.getParent(file).canWrite()) {
            file.mkdir();
            files[0] = file;
            pathStr = FileOpt.getParent(file).getAbsolutePath();
            return true;
        }
        this.warn("Parent directory does not allow to create new directory, reset");
        return false;
    }

    public void setPath(String pathname) {
        this.fileField.setText(pathname);
    }

    public String getPath() {
        return this.fileField.getText().trim();
    }

    public void browseDir() {
        JFileChooser fc = new JFileChooser(pathStr);
        fc.setFileSelectionMode(2);
        if (this.exts != null) {
            FileFilter filter = new FileFilter(){

                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        for (int i = 0; i < BrowsePanel.this.exts.length; ++i) {
                            if (!BrowsePanel.this.exts[i].equals(".")) continue;
                            return true;
                        }
                    } else {
                        for (int i = 0; i < BrowsePanel.this.exts.length; ++i) {
                            if (!f.getName().toLowerCase().endsWith(BrowsePanel.this.exts[i])) continue;
                            return true;
                        }
                    }
                    return false;
                }

                public String getDescription() {
                    return null;
                }
            };
            fc.setFileFilter(filter);
        }
        File file = null;
        try {
            int option = fc.showOpenDialog(this);
            if (option == 0) {
                file = fc.getSelectedFile();
                this.fileField.setText(file.getAbsolutePath());
            }
            pathStr = file.isFile() ? file.getParent() : file.getAbsolutePath();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    public void setEnabled(boolean flag) {
        this.fileField.setEditable(flag);
        this.browseButton.setEnabled(flag);
    }

    protected void warn(String mesg) {
        JOptionPane.showMessageDialog(this, "Unexpected Error" + mesg, "Warning", 2);
    }
}

