/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.gui.jwidget;

import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.handle.apps.gui.jutil.BrowsePanel;
import net.handle.apps.gui.jutil.MyButton;

public class DataListJPanel
extends JPanel
implements ActionListener {
    public Vector items = new Vector();
    public JList itemList;
    public MyButton addItemButton = new MyButton("Add", "Add a new value");
    public MyButton remItemButton = new MyButton("Remove", "Remove the selected value");
    public MyButton editItemButton = new MyButton("Modify", "Modify the selected value");
    public MyButton viewItemButton = new MyButton("View", "View the selected value");
    public MyButton clearButton = new MyButton("Clear All", "Clear all values");
    public MyButton saveButton;
    public MyButton loadButton;
    public JPanel buttonPanel;
    public JPanel savePanel;
    public JScrollPane pane;

    public DataListJPanel() {
        super(new GridBagLayout());
        this.addItemButton.addActionListener(this);
        this.remItemButton.addActionListener(this);
        this.editItemButton.addActionListener(this);
        this.viewItemButton.addActionListener(this);
        this.clearButton.addActionListener(this);
        this.saveButton = new MyButton("Save", "Save current data");
        this.loadButton = new MyButton("Load", "Load data from file");
        this.saveButton.addActionListener(this);
        this.loadButton.addActionListener(this);
        this.itemList = new JList(this.items);
        this.itemList.setVisibleRowCount(8);
        this.itemList.setFixedCellWidth(200);
        this.pane = new JScrollPane(this.itemList);
    }

    public void actionPerformed(ActionEvent ae) {
        Object src = ae.getSource();
        if (src == this.addItemButton) {
            this.addItem();
        } else if (src == this.remItemButton) {
            this.removeItem();
        } else if (src == this.editItemButton) {
            this.modifyItem();
        } else if (src == this.viewItemButton) {
            this.viewItem();
        } else if (src == this.clearButton) {
            this.clearAll();
        } else if (src == this.saveButton) {
            this.saveToFile();
        } else if (src == this.loadButton) {
            this.loadFromFile();
        }
    }

    public Vector getItems() {
        return this.items;
    }

    public void setItems(Vector vt) {
        if (vt == null) {
            return;
        }
        this.clearAll();
        for (int i = 0; i < vt.size(); ++i) {
            this.items.addElement(vt.elementAt(i));
        }
        this.rebuildItemList();
    }

    public void appendItemVector(Vector vt) {
        if (vt == null) {
            return;
        }
        for (int i = 0; i < vt.size(); ++i) {
            this.items.addElement(vt.elementAt(i));
        }
        this.rebuildItemList();
    }

    public void appendItem(Object it) {
        if (it == null) {
            return;
        }
        this.items.addElement(it);
        this.rebuildItemList();
    }

    public void clearAll() {
        this.items.removeAllElements();
        this.rebuildItemList();
    }

    public void addItem() {
        Object it = this.addData();
        if (it != null) {
            this.items.addElement(it);
        }
        this.rebuildItemList();
    }

    public void modifyItem() {
        int ind = this.itemList.getSelectedIndex();
        if (ind < 0) {
            return;
        }
        Object it = this.modifyData(ind);
        if (it != null) {
            this.items.removeElementAt(ind);
            this.items.insertElementAt(it, ind);
        }
        this.rebuildItemList();
    }

    public void viewItem() {
        int ind = this.itemList.getSelectedIndex();
        if (ind < 0) {
            return;
        }
        this.viewData(ind);
    }

    public void removeItem() {
        int ind = this.itemList.getSelectedIndex();
        if (ind < 0) {
            return;
        }
        if (this.removeData(ind)) {
            this.items.removeElementAt(ind);
        }
        this.rebuildItemList();
    }

    public void rebuildItemList() {
        this.itemList.setListData(this.items);
    }

    public void saveToFile() {
        BrowsePanel browser = new BrowsePanel("save file: ", (File)null, "", null, true);
        File[] files = new File[1];
        Object out = null;
        if (2 == JOptionPane.showConfirmDialog(null, browser, "save values to file:", 2, -1)) {
            return;
        }
        if (!browser.getWriteFile(files)) {
            return;
        }
        this.writeData(files[0]);
    }

    public void loadFromFile() {
        BrowsePanel browser = new BrowsePanel("load file: ", (File)null, "", null, false);
        File[] files = new File[1];
        if (2 == JOptionPane.showConfirmDialog(null, browser, "load values from file: ", 2, -1)) {
            return;
        }
        if (!browser.getReadFile(files)) {
            return;
        }
        this.readData(files[0]);
    }

    public void warn(String message) {
        JOptionPane.showMessageDialog(this, "Warning:\n  " + message, "Warning:", 2);
    }

    public void info(String message) {
        JOptionPane.showMessageDialog(this, message);
    }

    protected Object addData() {
        return null;
    }

    protected Object modifyData(int ind) {
        return null;
    }

    protected void viewData(int ind) {
    }

    protected boolean removeData(int ind) {
        return true;
    }

    protected void readData(File file) {
    }

    protected void writeData(File file) {
    }
}

