/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.simple;

import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.Common;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ResolutionRequest;
import net.handle.hdllib.ResolutionResponse;
import net.handle.hdllib.Util;

public class HDLShowAdmin {
    public static final void main(String[] argv) throws Exception {
        String handleStr = argv[0];
        byte[] handle = Util.encodeString(handleStr);
        boolean isSubNAHandle = Util.isSubNAHandle(handle);
        System.err.println(" is sub-NA handle: " + isSubNAHandle);
        byte[] na = isSubNAHandle ? Util.getParentNAOfNAHandle(handle) : Util.getNAHandle(handle);
        System.err.println("responsible auth handle: " + Util.decodeString(na));
        byte[][] vals = HDLShowAdmin.getNAAdminValues(na);
        if (vals == null) {
            System.err.println("Unable to find admin group while creating handle");
        }
        HandleValue value = new HandleValue();
        for (int i = 0; i < vals.length; ++i) {
            Encoder.decodeHandleValue(vals[i], 0, value);
            System.err.println("value: " + value);
        }
    }

    public static byte[][] getNAAdminValues(byte[] na) throws Exception {
        ResolutionRequest authRequest = null;
        authRequest = new ResolutionRequest(na, Common.ADMIN_TYPES, null, null);
        authRequest.certify = true;
        AbstractResponse response = new HandleResolver().processRequest(authRequest);
        if (response.getClass() != ResolutionResponse.class) {
            return null;
        }
        return ((ResolutionResponse)response).values;
    }
}

