/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.security.PrivateKey;
import java.security.Signature;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.ChallengeResponse;
import net.handle.hdllib.Common;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.Util;

public class PublicKeyAuthenticationInfo
extends AuthenticationInfo {
    private PrivateKey privateKey;
    private byte[] userIdHandle;
    private int userIdIndex;

    public PublicKeyAuthenticationInfo(byte[] userIdHandle, int userIdIndex, PrivateKey privateKey) {
        this.privateKey = privateKey;
        this.userIdHandle = userIdHandle;
        this.userIdIndex = userIdIndex;
    }

    public byte[] getAuthType() {
        return Common.PUBLIC_KEY_TYPE;
    }

    public byte[] authenticate(ChallengeResponse challenge, AbstractRequest request) throws HandleException {
        byte[] origDigest = Util.doDigest(challenge.rdHashType, request.getEncodedMessageBody());
        if (!Util.equals(origDigest, challenge.requestDigest)) {
            throw new HandleException(10, "Asked to sign unidentified request!");
        }
        byte[] signatureBytes = null;
        byte[] sigHashType = null;
        try {
            Signature signer = null;
            String alg = this.privateKey.getAlgorithm().trim();
            if (alg.equalsIgnoreCase("DSA")) {
                signer = Signature.getInstance("SHA1withDSA");
            } else if (alg.equalsIgnoreCase("RSA")) {
                signer = Signature.getInstance("SHA1withRSA");
            } else {
                throw new HandleException(16, "Unknown key algorithm.");
            }
            signer.initSign(this.privateKey);
            signer.update(challenge.nonce);
            signer.update(challenge.requestDigest);
            signatureBytes = signer.sign();
            sigHashType = Util.getHashAlgIdFromSigId(signer.getAlgorithm());
            int offset = 0;
            byte[] signature = new byte[signatureBytes.length + sigHashType.length + 8];
            offset += Encoder.writeByteArray(signature, offset, sigHashType);
            offset += Encoder.writeByteArray(signature, offset, signatureBytes);
            return signature;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new HandleException(8, "Unable to sign challenge: " + e);
        }
    }

    public byte[] getUserIdHandle() {
        return this.userIdHandle;
    }

    public int getUserIdIndex() {
        return this.userIdIndex;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public String toString() {
        return "public_key:" + String.valueOf(this.userIdIndex) + ':' + (this.userIdHandle == null ? "null" : Util.decodeString(this.userIdHandle));
    }
}

