/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.io.File;
import java.io.FileReader;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.HashMap;
import net.cnri.simplexml.XParser;
import net.cnri.simplexml.XTag;
import net.handle.hdllib.AbstractMessage;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.ChallengeResponse;
import net.handle.hdllib.Common;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.ErrorResponse;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ResolutionRequest;
import net.handle.hdllib.ResolutionResponse;
import net.handle.hdllib.Util;
import net.handle.hdllib.VerifyAuthRequest;
import net.handle.hdllib.VerifyAuthResponse;

public class Resolver {
    private static final String[] PUBKEY_TYPES = new String[]{"HS_PUBKEY"};
    private File configDir;
    private File configFile;
    private long configTimestamp = -1L;
    private XTag config;
    private HashMap localHandles = new HashMap();
    private HashMap localHandlesCI = new HashMap();
    private HandleResolver resolver = new HandleResolver();
    private boolean secureMessages = false;
    private boolean authoritativeMessages = false;
    private AuthenticationInfo authenticationInfo = null;

    public Resolver() {
        this.configDir = new File(System.getProperty("user.home", "."), ".handle");
        this.configFile = new File(this.configDir, "resolver.xml");
        this.loadConfiguration();
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public void checkConfiguration() {
        try {
            if (!this.configDir.exists()) {
                return;
            }
            if (!this.configFile.exists()) {
                return;
            }
            if (this.configTimestamp == -1L || this.configFile.lastModified() > this.configTimestamp) {
                this.loadConfiguration();
            }
        }
        catch (Exception e) {
            System.err.println("Error checking config file timestamp: " + e);
        }
    }

    private void loadConfiguration() {
        XTag config = null;
        HashMap<String, ValueList> localHandles = new HashMap<String, ValueList>();
        HashMap<String, ValueList> localHandlesCI = new HashMap<String, ValueList>();
        try {
            XTag localHdlsTag;
            if (this.configFile.exists() && this.configFile.canRead() && (localHdlsTag = (config = new XParser().parse(new FileReader(this.configFile), false)).getSubTag("local_handles")) != null) {
                for (int i = 0; i < localHdlsTag.getSubTagCount(); ++i) {
                    XTag localHdlTag = localHdlsTag.getSubTag(i);
                    if (!localHdlTag.getName().equalsIgnoreCase("handle")) continue;
                    String handle = localHdlTag.getAttribute("handle");
                    if (handle == null || handle.trim().length() <= 0 || handle.indexOf(47) < 0) {
                        System.err.println("Invalid override handle: '" + handle + "' in " + localHdlTag);
                        continue;
                    }
                    ArrayList<HandleValue> valueList = new ArrayList<HandleValue>();
                    boolean caseSensitive = localHdlTag.getBoolAttribute("case_sensitive", true);
                    String overrideTypeStr = localHdlTag.getAttribute("override_type", "always");
                    int overrideType = overrideTypeStr.equalsIgnoreCase("on_failure") ? 1 : 0;
                    for (int j = 0; j < localHdlTag.getSubTagCount(); ++j) {
                        XTag hdlValTag = localHdlTag.getSubTag(j);
                        if (!hdlValTag.getName().equalsIgnoreCase("hdlvalue")) continue;
                        valueList.add(Resolver.getValueFromXML(hdlValTag));
                    }
                    ValueList hdlInfo = new ValueList(handle, overrideType, valueList.toArray(new HandleValue[valueList.size()]));
                    if (caseSensitive) {
                        localHandlesCI.put(handle.toLowerCase(), hdlInfo);
                        continue;
                    }
                    localHandles.put(handle, hdlInfo);
                }
            }
        }
        catch (Exception e) {
            System.err.println("Unable to load client config: " + e);
        }
        if (config == null) {
            config = new XTag("hsconfig");
        }
        this.config = config;
        this.localHandles = localHandles;
        this.localHandlesCI = localHandlesCI;
    }

    public HandleValue[] resolveHandle(String handle) throws HandleException {
        return this.resolveHandle(handle, null);
    }

    public HandleValue[] resolveHandle(String handle, String[] typeList) throws HandleException {
        return this.resolveHandle(handle, typeList, null, false);
    }

    public HandleValue[] resolveHandle(String handle, String[] typeList, boolean secure) throws HandleException {
        return this.resolveHandle(handle, typeList, null, secure);
    }

    public HandleValue[] resolveHandle(String handle, String[] typeList, int[] indexes, boolean secure) throws HandleException {
        this.checkConfiguration();
        byte[][] types = this.convertTypes(typeList);
        ValueList valList = (ValueList)this.localHandles.get(handle);
        if (valList == null) {
            valList = (ValueList)this.localHandlesCI.get(handle.toLowerCase());
        }
        if (valList != null && valList.getOverrideType() == 0) {
            return this.filterValues(valList.getValues(), types);
        }
        try {
            ResolutionRequest req = new ResolutionRequest(Util.encodeString(handle), types, indexes, this.authenticationInfo);
            this.assignProperties(req);
            if (secure) {
                req.certify = true;
            }
            AbstractResponse response = this.resolver.processRequest(req);
            this.verifyResponse(req, response);
            if (response.responseCode == 1) {
                return ((ResolutionResponse)response).getHandleValues();
            }
            if (response.responseCode == 100) {
                throw new HandleException(9, "Handle: '" + handle + "' was not found");
            }
            if (response instanceof ErrorResponse) {
                ErrorResponse eResponse = (ErrorResponse)response;
                String msg = Util.decodeString(eResponse.message);
                throw new HandleException(1, AbstractMessage.getResponseCodeMessage(response.responseCode) + ": " + msg);
            }
            throw new HandleException(1, AbstractMessage.getResponseCodeMessage(response.responseCode));
        }
        catch (HandleException e) {
            if (valList != null) {
                return this.filterValues(valList.getValues(), types);
            }
            throw e;
        }
    }

    public void setVerifyMessages(boolean verify) {
        this.secureMessages = verify;
    }

    public HandleResolver getResolver() {
        return this.resolver;
    }

    public PublicKey[] resolvePublicKeys(String handle) throws HandleException {
        HandleValue[] values = this.resolveHandle(handle, PUBKEY_TYPES, true);
        ArrayList<PublicKey> keys = new ArrayList<PublicKey>();
        for (int i = values.length - 1; i >= 0; --i) {
            if (!values[i].hasType(Common.STD_TYPE_HSPUBKEY)) continue;
            try {
                PublicKey pubkey = Util.getPublicKeyFromBytes(values[i].getData(), 0);
                if (pubkey == null) continue;
                keys.add(pubkey);
                continue;
            }
            catch (Exception e) {
                System.err.println("Error decoding public key from value: " + values[i] + "; error: " + e);
            }
        }
        return keys.toArray(new PublicKey[keys.size()]);
    }

    private void assignProperties(AbstractRequest req) {
        if (this.secureMessages) {
            req.certify = true;
        }
        if (this.authoritativeMessages) {
            req.authoritative = true;
        }
        req.authInfo = this.authenticationInfo;
    }

    private void verifyResponse(AbstractRequest req, AbstractResponse response) throws HandleException {
    }

    private byte[][] convertTypes(String[] filterTypes) {
        if (filterTypes == null) {
            return null;
        }
        byte[][] types = new byte[filterTypes.length][];
        for (int i = filterTypes.length - 1; i >= 0; --i) {
            types[i] = Util.encodeString(filterTypes[i]);
        }
        return types;
    }

    private HandleValue[] filterValues(HandleValue[] values, byte[][] types) {
        if (values == null || values.length == 0 || types == null || types.length == 0) {
            return values;
        }
        ArrayList<HandleValue> valueList = new ArrayList<HandleValue>();
        block0: for (int i = values.length - 1; i >= 0; --i) {
            if (values[i] == null) continue;
            for (int t = types.length - 1; t >= 0; --t) {
                if (!values[i].hasType(types[t])) continue;
                valueList.add(values[i]);
                continue block0;
            }
        }
        return valueList.toArray(new HandleValue[valueList.size()]);
    }

    public XTag getXMLForValue(HandleValue value) {
        if (value == null) {
            return null;
        }
        XTag valTag = new XTag("hdlvalue");
        valTag.setAttribute("type", value.getTypeAsString());
        valTag.setAttribute("admin_read", value.adminRead);
        valTag.setAttribute("admin_write", value.adminWrite);
        valTag.setAttribute("public_read", value.publicRead);
        valTag.setAttribute("public_write", value.publicWrite);
        valTag.setAttribute("ttl", value.getTTL());
        valTag.setAttribute("ttl_type", value.getTTLType() == 1 ? "absolute" : "relative");
        byte[] data = value.getData();
        if (Util.looksLikeBinary(data)) {
            valTag.setAttribute("encoding", "hex");
            valTag.setValue(Util.decodeHexString(data, false));
        } else {
            valTag.setAttribute("encoding", "text");
            valTag.setValue(Util.decodeString(data));
        }
        return valTag;
    }

    private static HandleValue getValueFromXML(XTag hdlValTag) throws Exception {
        HandleValue val = new HandleValue();
        val.setType(Util.encodeString(hdlValTag.getAttribute("type", "")));
        val.adminRead = hdlValTag.getBoolAttribute("admin_read", true);
        val.adminWrite = hdlValTag.getBoolAttribute("admin_write", true);
        val.publicRead = hdlValTag.getBoolAttribute("public_read", true);
        val.publicWrite = hdlValTag.getBoolAttribute("public_write", false);
        val.ttl = hdlValTag.getIntAttribute("ttl", 86400);
        val.ttlType = 0;
        if (hdlValTag.getAttribute("ttl_type", "relative").equalsIgnoreCase("absolute")) {
            val.ttlType = 1;
        }
        String dataEnc = hdlValTag.getAttribute("encoding", "text");
        val.setData(Resolver.getValueWithEncoding(hdlValTag.getStrValue(), dataEnc));
        return val;
    }

    private static final byte[] getValueWithEncoding(String str, String encoding) throws Exception {
        if ((encoding = encoding.toLowerCase()).equals("text")) {
            return Util.encodeString(str);
        }
        if (encoding.equals("hex")) {
            return Util.encodeHexString(str);
        }
        throw new Exception("Unrecognized encoding: " + encoding + " for data: " + str);
    }

    public boolean checkAuthentication(AuthenticationInfo authInfo) throws Exception {
        ResolutionRequest request = new ResolutionRequest(Common.BLANK_HANDLE, null, null, null);
        ChallengeResponse challengeResp = new ChallengeResponse(request);
        byte[] authBytes = authInfo.authenticate(challengeResp, request);
        if (Util.equals(authInfo.getAuthType(), Common.MD5_SECRET_KEY_TYPE)) {
            return this.verifySecretKeyAuth(authInfo, challengeResp, authBytes);
        }
        if (Util.equals(authInfo.getAuthType(), Common.PUBLIC_KEY_TYPE)) {
            return this.verifyPubKeyAuth(authInfo, challengeResp, authBytes);
        }
        throw new HandleException(8, "Unknown authentication type: " + Util.decodeString(authInfo.getAuthType()));
    }

    private boolean verifySecretKeyAuth(AuthenticationInfo authInfo, ChallengeResponse challengeResp, byte[] authBytes) throws HandleException {
        VerifyAuthRequest verifyAuthReq = new VerifyAuthRequest(authInfo.getUserIdHandle(), challengeResp.nonce, challengeResp.requestDigest, challengeResp.rdHashType, authBytes, authInfo.getUserIdIndex(), null);
        verifyAuthReq.certify = true;
        AbstractResponse response = this.resolver.processRequest(verifyAuthReq);
        if (response instanceof VerifyAuthResponse) {
            return ((VerifyAuthResponse)response).isValid;
        }
        throw new HandleException(8, "Unable to verify authentication\n" + response);
    }

    private boolean verifyPubKeyAuth(AuthenticationInfo authInfo, ChallengeResponse challengeResp, byte[] authBytes) throws Exception {
        boolean authenticated = false;
        ResolutionRequest request = new ResolutionRequest(authInfo.getUserIdHandle(), null, new int[]{authInfo.getUserIdIndex()}, null);
        request.certify = true;
        AbstractResponse response = this.resolver.processRequest(request);
        if (!(response instanceof ResolutionResponse)) {
            throw new HandleException(8, "Unable to verify authentication\n" + response);
        }
        byte[] pkBytes = null;
        HandleValue[] values = ((ResolutionResponse)response).getHandleValues();
        for (int i = 0; values != null && i < values.length; ++i) {
            if (values[i] == null || values[i].getIndex() != authInfo.getUserIdIndex()) continue;
            pkBytes = values[i].getData();
            break;
        }
        if (pkBytes == null) {
            throw new HandleException(8, "The admin index specified (" + authInfo.getUserIdHandle() + ") does not exist");
        }
        int offset = 0;
        byte[] hashAlgId = Encoder.readByteArray(authBytes, offset);
        byte[] sigBytes = Encoder.readByteArray(authBytes, offset += 4 + hashAlgId.length);
        offset += 4 + sigBytes.length;
        PublicKey pubKey = Util.getPublicKeyFromBytes(pkBytes, 0);
        if (pubKey instanceof DSAPublicKey) {
            return this.verifyDSAPublicKey(hashAlgId, pubKey, challengeResp, sigBytes);
        }
        if (pubKey instanceof RSAPublicKey) {
            return this.verifyRSAPublicKeyImpl(hashAlgId, pubKey, challengeResp, sigBytes);
        }
        throw new HandleException(8, "Unrecognized key type: " + pubKey);
    }

    private boolean verifyDSAPublicKey(byte[] hashAlgId, PublicKey pubKey, ChallengeResponse challengeResp, byte[] sigBytes) throws Exception {
        String sigId = Util.getSigIdFromHashAlgId(hashAlgId, pubKey.getAlgorithm());
        Signature sig = Signature.getInstance(sigId);
        sig.initVerify(pubKey);
        sig.update(challengeResp.nonce);
        sig.update(challengeResp.requestDigest);
        return sig.verify(sigBytes);
    }

    private boolean verifyRSAPublicKeyImpl(byte[] hashAlgId, PublicKey pubKey, ChallengeResponse challengeResp, byte[] sigBytes) throws Exception {
        String sigId = Util.getSigIdFromHashAlgId(hashAlgId, pubKey.getAlgorithm());
        Signature sig = Signature.getInstance(sigId);
        sig.initVerify(pubKey);
        sig.update(challengeResp.nonce);
        sig.update(challengeResp.requestDigest);
        return sig.verify(sigBytes);
    }

    private class ValueList {
        public static final int OVERRIDE_ALWAYS = 0;
        public static final int OVERRIDE_ON_FAILURE = 1;
        private int overrideType = 0;
        private String handle;
        private HandleValue[] values;

        ValueList(String handle, int overrideType, HandleValue[] values) {
            this.handle = handle;
            this.values = values;
            this.overrideType = overrideType;
        }

        public int getOverrideType() {
            return this.overrideType;
        }

        public String getHandle() {
            return this.handle;
        }

        public HandleValue[] getValues() {
            return this.values;
        }
    }
}

