/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PublicKey;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.Interface;
import net.handle.hdllib.Util;

public class ServerInfo {
    public int serverId;
    public byte[] ipAddress;
    public byte[] publicKey;
    public Interface[] interfaces;
    private String addrString = null;

    public Interface interfaceWithProtocol(int desiredProtocol, AbstractRequest req) {
        for (int i = 0; i < this.interfaces.length; ++i) {
            if (this.interfaces[i].protocol != desiredProtocol || !this.interfaces[i].canHandleRequest(req)) continue;
            return this.interfaces[i];
        }
        return null;
    }

    public InetAddress getInetAddress() throws UnknownHostException {
        return InetAddress.getByName(this.getAddressString());
    }

    public String getAddressString() {
        int i;
        if (this.addrString != null) {
            return this.addrString;
        }
        StringBuffer sb = new StringBuffer();
        if (this.ipAddress == null) {
            return "";
        }
        boolean ipv6 = false;
        int IPV6_ONLY = 12;
        for (i = 0; i < IPV6_ONLY; ++i) {
            if (this.ipAddress[i] == 0) continue;
            ipv6 = true;
            break;
        }
        if (ipv6) {
            for (i = 0; i < this.ipAddress.length; i += 2) {
                if (sb.length() > 0) {
                    sb.append(':');
                }
                sb.append(Util.decodeHexString(this.ipAddress, i, i + 2, false));
            }
        } else {
            for (i = IPV6_ONLY; i < this.ipAddress.length; ++i) {
                if (sb.length() > 0) {
                    sb.append('.');
                }
                sb.append(0xFF & this.ipAddress[i]);
            }
        }
        this.addrString = sb.toString();
        return this.addrString;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.serverId);
        sb.append(' ');
        sb.append(this.getAddressString());
        sb.append(' ');
        Interface[] ifcs = this.interfaces;
        boolean hasInterfaces = false;
        for (int i = 0; ifcs != null && i < ifcs.length; ++i) {
            Interface ifc = ifcs[i];
            if (ifc == null) continue;
            if (!hasInterfaces) {
                sb.append("(");
                hasInterfaces = true;
            } else {
                sb.append(",");
            }
            sb.append(Interface.protocolName(ifc.protocol));
            sb.append("/");
            sb.append(ifc.port);
        }
        if (hasInterfaces) {
            sb.append(")");
        }
        return sb.toString();
    }

    public ServerInfo cloneServerInfo() {
        ServerInfo si2 = new ServerInfo();
        si2.serverId = this.serverId;
        byte[] tmp = this.ipAddress;
        if (tmp != null) {
            si2.ipAddress = new byte[tmp.length];
            System.arraycopy(tmp, 0, si2.ipAddress, 0, tmp.length);
        } else {
            si2.ipAddress = null;
        }
        tmp = this.publicKey;
        if (tmp != null) {
            si2.publicKey = new byte[tmp.length];
            System.arraycopy(tmp, 0, si2.publicKey, 0, tmp.length);
        } else {
            si2.publicKey = null;
        }
        Interface[] tmpIA = this.interfaces;
        si2.interfaces = tmpIA == null ? null : new Interface[tmpIA.length];
        for (int i = 0; tmpIA != null && i < tmpIA.length; ++i) {
            Interface tmpI = tmpIA[i];
            si2.interfaces[i] = tmpI == null ? null : tmpI.cloneInterface();
        }
        return si2;
    }

    public PublicKey getPublicKey() throws Exception {
        return Util.getPublicKeyFromBytes(this.publicKey, 0);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ServerInfo)) {
            return false;
        }
        ServerInfo info = (ServerInfo)obj;
        if (this.serverId != info.serverId) {
            return false;
        }
        if (!Util.equals(info.ipAddress, this.ipAddress)) {
            return false;
        }
        if (this.interfaces == null && info.interfaces == null) {
            return true;
        }
        if (this.interfaces == null && info.interfaces != null) {
            return false;
        }
        if (this.interfaces != null && info.interfaces == null) {
            return false;
        }
        if (this.interfaces.length != info.interfaces.length) {
            return false;
        }
        for (int i = 0; i < this.interfaces.length; ++i) {
            if (this.interfaces[i].equals(info.interfaces[i])) continue;
            return false;
        }
        return true;
    }
}

