/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Random;
import javax.crypto.BadPaddingException;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import net.handle.hdllib.Common;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.NamespaceInfo;
import net.handle.hdllib.SiteInfo;
import net.handle.security.DHPublicKeyImpl;
import net.handle.security.HdlSecurityProvider;

public abstract class Util {
    private static MessageDigest[] md5;
    private static int nextMD5Idx;
    private static MessageDigest[] sha1;
    private static int nextSHA1Idx;
    private static boolean keyFactoryInitialized;
    private static Object keyFactoryInitLock;
    private static KeyFactory dsaKeyFactory;
    private static KeyFactory rsaKeyFactory;
    private static final char[] HEX_VALUES;
    public static final byte CASE_DIFF = -32;

    public static final boolean looksLikeBinary(byte[] buf) {
        if (buf == null) {
            return true;
        }
        for (int i = 0; i < buf.length; ++i) {
            byte b = buf[0];
            if (b >= 32 && b < 128 && b > 0) continue;
            return true;
        }
        return false;
    }

    public static final byte[] duplicateByteArray(byte[] buf) {
        if (buf == null) {
            return null;
        }
        byte[] newbuf = new byte[buf.length];
        System.arraycopy(buf, 0, newbuf, 0, newbuf.length);
        return newbuf;
    }

    public static final String decodeHexString(byte[] buf, int offset, int len, boolean formatNicely) {
        if (buf == null || buf.length <= 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = offset; i < offset + len; ++i) {
            if (formatNicely && i > 0 && i % 16 == 0) {
                sb.append('\n');
            }
            sb.append(HEX_VALUES[(buf[i] & 0xF0) >>> 4]);
            sb.append(HEX_VALUES[buf[i] & 0xF]);
        }
        return sb.toString();
    }

    public static final String decodeHexString(byte[] buf, boolean formatNicely) {
        return Util.decodeHexString(buf, 0, buf.length, formatNicely);
    }

    public static final byte[] encodeHexString(String s) {
        int i;
        s = s.toUpperCase().trim();
        byte[] buf = new byte[s.length() / 2 + 1];
        for (i = 0; i < buf.length; ++i) {
            buf[i] = 0;
        }
        i = 0;
        boolean lowNibble = false;
        for (int c = 0; c < s.length(); ++c) {
            char ch = s.charAt(c);
            if (ch >= '0' && ch <= '9') {
                if (lowNibble) {
                    int n = i++;
                    buf[n] = (byte)(buf[n] | ch - 48);
                } else {
                    buf[i] = (byte)(ch - 48 << 4);
                }
                lowNibble = !lowNibble;
                continue;
            }
            if (ch < 'A' || ch > 'F') continue;
            if (lowNibble) {
                int n = i++;
                buf[n] = (byte)(buf[n] | ch - 65 + 10);
            } else {
                buf[i] = (byte)(ch - 65 + 10 << 4);
            }
            lowNibble = !lowNibble;
        }
        byte[] realBuf = !lowNibble ? new byte[i] : new byte[i + 1];
        System.arraycopy(buf, 0, realBuf, 0, realBuf.length);
        return realBuf;
    }

    public static final byte[] encodeString(String s) {
        try {
            return s.getBytes("UTF8");
        }
        catch (Exception e) {
            System.err.println(e);
            return s.getBytes();
        }
    }

    public static final String decodeString(byte[] buf) {
        if (buf == null || buf.length == 0) {
            return "";
        }
        try {
            return new String(buf, "UTF8");
        }
        catch (Exception e) {
            System.err.println(e);
            return new String(buf);
        }
    }

    public static final String decodeString(byte[] buf, int offset, int len) {
        if (buf == null || buf.length == 0) {
            return "";
        }
        try {
            return new String(buf, offset, len, "UTF8");
        }
        catch (Exception e) {
            System.err.println(e);
            return new String(buf, offset, len);
        }
    }

    public static final boolean isValidString(byte[] buf, int offset, int len) {
        int byte2mask = 0;
        int trailing = 0;
        int i = offset;
        while (i < len) {
            byte c = buf[i++];
            if (trailing != 0) {
                if ((c & 0xC0) == 128) {
                    if (byte2mask != 0) {
                        if ((c & byte2mask) != 0) {
                            byte2mask = 0;
                        } else {
                            return false;
                        }
                    }
                    --trailing;
                    continue;
                }
                return false;
            }
            if ((c & 0x80) == 0) continue;
            if ((c & 0xE0) == 192) {
                if ((c & 0x1E) != 0) {
                    trailing = 1;
                    continue;
                }
                return false;
            }
            if ((c & 0xF0) == 224) {
                if ((c & 0xF) == 0) {
                    byte2mask = 32;
                }
                trailing = 2;
                continue;
            }
            if ((c & 0xF8) == 240) {
                if ((c & 7) == 0) {
                    byte2mask = 48;
                }
                trailing = 3;
                continue;
            }
            if ((c & 0xFC) == 248) {
                if ((c & 3) == 0) {
                    byte2mask = 56;
                }
                trailing = 4;
                continue;
            }
            if ((c & 0xFE) == 252) {
                if ((c & 1) == 0) {
                    byte2mask = 60;
                }
                trailing = 5;
                continue;
            }
            return false;
        }
        return trailing == 0;
    }

    public static final byte[] getNAHandle(byte[] handle) {
        int slashIndex = Util.indexOf(handle, (byte)47);
        if (slashIndex >= 0) {
            byte[] naHandle = new byte[slashIndex + Common.NA_HANDLE_PREFIX.length];
            System.arraycopy(Common.NA_HANDLE_PREFIX, 0, naHandle, 0, Common.NA_HANDLE_PREFIX.length);
            System.arraycopy(handle, 0, naHandle, Common.NA_HANDLE_PREFIX.length, slashIndex);
            Util.upperCaseInPlace(naHandle);
            return naHandle;
        }
        byte[] naHandle = new byte[Common.NA_HANDLE_PREFIX.length + handle.length];
        System.arraycopy(Common.NA_HANDLE_PREFIX, 0, naHandle, 0, Common.NA_HANDLE_PREFIX.length);
        System.arraycopy(handle, 0, naHandle, Common.NA_HANDLE_PREFIX.length, handle.length);
        Util.upperCaseInPlace(naHandle);
        return naHandle;
    }

    public static final String getNAHandle(String handle) {
        if (handle == null) {
            return new String(Common.ROOT_HANDLE);
        }
        if (handle.startsWith("0.")) {
            return new String(Common.ROOT_HANDLE);
        }
        int slashIndex = handle.indexOf(47);
        if (slashIndex >= 0) {
            return "0.NA/" + handle.substring(0, slashIndex).toUpperCase();
        }
        return "0.NA/" + handle.toUpperCase();
    }

    public static final boolean isSubNAHandle(byte[] handle) {
        if (Util.startsWithCI(handle, Common.NA_HANDLE_PREFIX)) {
            byte dot = 46;
            for (int i = Common.NA_HANDLE_PREFIX.length; i < handle.length; ++i) {
                if (handle[i] != dot) continue;
                return true;
            }
        }
        return false;
    }

    public static final byte[] getParentNAOfNAHandle(byte[] naHandle) {
        int parentEndIdx;
        int slashIdx = Util.indexOf(naHandle, (byte)47);
        byte dot = 46;
        for (parentEndIdx = naHandle.length - 1; parentEndIdx > slashIdx; --parentEndIdx) {
            if (naHandle[parentEndIdx] != dot) continue;
            --parentEndIdx;
            break;
        }
        byte[] parentNAHandle = new byte[Common.NA_HANDLE_PREFIX.length + (parentEndIdx - slashIdx)];
        int loc = 0;
        System.arraycopy(Common.NA_HANDLE_PREFIX, 0, parentNAHandle, loc, Common.NA_HANDLE_PREFIX.length);
        System.arraycopy(naHandle, slashIdx + 1, parentNAHandle, Common.NA_HANDLE_PREFIX.length, parentEndIdx - slashIdx);
        return parentNAHandle;
    }

    public static final byte[] getNAPart(byte[] handle) {
        int slashIndex = Util.indexOf(handle, (byte)47);
        return slashIndex < 0 ? handle : Util.substring(handle, 0, slashIndex);
    }

    public static final byte[] getIDPart(byte[] handle) {
        int slashIndex = Util.indexOf(handle, (byte)47);
        return slashIndex < 0 ? new byte[]{} : Util.substring(handle, slashIndex + 1, handle.length);
    }

    public static final boolean startsWith(byte[] b1, byte[] b2) {
        if (b1.length < b2.length) {
            return false;
        }
        for (int i = 0; i < b2.length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    public static final boolean equals(byte[] b1, byte[] b2) {
        if (b1 == null && b2 == null) {
            return true;
        }
        if (b1 == null || b2 == null) {
            return false;
        }
        if (b1.length != b2.length) {
            return false;
        }
        for (int i = 0; i < b1.length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    public static final boolean equals(byte[] b1, int b1Start, byte[] b2, int b2Start) {
        if (b1 == null && b2 == null) {
            return true;
        }
        if (b1 == null || b2 == null) {
            return false;
        }
        if (b1.length - b1Start != b2.length - b2Start) {
            return false;
        }
        while (b1Start < b1.length) {
            if (b1[b1Start] != b2[b2Start]) {
                return false;
            }
            ++b1Start;
            ++b2Start;
        }
        return true;
    }

    public static final byte[] upperCase(byte[] b) {
        if (b == null || b.length == 0) {
            return new byte[0];
        }
        int sz = b.length;
        byte[] b2 = new byte[sz];
        System.arraycopy(b, 0, b2, 0, sz);
        for (int i = sz - 1; i >= 0; --i) {
            if (b2[i] < 97 || b2[i] > 122) continue;
            int n = i;
            b2[n] = (byte)(b2[n] + -32);
        }
        return b2;
    }

    public static final byte[] upperCaseInPlace(byte[] b) {
        if (b == null || b.length == 0) {
            return b;
        }
        for (int i = 0; i < b.length; ++i) {
            if (b[i] < 97 || b[i] > 122) continue;
            int n = i;
            b[n] = (byte)(b[n] + -32);
        }
        return b;
    }

    public static final boolean equalsCI(byte[] b1, byte[] b2) {
        if (b1 == null && b2 == null) {
            return true;
        }
        if (b1 == null || b2 == null) {
            return false;
        }
        return Util.equalsCI(b1, b1.length, b2, b2.length);
    }

    public static final boolean equalsCI(byte[] b1, int b1Len, byte[] b2, int b2Len) {
        if (b1 == null && b2 == null) {
            return true;
        }
        if (b1 == null || b2 == null) {
            return false;
        }
        if (b1Len != b2Len || b1Len > b1.length || b2Len > b2.length) {
            return false;
        }
        for (int i = 0; i < b1Len; ++i) {
            byte byte1 = b1[i];
            byte byte2 = b2[i];
            if (byte1 == byte2) continue;
            if (byte1 >= 97 && byte1 <= 122) {
                byte1 = (byte)(byte1 - 32);
            }
            if (byte2 >= 97 && byte2 <= 122) {
                byte2 = (byte)(byte2 - 32);
            }
            if (byte1 == byte2) continue;
            return false;
        }
        return true;
    }

    public static final boolean startsWithCI(byte[] b1, byte[] b2) {
        if (b1.length < b2.length) {
            return false;
        }
        for (int i = 0; i < b2.length; ++i) {
            byte byte1 = b1[i];
            byte byte2 = b2[i];
            if (byte1 == byte2) continue;
            if (byte1 >= 97 && byte1 <= 122) {
                byte1 = (byte)(byte1 - 32);
            }
            if (byte2 >= 97 && byte2 <= 122) {
                byte2 = (byte)(byte2 - 32);
            }
            if (byte1 == byte2) continue;
            return false;
        }
        return true;
    }

    public static final byte[] substring(byte[] b, int i1) {
        return Util.substring(b, i1, b.length);
    }

    public static final byte[] substring(byte[] b, int i1, int i2) {
        byte[] rb = new byte[i2 - i1];
        System.arraycopy(b, i1, rb, 0, i2 - i1);
        return rb;
    }

    public static final int indexOf(byte[] b, byte ch) {
        for (int i = 0; i < b.length; ++i) {
            if (b[i] != ch) continue;
            return i;
        }
        return -1;
    }

    public static final int countValuesOfType(HandleValue[] values, byte[] type) {
        if (values == null) {
            return 0;
        }
        int matches = 0;
        for (int i = 0; i < values.length; ++i) {
            if (!Util.equals(values[i].type, type)) continue;
            ++matches;
        }
        return matches;
    }

    public static final boolean isParentTypeInArray(byte[][] a, byte[] val) {
        if (a == null) {
            return false;
        }
        if (val == null || val.length <= 0) {
            return false;
        }
        for (int i = a.length - 1; i >= 0; --i) {
            byte[] queryType = a[i];
            if (queryType.length > 0 && queryType[queryType.length - 1] == 46) {
                if (Util.startsWithCI(val, queryType)) {
                    return true;
                }
                if (!Util.equalsCI(queryType, queryType.length - 1, val, val.length)) continue;
                return true;
            }
            if (!Util.equalsCI(queryType, val)) continue;
            return true;
        }
        return false;
    }

    public static final boolean isInArray(int[] a, int val) {
        if (a == null) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != val) continue;
            return true;
        }
        return false;
    }

    public static final boolean isInArray(byte[][] a, byte[] val) {
        if (a == null) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (!Util.equals(a[i], val)) continue;
            return true;
        }
        return false;
    }

    public static SiteInfo[] getSitesFromValues(HandleValue[] values) {
        int numSites = Util.countValuesOfType(values, Common.SITE_INFO_TYPE);
        if (numSites > 0) {
            int siteNum = 0;
            SiteInfo[] sites = new SiteInfo[numSites];
            for (int i = 0; i < values.length; ++i) {
                if (!Util.equals(values[i].type, Common.SITE_INFO_TYPE)) continue;
                sites[siteNum] = new SiteInfo();
                try {
                    Encoder.decodeSiteInfoRecord(values[i].data, 0, sites[siteNum]);
                    ++siteNum;
                    continue;
                }
                catch (Throwable e) {
                    System.err.println("Error decoding site record: " + e);
                    e.printStackTrace(System.err);
                    sites[siteNum] = null;
                }
            }
            return sites;
        }
        return null;
    }

    public static NamespaceInfo getNamespaceFromValues(HandleValue[] values) {
        NamespaceInfo nsInfo = null;
        int currentNSIdx = 0;
        for (int i = 0; values != null && i < values.length; ++i) {
            if (values[i] == null || !values[i].hasType(Common.NAMESPACE_INFO_TYPE) || nsInfo != null && values[i].index >= currentNSIdx) continue;
            try {
                nsInfo = new NamespaceInfo(values[i]);
                currentNSIdx = values[i].index;
                continue;
            }
            catch (HandleException e) {
                System.err.println("Error decoding namespace info: " + e);
            }
        }
        return nsInfo;
    }

    public static final SiteInfo[] orderSitesByPreference(SiteInfo[] sites) {
        String preferredGlobal;
        int i;
        if (sites == null) {
            return new SiteInfo[0];
        }
        Random r = new Random();
        int randomIdx = 0;
        float randomNum = 0.0f;
        float[] ranges = new float[sites.length];
        for (int j = 1; j < sites.length; ++j) {
            for (int k = 0; k < sites.length - 1; ++k) {
                if (sites[k].responseTime <= sites[k + 1].responseTime) continue;
                SiteInfo temp = sites[k];
                sites[k] = sites[k + 1];
                sites[k + 1] = temp;
            }
        }
        if (sites[0].responseTime == 0L) {
            sites[0].responseTime = 1L;
        }
        if (sites[sites.length - 1].responseTime == 0L) {
            sites[sites.length - 1].responseTime = 1L;
        }
        ranges[0] = (float)(10.0 * (double)sites[sites.length - 1].responseTime / (double)sites[0].responseTime);
        for (i = 1; i < sites.length; ++i) {
            if (sites[i].responseTime == 0L) {
                sites[i].responseTime = 1L;
            }
            ranges[i] = ranges[i - 1] + (float)(10.0 * (double)sites[sites.length - 1].responseTime / (double)sites[i].responseTime);
        }
        randomNum = (float)Math.abs(r.nextInt()) % ranges[sites.length - 1];
        for (i = 0; i < sites.length; ++i) {
            if (!(randomNum <= ranges[i])) continue;
            randomIdx = i;
            break;
        }
        if (randomIdx != 0) {
            SiteInfo temp = sites[0];
            sites[0] = sites[randomIdx];
            sites[randomIdx] = temp;
        }
        if ((preferredGlobal = System.getProperty("hdllib.preferredGlobal")) != null) {
            for (int j = 0; j < sites.length; ++j) {
                for (int i2 = 0; i2 < sites[j].servers.length; ++i2) {
                    if (!preferredGlobal.equals(sites[j].servers[i2].getAddressString())) continue;
                    SiteInfo temp = sites[0];
                    sites[0] = sites[j];
                    sites[j] = temp;
                }
            }
        }
        return sites;
    }

    public static final byte[] getPassphrase(String prompt) throws Exception {
        int input;
        byte[] passphrase = new byte[2048];
        int charIdx = 0;
        long endTime = System.currentTimeMillis() + 1000L;
        while (System.currentTimeMillis() < endTime && System.in.available() > 0) {
            System.in.read();
        }
        System.out.println(prompt);
        System.out.println("Note: Your passphrase will be displayed as it is entered");
        System.out.flush();
        while ((input = System.in.read()) >= 0 && input != 10 && input != 13) {
            passphrase[charIdx++] = (byte)input;
        }
        byte[] secKey = new byte[charIdx];
        System.arraycopy(passphrase, 0, secKey, 0, charIdx);
        for (int i = 0; i < passphrase.length; ++i) {
            passphrase[i] = 0;
        }
        return secKey;
    }

    public static byte[] getHashAlgIdFromSigId(String signatureAlgorithm) throws HandleException {
        if (signatureAlgorithm.startsWith("SHA")) {
            return Common.HASH_ALG_SHA1;
        }
        if (signatureAlgorithm.startsWith("MD5")) {
            return Common.HASH_ALG_MD5;
        }
        throw new HandleException(13, "Unknown signature algorithm: " + signatureAlgorithm);
    }

    public static String getSigIdFromHashAlgId(byte[] hashAlgId, String sigKeyType) throws HandleException {
        if (Util.equals(hashAlgId, Common.HASH_ALG_SHA1)) {
            return "SHA1with" + sigKeyType;
        }
        if (Util.equals(hashAlgId, Common.HASH_ALG_MD5)) {
            return "MD5with" + sigKeyType;
        }
        throw new HandleException(13, "Unknown hash algorithm ID: " + Util.decodeString(hashAlgId));
    }

    public static byte[] getBytesFromPrivateKey(PrivateKey key) throws Exception {
        if (key instanceof DSAPrivateKey) {
            DSAPrivateKey dsaKey = (DSAPrivateKey)key;
            byte[] x = dsaKey.getX().toByteArray();
            DSAParams params = dsaKey.getParams();
            byte[] p = params.getP().toByteArray();
            byte[] q = params.getQ().toByteArray();
            byte[] g = params.getG().toByteArray();
            byte[] enc = new byte[20 + Common.KEY_ENCODING_DSA_PRIVATE.length + x.length + p.length + q.length + g.length];
            int loc = 0;
            loc += Encoder.writeByteArray(enc, loc, Common.KEY_ENCODING_DSA_PRIVATE);
            loc += Encoder.writeByteArray(enc, loc, x);
            loc += Encoder.writeByteArray(enc, loc, p);
            loc += Encoder.writeByteArray(enc, loc, q);
            loc += Encoder.writeByteArray(enc, loc, g);
            return enc;
        }
        if (key instanceof RSAPrivateKey) {
            RSAPrivateKey rsaKey = (RSAPrivateKey)key;
            if (rsaKey instanceof RSAPrivateCrtKey) {
                RSAPrivateCrtKey rsacrtKey = (RSAPrivateCrtKey)rsaKey;
                byte[] x = rsacrtKey.getModulus().toByteArray();
                byte[] ex = rsacrtKey.getPrivateExponent().toByteArray();
                byte[] pubEx = rsacrtKey.getPublicExponent().toByteArray();
                byte[] p = rsacrtKey.getPrimeP().toByteArray();
                byte[] q = rsacrtKey.getPrimeQ().toByteArray();
                byte[] exP = rsacrtKey.getPrimeExponentP().toByteArray();
                byte[] exQ = rsacrtKey.getPrimeExponentQ().toByteArray();
                byte[] coeff = rsacrtKey.getCrtCoefficient().toByteArray();
                byte[] enc = new byte[36 + Common.KEY_ENCODING_RSACRT_PRIVATE.length + x.length + ex.length + pubEx.length + p.length + q.length + exP.length + exQ.length + coeff.length];
                int loc = 0;
                loc += Encoder.writeByteArray(enc, loc, Common.KEY_ENCODING_RSACRT_PRIVATE);
                loc += Encoder.writeByteArray(enc, loc, x);
                loc += Encoder.writeByteArray(enc, loc, pubEx);
                loc += Encoder.writeByteArray(enc, loc, ex);
                loc += Encoder.writeByteArray(enc, loc, p);
                loc += Encoder.writeByteArray(enc, loc, q);
                loc += Encoder.writeByteArray(enc, loc, exP);
                loc += Encoder.writeByteArray(enc, loc, exQ);
                loc += Encoder.writeByteArray(enc, loc, coeff);
                return enc;
            }
            byte[] x = rsaKey.getModulus().toByteArray();
            byte[] y = rsaKey.getPrivateExponent().toByteArray();
            byte[] enc = new byte[12 + Common.KEY_ENCODING_RSA_PRIVATE.length + x.length + y.length];
            int loc = 0;
            loc += Encoder.writeByteArray(enc, loc, Common.KEY_ENCODING_RSA_PRIVATE);
            loc += Encoder.writeByteArray(enc, loc, x);
            loc += Encoder.writeByteArray(enc, loc, y);
            return enc;
        }
        throw new HandleException(0, "Unknown private key type: \"" + key + '\"');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void initKeyFactories() {
        if (!keyFactoryInitialized) {
            Object object = keyFactoryInitLock;
            synchronized (object) {
                if (!keyFactoryInitialized) {
                    try {
                        dsaKeyFactory = KeyFactory.getInstance("DSA");
                    }
                    catch (Exception e) {
                        System.err.println("Error acquiring DSA key factory: " + e);
                    }
                    try {
                        rsaKeyFactory = KeyFactory.getInstance("RSA");
                    }
                    catch (Exception e) {
                        System.err.println("Error acquiring RSA key factory: " + e);
                    }
                    keyFactoryInitialized = true;
                }
            }
        }
    }

    public static PrivateKey getPrivateKeyFromBytes(byte[] pkBuf, int offset) throws Exception {
        Util.initKeyFactories();
        byte[] keyType = Encoder.readByteArray(pkBuf, offset);
        offset += 4 + keyType.length;
        if (Util.equals(keyType, Common.KEY_ENCODING_DSA_PRIVATE)) {
            byte[] x = Encoder.readByteArray(pkBuf, offset);
            byte[] p = Encoder.readByteArray(pkBuf, offset += 4 + x.length);
            byte[] q = Encoder.readByteArray(pkBuf, offset += 4 + p.length);
            byte[] g = Encoder.readByteArray(pkBuf, offset += 4 + q.length);
            offset += 4 + g.length;
            if (dsaKeyFactory == null) {
                throw new HandleException(26, "DSA encryption not available");
            }
            DSAPrivateKeySpec keySpec = new DSAPrivateKeySpec(new BigInteger(1, x), new BigInteger(1, p), new BigInteger(1, q), new BigInteger(1, g));
            return dsaKeyFactory.generatePrivate(keySpec);
        }
        if (Util.equals(keyType, Common.KEY_ENCODING_RSA_PRIVATE)) {
            byte[] m = Encoder.readByteArray(pkBuf, offset);
            byte[] exp = Encoder.readByteArray(pkBuf, offset += 4 + m.length);
            offset += 4 + exp.length;
            if (rsaKeyFactory == null) {
                throw new HandleException(26, "DSA encryption not available");
            }
            RSAPrivateKeySpec keySpec = new RSAPrivateKeySpec(new BigInteger(1, m), new BigInteger(1, exp));
            return rsaKeyFactory.generatePrivate(keySpec);
        }
        if (Util.equals(keyType, Common.KEY_ENCODING_RSACRT_PRIVATE)) {
            byte[] n = Encoder.readByteArray(pkBuf, offset);
            byte[] pubEx = Encoder.readByteArray(pkBuf, offset += 4 + n.length);
            byte[] ex = Encoder.readByteArray(pkBuf, offset += 4 + pubEx.length);
            byte[] p = Encoder.readByteArray(pkBuf, offset += 4 + ex.length);
            byte[] q = Encoder.readByteArray(pkBuf, offset += 4 + p.length);
            byte[] exP = Encoder.readByteArray(pkBuf, offset += 4 + q.length);
            byte[] exQ = Encoder.readByteArray(pkBuf, offset += 4 + exP.length);
            byte[] coeff = Encoder.readByteArray(pkBuf, offset += 4 + exQ.length);
            offset += 4 + coeff.length;
            if (rsaKeyFactory == null) {
                throw new HandleException(26, "DSA encryption not available");
            }
            RSAPrivateCrtKeySpec keySpec = new RSAPrivateCrtKeySpec(new BigInteger(1, n), new BigInteger(1, pubEx), new BigInteger(1, ex), new BigInteger(1, p), new BigInteger(1, q), new BigInteger(1, exP), new BigInteger(1, exQ), new BigInteger(1, coeff));
            return rsaKeyFactory.generatePrivate(keySpec);
        }
        throw new HandleException(0, "Unknown format for private key: \"" + Util.decodeString(keyType) + '\"');
    }

    public static byte[] getBytesFromPublicKey(PublicKey key) throws Exception {
        int flags = 0;
        if (key instanceof DSAPublicKey) {
            DSAPublicKey dsaKey = (DSAPublicKey)key;
            byte[] y = dsaKey.getY().toByteArray();
            DSAParams params = dsaKey.getParams();
            byte[] p = params.getP().toByteArray();
            byte[] q = params.getQ().toByteArray();
            byte[] g = params.getG().toByteArray();
            byte[] enc = new byte[20 + Common.KEY_ENCODING_DSA_PUBLIC.length + 2 + y.length + p.length + q.length + g.length];
            int loc = 0;
            loc += Encoder.writeByteArray(enc, loc, Common.KEY_ENCODING_DSA_PUBLIC);
            loc += Encoder.writeInt2(enc, loc, flags);
            loc += Encoder.writeByteArray(enc, loc, q);
            loc += Encoder.writeByteArray(enc, loc, p);
            loc += Encoder.writeByteArray(enc, loc, g);
            loc += Encoder.writeByteArray(enc, loc, y);
            return enc;
        }
        if (key instanceof RSAPublicKey) {
            RSAPublicKey rsaKey = (RSAPublicKey)key;
            byte[] m = rsaKey.getModulus().toByteArray();
            byte[] ex = rsaKey.getPublicExponent().toByteArray();
            byte[] enc = new byte[16 + m.length + ex.length + 2 + Common.KEY_ENCODING_RSA_PUBLIC.length];
            int loc = 0;
            loc += Encoder.writeByteArray(enc, loc, Common.KEY_ENCODING_RSA_PUBLIC);
            loc += Encoder.writeInt2(enc, loc, flags);
            loc += Encoder.writeByteArray(enc, loc, ex);
            loc += Encoder.writeByteArray(enc, loc, m);
            return enc;
        }
        if (key instanceof DHPublicKey) {
            DHPublicKey dhKey = (DHPublicKey)key;
            DHParameterSpec dhSpec = dhKey.getParams();
            byte[] y = dhKey.getY().toByteArray();
            byte[] p = dhSpec.getP().toByteArray();
            byte[] g = dhSpec.getG().toByteArray();
            byte[] enc = new byte[y.length + g.length + p.length + 16 + Common.KEY_ENCODING_DH_PUBLIC.length + 2];
            int offset = Encoder.writeByteArray(enc, 0, Common.KEY_ENCODING_DH_PUBLIC);
            offset += Encoder.writeInt2(enc, offset, flags);
            offset += Encoder.writeByteArray(enc, offset, y);
            offset += Encoder.writeByteArray(enc, offset, p);
            offset += Encoder.writeByteArray(enc, offset, g);
            return enc;
        }
        throw new HandleException(0, "Unknown public key type: \"" + key + '\"');
    }

    public static PublicKey getPublicKeyFromFile(String filename) throws Exception {
        File f = new File(filename);
        FileInputStream in = new FileInputStream(f);
        byte[] buf = new byte[(int)f.length()];
        in.read(buf);
        return Util.getPublicKeyFromBytes(buf, 0);
    }

    public static PublicKey getPublicKeyFromBytes(byte[] pkBuf, int offset) throws Exception {
        Util.initKeyFactories();
        byte[] keyType = Encoder.readByteArray(pkBuf, offset);
        int flags = Encoder.readInt2(pkBuf, offset += 4 + keyType.length);
        offset += 2;
        if (Util.equals(keyType, Common.KEY_ENCODING_DSA_PUBLIC)) {
            byte[] q = Encoder.readByteArray(pkBuf, offset);
            byte[] p = Encoder.readByteArray(pkBuf, offset += 4 + q.length);
            byte[] g = Encoder.readByteArray(pkBuf, offset += 4 + p.length);
            byte[] y = Encoder.readByteArray(pkBuf, offset += 4 + g.length);
            offset += 4 + y.length;
            Util.initKeyFactories();
            if (dsaKeyFactory == null) {
                throw new HandleException(26, "DSA encryption not available");
            }
            DSAPublicKeySpec keySpec = new DSAPublicKeySpec(new BigInteger(1, y), new BigInteger(1, p), new BigInteger(1, q), new BigInteger(1, g));
            return dsaKeyFactory.generatePublic(keySpec);
        }
        if (Util.equals(keyType, Common.KEY_ENCODING_RSA_PUBLIC)) {
            byte[] ex = Encoder.readByteArray(pkBuf, offset);
            byte[] m = Encoder.readByteArray(pkBuf, offset += 4 + ex.length);
            offset += 4 + m.length;
            Util.initKeyFactories();
            if (rsaKeyFactory == null) {
                throw new HandleException(26, "RSA encryption not available");
            }
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(new BigInteger(1, m), new BigInteger(1, ex));
            return rsaKeyFactory.generatePublic(keySpec);
        }
        if (Util.equals(keyType, Common.KEY_ENCODING_DH_PUBLIC)) {
            byte[] y = Encoder.readByteArray(pkBuf, offset);
            byte[] p = Encoder.readByteArray(pkBuf, offset += 4 + y.length);
            byte[] g = Encoder.readByteArray(pkBuf, offset += 4 + p.length);
            offset += 4 + g.length;
            return new DHPublicKeyImpl(new BigInteger(1, y), new BigInteger(1, p), new BigInteger(1, g));
        }
        throw new HandleException(0, "Unknown format for public key: \"" + Util.decodeString(keyType) + '\"');
    }

    public static byte[] encrypt(byte[] cleartext, byte[] secretKey) throws Exception {
        return Util.encrypt(cleartext, secretKey, 0);
    }

    public static byte[] encrypt(byte[] cleartext, byte[] secretKey, int encType) throws Exception {
        if (secretKey != null) {
            secretKey = Util.doMD5Digest(secretKey);
        }
        HdlSecurityProvider cryptoProvider = HdlSecurityProvider.getInstance();
        switch (encType) {
            case 0: {
                if (cryptoProvider == null) {
                    throw new HandleException(14, "Encryption engine missing");
                }
                byte[] enc = cryptoProvider.encrypt_DES_ECB_PKCS5(cleartext, 0, cleartext.length, secretKey);
                byte[] enc2 = new byte[enc.length + 4];
                Encoder.writeInt(enc2, 0, encType);
                System.arraycopy(enc, 0, enc2, 4, enc.length);
                return enc2;
            }
            case 1: {
                System.err.println("Warning: data not encrypted");
                byte[] enc2 = new byte[cleartext.length + 4];
                Encoder.writeInt(enc2, 0, encType);
                System.arraycopy(cleartext, 0, enc2, 4, cleartext.length);
                return enc2;
            }
        }
        throw new HandleException(16, "Unknown algorithm ID: " + encType);
    }

    public static byte[] encryptIfPossible(byte[] cleartext, byte[] secretKey) throws Exception {
        try {
            return Util.encrypt(cleartext, secretKey, 0);
        }
        catch (HandleException e) {
            if (e.getCode() == 14) {
                return Util.encrypt(cleartext, secretKey, 1);
            }
            throw e;
        }
    }

    public static final boolean requiresSecretKey(byte[] ciphertext) throws Exception {
        int encryptionType = Encoder.readInt(ciphertext, 0);
        return encryptionType != 1;
    }

    public static byte[] decrypt(byte[] ciphertext, byte[] secretKey) throws Exception {
        if (secretKey != null) {
            secretKey = Util.doMD5Digest(secretKey);
        }
        HdlSecurityProvider cryptoProvider = HdlSecurityProvider.getInstance();
        int encryptionType = Encoder.readInt(ciphertext, 0);
        switch (encryptionType) {
            case 0: {
                if (cryptoProvider == null) {
                    throw new HandleException(14, "Encryption engine missing");
                }
                try {
                    return cryptoProvider.decrypt_DES_ECB_PKCS5(ciphertext, 4, ciphertext.length - 4, secretKey);
                }
                catch (BadPaddingException e) {
                    e.printStackTrace(System.err);
                    throw new Exception("Incorrect passphrase");
                }
            }
            case 1: {
                byte[] cleartext = new byte[ciphertext.length - 4];
                System.arraycopy(ciphertext, 4, cleartext, 0, cleartext.length);
                return cleartext;
            }
        }
        throw new HandleException(0, "Unknown encryption type code: " + encryptionType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final synchronized MessageDigest getSHA1Digest() throws HandleException {
        if (sha1 == null) {
            throw new HandleException(14, "SHA1 algorithm not found");
        }
        MessageDigest[] messageDigestArray = sha1;
        synchronized (sha1) {
            nextSHA1Idx = nextSHA1Idx <= 0 ? sha1.length - 1 : nextSHA1Idx - 1;
            // ** MonitorExit[var0] (shouldn't be in output)
            return sha1[nextSHA1Idx];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] doSHA1Digest(byte[] buf) throws HandleException {
        MessageDigest digest;
        MessageDigest messageDigest = digest = Util.getSHA1Digest();
        synchronized (messageDigest) {
            return digest.digest(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] doSHA1Digest(byte[] buf1, byte[] buf2, byte[] buf3, byte[] buf4) throws HandleException {
        MessageDigest digest;
        MessageDigest messageDigest = digest = Util.getSHA1Digest();
        synchronized (messageDigest) {
            digest.update(buf1);
            digest.update(buf2);
            digest.update(buf3);
            digest.update(buf4);
            return digest.digest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final synchronized MessageDigest getMD5Digest() throws HandleException {
        if (md5 == null) {
            throw new HandleException(14, "MD5 algorithm not found");
        }
        MessageDigest[] messageDigestArray = md5;
        synchronized (md5) {
            nextMD5Idx = nextMD5Idx <= 0 ? md5.length - 1 : nextMD5Idx - 1;
            // ** MonitorExit[var0] (shouldn't be in output)
            return md5[nextMD5Idx];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] doMD5Digest(byte[] buf) throws HandleException {
        MessageDigest digest;
        MessageDigest messageDigest = digest = Util.getMD5Digest();
        synchronized (messageDigest) {
            return digest.digest(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] doMD5Digest(byte[] buf1, byte[] buf2, byte[] buf3, byte[] buf4) throws HandleException {
        MessageDigest digest;
        MessageDigest messageDigest = digest = Util.getMD5Digest();
        synchronized (messageDigest) {
            digest.update(buf1);
            digest.update(buf2);
            digest.update(buf3);
            digest.update(buf4);
            return digest.digest();
        }
    }

    public static final byte[] doDigest(byte digestAlg, byte[] buf1, byte[] buf2, byte[] buf3, byte[] buf4) throws HandleException {
        switch (digestAlg) {
            case 2: {
                return Util.doSHA1Digest(buf1, buf2, buf3, buf4);
            }
            case 0: 
            case 1: {
                return Util.doMD5Digest(buf1, buf2, buf3, buf4);
            }
        }
        throw new HandleException(0, "Invalid hash type: " + digestAlg);
    }

    public static final byte[] doDigest(byte digestType, byte[] buf) throws HandleException {
        switch (digestType) {
            case 2: {
                return Util.doSHA1Digest(buf);
            }
            case 0: 
            case 1: {
                return Util.doMD5Digest(buf);
            }
        }
        throw new HandleException(0, "Invalid hash type: " + digestType);
    }

    public static void sortNumberArray(Number[] a) {
        Util.quicksortAscending(a, 0, a.length - 1);
    }

    private static void quicksortAscending(Number[] a, int first, int last) {
        if (first < last) {
            int piv_index = Util.partitionAscending(a, first, last);
            Util.quicksortAscending(a, first, piv_index - 1);
            Util.quicksortAscending(a, piv_index, last);
        }
    }

    private static int partitionAscending(Number[] a, int first, int last) {
        Number pivot = a[(first + last) / 2];
        while (first <= last) {
            while (a[first].doubleValue() < pivot.doubleValue()) {
                ++first;
            }
            while (a[last].doubleValue() > pivot.doubleValue()) {
                --last;
            }
            if (first > last) continue;
            Number temp = a[first];
            a[first] = a[last];
            a[last] = temp;
            ++first;
            --last;
        }
        return first;
    }

    public static byte[] encrypt(PublicKey encryptingKey, byte[] secretKey) throws Exception {
        HdlSecurityProvider cryptoProvider = HdlSecurityProvider.getInstance();
        if (cryptoProvider == null) {
            throw new HandleException(14, "Encryption/Key generation engine missing");
        }
        return cryptoProvider.encrypt_RSA_ECB_PKCS1(secretKey, 0, secretKey.length, (RSAPublicKey)encryptingKey);
    }

    public static byte[] getBytesFromFile(String file) {
        return Util.getBytesFromFile(new File(file));
    }

    public static byte[] getBytesFromFile(File file) {
        byte[] rawKey = null;
        try {
            rawKey = new byte[(int)file.length()];
            FileInputStream in = new FileInputStream(file);
            int r = 0;
            for (int n = 0; n < rawKey.length && (r = ((InputStream)in).read(rawKey, n, rawKey.length - n)) > 0; n += r) {
            }
            ((InputStream)in).close();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return rawKey;
    }

    public static boolean writeBytesToFile(String file, byte[] keyBytes) {
        return Util.writeBytesToFile(new File(file), keyBytes);
    }

    public static boolean writeBytesToFile(File file, byte[] keyBytes) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            out.write(keyBytes);
            out.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return false;
        }
    }

    public static boolean isMatchingKeyPair(PublicKey pubkey, PrivateKey privkey) throws HandleException {
        if (pubkey == null && privkey != null) {
            return false;
        }
        if (pubkey != null && privkey == null) {
            return false;
        }
        if (pubkey == null && privkey == null) {
            return true;
        }
        try {
            byte[] toBeSigned = new byte[2048];
            new Random().nextBytes(toBeSigned);
            Signature sig = Signature.getInstance(privkey.getAlgorithm());
            sig.initSign(privkey);
            sig.update(toBeSigned);
            byte[] signatureBytes = sig.sign();
            Signature vsig = Signature.getInstance(pubkey.getAlgorithm());
            sig.initVerify(pubkey);
            sig.update(toBeSigned);
            return sig.verify(signatureBytes);
        }
        catch (Exception e) {
            if (e instanceof HandleException) {
                throw (HandleException)e;
            }
            throw new HandleException(13, "Error checking keys: " + e);
        }
    }

    public static byte[] decrypt(PrivateKey privKey, byte[] ciphertext) throws HandleException {
        HdlSecurityProvider cryptoProvider = HdlSecurityProvider.getInstance();
        if (cryptoProvider == null) {
            throw new HandleException(14, "Encryption/Key generation engine missing. Session failed.");
        }
        if (privKey != null && privKey instanceof RSAPrivateKey) {
            try {
                return cryptoProvider.decrypt_RSA_ECB_PKCS1(ciphertext, 0, ciphertext.length, (RSAPrivateKey)privKey);
            }
            catch (Exception e) {
                throw new HandleException(1, "Error decrypting: " + e);
            }
        }
        throw new HandleException(1, "Unsupported key for decrypt: " + privKey);
    }

    public static boolean checkJavaVersion() {
        String version = System.getProperty("java.version").substring(0, 3);
        if ("1.4".compareTo(version) > 0) {
            System.err.println("\nError: Java version 1.4 or greater is required; this is version " + version + ".\n" + "See " + "http://hdl.handle.net/4263537/4066" + " to obtain an up-to-date version.\n");
            return false;
        }
        return true;
    }

    static {
        int i;
        md5 = null;
        sha1 = null;
        keyFactoryInitialized = false;
        keyFactoryInitLock = new Object();
        dsaKeyFactory = null;
        rsaKeyFactory = null;
        md5 = new MessageDigest[10];
        try {
            for (i = 0; i < md5.length; ++i) {
                Util.md5[i] = MessageDigest.getInstance("MD5");
                md5[i].reset();
            }
            nextMD5Idx = md5.length - 1;
        }
        catch (NoSuchAlgorithmException e) {
            md5 = null;
        }
        try {
            sha1 = new MessageDigest[10];
            for (i = 0; i < sha1.length; ++i) {
                Util.sha1[i] = MessageDigest.getInstance("SHA-1");
                sha1[i].reset();
            }
            nextSHA1Idx = sha1.length - 1;
        }
        catch (NoSuchAlgorithmException e) {
            sha1 = null;
        }
        HEX_VALUES = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }
}

